/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.queue;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.utils.ConcurrentHashMapUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class QueueOffsetAssigner {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private ConcurrentMap<String, Long> topicQueueTable = new ConcurrentHashMap<String, Long>(1024);
    private ConcurrentMap<String, Long> batchTopicQueueTable = new ConcurrentHashMap<String, Long>(1024);
    private ConcurrentMap<String, Long> lmqTopicQueueTable = new ConcurrentHashMap<String, Long>(1024);

    public long assignQueueOffset(String topicQueueKey, short messageNum) {
        Long queueOffset = (Long)ConcurrentHashMapUtils.computeIfAbsent(this.topicQueueTable, (Object)topicQueueKey, k -> 0L);
        this.topicQueueTable.put(topicQueueKey, queueOffset + (long)messageNum);
        return queueOffset;
    }

    public void updateQueueOffset(String topicQueueKey, long offset) {
        this.topicQueueTable.put(topicQueueKey, offset);
    }

    public long assignBatchQueueOffset(String topicQueueKey, short messageNum) {
        Long topicOffset = (Long)ConcurrentHashMapUtils.computeIfAbsent(this.batchTopicQueueTable, (Object)topicQueueKey, k -> 0L);
        this.batchTopicQueueTable.put(topicQueueKey, topicOffset + (long)messageNum);
        return topicOffset;
    }

    public long assignLmqOffset(String topicQueueKey, short messageNum) {
        Long topicOffset = (Long)ConcurrentHashMapUtils.computeIfAbsent(this.lmqTopicQueueTable, (Object)topicQueueKey, k -> 0L);
        this.lmqTopicQueueTable.put(topicQueueKey, topicOffset + (long)messageNum);
        return topicOffset;
    }

    public long currentQueueOffset(String topicQueueKey) {
        return (Long)this.topicQueueTable.get(topicQueueKey);
    }

    public long currentBatchQueueOffset(String topicQueueKey) {
        return (Long)this.batchTopicQueueTable.get(topicQueueKey);
    }

    public long currentLmqOffset(String topicQueueKey) {
        return (Long)this.lmqTopicQueueTable.get(topicQueueKey);
    }

    public synchronized void remove(String topic, Integer queueId) {
        String topicQueueKey = topic + "-" + queueId;
        this.topicQueueTable.remove(topicQueueKey);
        this.batchTopicQueueTable.remove(topicQueueKey);
        this.lmqTopicQueueTable.remove(topicQueueKey);
        log.info("removeQueueFromTopicQueueTable OK Topic: {} QueueId: {}", (Object)topic, (Object)queueId);
    }

    public void setTopicQueueTable(ConcurrentMap<String, Long> topicQueueTable) {
        this.topicQueueTable = topicQueueTable;
    }

    public void setLmqTopicQueueTable(ConcurrentMap<String, Long> lmqTopicQueueTable) {
        ConcurrentHashMap<String, Long> table = new ConcurrentHashMap<String, Long>(1024);
        for (Map.Entry entry : lmqTopicQueueTable.entrySet()) {
            if (!MixAll.isLmq((String)((String)entry.getKey()))) continue;
            table.put((String)entry.getKey(), (Long)entry.getValue());
        }
        this.lmqTopicQueueTable = table;
    }

    public ConcurrentMap<String, Long> getTopicQueueTable() {
        return this.topicQueueTable;
    }

    public void setBatchTopicQueueTable(ConcurrentMap<String, Long> batchTopicQueueTable) {
        this.batchTopicQueueTable = batchTopicQueueTable;
    }
}

