/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.store.DefaultMessageStore;

public class MultiDispatch {
    private final StringBuilder keyBuilder = new StringBuilder();
    private final DefaultMessageStore messageStore;
    private static final short VALUE_OF_EACH_INCREMENT = 1;

    public MultiDispatch(DefaultMessageStore messageStore) {
        this.messageStore = messageStore;
    }

    public String queueKey(String queueName, MessageExtBrokerInner msgInner) {
        this.keyBuilder.delete(0, this.keyBuilder.length());
        this.keyBuilder.append(queueName);
        this.keyBuilder.append('-');
        int queueId = msgInner.getQueueId();
        if (this.messageStore.getMessageStoreConfig().isEnableLmq() && MixAll.isLmq((String)queueName)) {
            queueId = 0;
        }
        this.keyBuilder.append(queueId);
        return this.keyBuilder.toString();
    }

    public void wrapMultiDispatch(MessageExtBrokerInner msg) {
        String multiDispatchQueue = msg.getProperty("INNER_MULTI_DISPATCH");
        String[] queues = multiDispatchQueue.split(",");
        Object[] queueOffsets = new Long[queues.length];
        if (this.messageStore.getMessageStoreConfig().isEnableLmq()) {
            for (int i = 0; i < queues.length; ++i) {
                String key = this.queueKey(queues[i], msg);
                if (!MixAll.isLmq((String)key)) continue;
                queueOffsets[i] = this.messageStore.getQueueStore().getLmqQueueOffset(key);
            }
        }
        MessageAccessor.putProperty((Message)msg, (String)"INNER_MULTI_QUEUE_OFFSET", (String)StringUtils.join((Object[])queueOffsets, (String)","));
        msg.removeWaitStorePropertyString();
    }

    public void updateMultiQueueOffset(MessageExtBrokerInner msgInner) {
        String[] queues;
        String multiDispatchQueue = msgInner.getProperty("INNER_MULTI_DISPATCH");
        for (String queue : queues = multiDispatchQueue.split(",")) {
            String key = this.queueKey(queue, msgInner);
            if (!this.messageStore.getMessageStoreConfig().isEnableLmq() || !MixAll.isLmq((String)key)) continue;
            this.messageStore.getQueueStore().increaseLmqOffset(key, (short)1);
        }
    }
}

