/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.queue;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.BoundaryType;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.utils.DataConverter;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.config.StorePathConfigHelper;
import org.apache.rocketmq.store.queue.AbstractConsumeQueueStore;
import org.apache.rocketmq.store.queue.ConsumeQueueInterface;
import org.apache.rocketmq.store.queue.RocksDBConsumeQueue;
import org.apache.rocketmq.store.queue.RocksDBConsumeQueueOffsetTable;
import org.apache.rocketmq.store.queue.RocksDBConsumeQueueTable;
import org.apache.rocketmq.store.rocksdb.ConsumeQueueRocksDBStorage;
import org.rocksdb.RocksDBException;
import org.rocksdb.Statistics;
import org.rocksdb.WriteBatch;

public class RocksDBConsumeQueueStore
extends AbstractConsumeQueueStore {
    private static final Logger ERROR_LOG = LoggerFactory.getLogger((String)"RocketmqStoreError");
    private static final Logger ROCKSDB_LOG = LoggerFactory.getLogger((String)"RocketmqRocksDB");
    public static final byte CTRL_0 = 0;
    public static final byte CTRL_1 = 1;
    public static final byte CTRL_2 = 2;
    private final int batchSize;
    public static final int MAX_KEY_LEN = 300;
    private final ScheduledExecutorService scheduledExecutorService;
    private final String storePath = StorePathConfigHelper.getStorePathConsumeQueue(this.messageStoreConfig.getStorePathRootDir());
    private final ConsumeQueueRocksDBStorage rocksDBStorage;
    private final RocksDBConsumeQueueTable rocksDBConsumeQueueTable;
    private final RocksDBConsumeQueueOffsetTable rocksDBConsumeQueueOffsetTable;
    private final WriteBatch writeBatch;
    private final List<DispatchRequest> bufferDRList;
    private final List<Pair<ByteBuffer, ByteBuffer>> cqBBPairList;
    private final List<Pair<ByteBuffer, ByteBuffer>> offsetBBPairList;
    private final Map<ByteBuffer, Pair<ByteBuffer, DispatchRequest>> tempTopicQueueMaxOffsetMap;
    private volatile boolean isCQError = false;

    public RocksDBConsumeQueueStore(DefaultMessageStore messageStore) {
        super(messageStore);
        this.rocksDBStorage = new ConsumeQueueRocksDBStorage(messageStore, this.storePath, 4);
        this.rocksDBConsumeQueueTable = new RocksDBConsumeQueueTable(this.rocksDBStorage, messageStore);
        this.rocksDBConsumeQueueOffsetTable = new RocksDBConsumeQueueOffsetTable(this.rocksDBConsumeQueueTable, this.rocksDBStorage, messageStore);
        this.writeBatch = new WriteBatch();
        this.batchSize = this.messageStoreConfig.getBatchWriteKvCqSize();
        this.bufferDRList = new ArrayList<DispatchRequest>(this.batchSize);
        this.cqBBPairList = new ArrayList<Pair<ByteBuffer, ByteBuffer>>(this.batchSize);
        this.offsetBBPairList = new ArrayList<Pair<ByteBuffer, ByteBuffer>>(this.batchSize);
        for (int i = 0; i < this.batchSize; ++i) {
            this.cqBBPairList.add(RocksDBConsumeQueueTable.getCQByteBufferPair());
            this.offsetBBPairList.add(RocksDBConsumeQueueOffsetTable.getOffsetByteBufferPair());
        }
        this.tempTopicQueueMaxOffsetMap = new HashMap<ByteBuffer, Pair<ByteBuffer, DispatchRequest>>();
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("RocksDBConsumeQueueStoreScheduledThread", messageStore.getBrokerIdentity()));
    }

    @Override
    public void start() {
        log.info("RocksDB ConsumeQueueStore start!");
        this.scheduledExecutorService.scheduleAtFixedRate(() -> this.rocksDBStorage.statRocksdb(ROCKSDB_LOG), 10L, this.messageStoreConfig.getStatRocksDBCQIntervalSec(), TimeUnit.SECONDS);
        this.scheduledExecutorService.scheduleWithFixedDelay(() -> this.cleanDirty(this.messageStore.getTopicConfigs().keySet()), 10L, this.messageStoreConfig.getCleanRocksDBDirtyCQIntervalMin(), TimeUnit.MINUTES);
    }

    private void cleanDirty(Set<String> existTopicSet) {
        try {
            Map<String, Set<Integer>> topicQueueIdToBeDeletedMap = this.rocksDBConsumeQueueOffsetTable.iterateOffsetTable2FindDirty(existTopicSet);
            for (Map.Entry<String, Set<Integer>> entry : topicQueueIdToBeDeletedMap.entrySet()) {
                String topic = entry.getKey();
                for (int queueId : entry.getValue()) {
                    this.destroy(new RocksDBConsumeQueue(topic, queueId));
                }
            }
        }
        catch (Exception e) {
            log.error("cleanUnusedTopic Failed.", (Throwable)e);
        }
    }

    @Override
    public boolean load() {
        boolean result = this.rocksDBStorage.start();
        this.rocksDBConsumeQueueTable.load();
        this.rocksDBConsumeQueueOffsetTable.load();
        log.info("load rocksdb consume queue {}.", (Object)(result ? "OK" : "Failed"));
        return result;
    }

    @Override
    public boolean loadAfterDestroy() {
        return this.load();
    }

    @Override
    public void recover() {
    }

    @Override
    public boolean recoverConcurrently() {
        return true;
    }

    @Override
    public boolean shutdown() {
        this.scheduledExecutorService.shutdown();
        return this.shutdownInner();
    }

    private boolean shutdownInner() {
        return this.rocksDBStorage.shutdown();
    }

    @Override
    public void putMessagePositionInfoWrapper(DispatchRequest request) throws RocksDBException {
        if (request == null || this.bufferDRList.size() >= this.batchSize) {
            this.putMessagePosition();
        }
        if (request != null) {
            this.bufferDRList.add(request);
        }
    }

    public void putMessagePosition() throws RocksDBException {
        int maxRetries = 30;
        for (int i = 0; i < 30; ++i) {
            if (this.putMessagePosition0()) {
                if (this.isCQError) {
                    this.messageStore.getRunningFlags().clearLogicsQueueError();
                    this.isCQError = false;
                }
                return;
            }
            ERROR_LOG.warn("{} put cq Failed. retryTime: {}", (Object)i);
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.isCQError) {
            ERROR_LOG.error("[BUG] put CQ Failed.");
            this.messageStore.getRunningFlags().makeLogicsQueueError();
            this.isCQError = true;
        }
        throw new RocksDBException("put CQ Failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putMessagePosition0() {
        if (!this.rocksDBStorage.hold()) {
            return false;
        }
        Map<ByteBuffer, Pair<ByteBuffer, DispatchRequest>> tempTopicQueueMaxOffsetMap = this.tempTopicQueueMaxOffsetMap;
        try {
            List<DispatchRequest> bufferDRList = this.bufferDRList;
            int size = bufferDRList.size();
            if (size == 0) {
                boolean bl = true;
                return bl;
            }
            List<Pair<ByteBuffer, ByteBuffer>> cqBBPairList = this.cqBBPairList;
            List<Pair<ByteBuffer, ByteBuffer>> offsetBBPairList = this.offsetBBPairList;
            WriteBatch writeBatch = this.writeBatch;
            long maxPhyOffset = 0L;
            for (int i = size - 1; i >= 0; --i) {
                DispatchRequest request = bufferDRList.get(i);
                byte[] topicBytes = request.getTopic().getBytes(DataConverter.CHARSET_UTF8);
                this.rocksDBConsumeQueueTable.buildAndPutCQByteBuffer(cqBBPairList.get(i), topicBytes, request, writeBatch);
                this.rocksDBConsumeQueueOffsetTable.updateTempTopicQueueMaxOffset(offsetBBPairList.get(i), topicBytes, request, tempTopicQueueMaxOffsetMap);
                int msgSize = request.getMsgSize();
                long phyOffset = request.getCommitLogOffset();
                if (phyOffset + (long)msgSize < maxPhyOffset) continue;
                maxPhyOffset = phyOffset + (long)msgSize;
            }
            this.rocksDBConsumeQueueOffsetTable.putMaxPhyAndCqOffset(tempTopicQueueMaxOffsetMap, writeBatch, maxPhyOffset);
            this.rocksDBStorage.batchPut(writeBatch);
            this.rocksDBConsumeQueueOffsetTable.putHeapMaxCqOffset(tempTopicQueueMaxOffsetMap);
            long storeTimeStamp = bufferDRList.get(size - 1).getStoreTimestamp();
            if (this.messageStore.getMessageStoreConfig().getBrokerRole() == BrokerRole.SLAVE || this.messageStore.getMessageStoreConfig().isEnableDLegerCommitLog()) {
                this.messageStore.getStoreCheckpoint().setPhysicMsgTimestamp(storeTimeStamp);
            }
            this.messageStore.getStoreCheckpoint().setLogicsMsgTimestamp(storeTimeStamp);
            this.notifyMessageArriveAndClear();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            ERROR_LOG.error("putMessagePosition0 Failed.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            tempTopicQueueMaxOffsetMap.clear();
            this.rocksDBStorage.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyMessageArriveAndClear() {
        List<DispatchRequest> bufferDRList = this.bufferDRList;
        try {
            for (DispatchRequest dp : bufferDRList) {
                this.messageStore.notifyMessageArriveIfNecessary(dp);
            }
        }
        catch (Exception e) {
            ERROR_LOG.error("notifyMessageArriveAndClear Failed.", (Throwable)e);
        }
        finally {
            bufferDRList.clear();
        }
    }

    public Statistics getStatistics() {
        return this.rocksDBStorage.getStatistics();
    }

    @Override
    public List<ByteBuffer> rangeQuery(String topic, int queueId, long startIndex, int num) throws RocksDBException {
        return this.rocksDBConsumeQueueTable.rangeQuery(topic, queueId, startIndex, num);
    }

    @Override
    public ByteBuffer get(String topic, int queueId, long cqOffset) throws RocksDBException {
        return this.rocksDBConsumeQueueTable.getCQInKV(topic, queueId, cqOffset);
    }

    @Override
    public void recoverOffsetTable(long minPhyOffset) {
    }

    @Override
    public void destroy() {
        try {
            this.shutdownInner();
            FileUtils.deleteDirectory((File)new File(this.storePath));
        }
        catch (Exception e) {
            ERROR_LOG.error("destroy cq Failed. {}", (Object)this.storePath, (Object)e);
        }
    }

    @Override
    public void destroy(ConsumeQueueInterface consumeQueue) throws RocksDBException {
        String topic = consumeQueue.getTopic();
        int queueId = consumeQueue.getQueueId();
        if (StringUtils.isEmpty((CharSequence)topic) || queueId < 0 || !this.rocksDBStorage.hold()) {
            return;
        }
        WriteBatch writeBatch = new WriteBatch();
        try {
            this.rocksDBConsumeQueueTable.destroyCQ(topic, queueId, writeBatch);
            this.rocksDBConsumeQueueOffsetTable.destroyOffset(topic, queueId, writeBatch);
            this.rocksDBStorage.batchPut(writeBatch);
        }
        catch (RocksDBException e) {
            ERROR_LOG.error("kv deleteTopic {} Failed.", (Object)topic, (Object)e);
            throw e;
        }
        finally {
            writeBatch.close();
            this.rocksDBStorage.release();
        }
    }

    @Override
    public boolean flush(ConsumeQueueInterface consumeQueue, int flushLeastPages) {
        try {
            this.rocksDBStorage.flushWAL();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void checkSelf() {
    }

    @Override
    public int deleteExpiredFile(ConsumeQueueInterface consumeQueue, long minCommitLogPos) {
        return 0;
    }

    @Override
    public void truncateDirty(long offsetToTruncate) throws RocksDBException {
        long maxPhyOffsetInRocksdb = this.getMaxPhyOffsetInConsumeQueue();
        if (offsetToTruncate >= maxPhyOffsetInRocksdb) {
            return;
        }
        this.rocksDBConsumeQueueOffsetTable.truncateDirty(offsetToTruncate);
    }

    @Override
    public void cleanExpired(long minPhyOffset) {
        this.rocksDBStorage.manualCompaction(minPhyOffset);
    }

    @Override
    public long getOffsetInQueueByTime(String topic, int queueId, long timestamp, BoundaryType boundaryType) throws RocksDBException {
        long minPhysicOffset = this.messageStore.getMinPhyOffset();
        long low = this.rocksDBConsumeQueueOffsetTable.getMinCqOffset(topic, queueId);
        Long high = this.rocksDBConsumeQueueOffsetTable.getMaxCqOffset(topic, queueId);
        if (high == null || high == -1L) {
            return 0L;
        }
        return this.rocksDBConsumeQueueTable.binarySearchInCQByTime(topic, queueId, high, low, timestamp, minPhysicOffset, boundaryType);
    }

    @Override
    public long getMaxOffsetInQueue(String topic, int queueId) throws RocksDBException {
        Long maxOffset = this.rocksDBConsumeQueueOffsetTable.getMaxCqOffset(topic, queueId);
        return maxOffset != null ? maxOffset + 1L : 0L;
    }

    @Override
    public long getMinOffsetInQueue(String topic, int queueId) throws RocksDBException {
        return this.rocksDBConsumeQueueOffsetTable.getMinCqOffset(topic, queueId);
    }

    @Override
    public Long getMaxPhyOffsetInConsumeQueue(String topic, int queueId) {
        return this.rocksDBConsumeQueueOffsetTable.getMaxPhyOffset(topic, queueId);
    }

    @Override
    public long getMaxPhyOffsetInConsumeQueue() throws RocksDBException {
        return this.rocksDBConsumeQueueOffsetTable.getMaxPhyOffset();
    }

    @Override
    public ConsumeQueueInterface findOrCreateConsumeQueue(String topic, int queueId) {
        ConsumeQueueInterface logic;
        ConcurrentMap<Integer, RocksDBConsumeQueue> map = (ConcurrentHashMap<Integer, RocksDBConsumeQueue>)this.consumeQueueTable.get(topic);
        if (null == map) {
            ConcurrentHashMap<Integer, RocksDBConsumeQueue> newMap = new ConcurrentHashMap<Integer, RocksDBConsumeQueue>(128);
            ConcurrentMap oldMap = this.consumeQueueTable.putIfAbsent(topic, newMap);
            map = oldMap != null ? oldMap : newMap;
        }
        if ((logic = (ConsumeQueueInterface)map.get(queueId)) != null) {
            return logic;
        }
        RocksDBConsumeQueue newLogic = new RocksDBConsumeQueue(this.messageStore, topic, queueId);
        ConsumeQueueInterface oldLogic = map.putIfAbsent(queueId, newLogic);
        return oldLogic != null ? oldLogic : newLogic;
    }

    @Override
    public long rollNextFile(ConsumeQueueInterface consumeQueue, long offset) {
        return 0L;
    }

    @Override
    public boolean isFirstFileExist(ConsumeQueueInterface consumeQueue) {
        return true;
    }

    @Override
    public boolean isFirstFileAvailable(ConsumeQueueInterface consumeQueue) {
        return true;
    }

    @Override
    public long getTotalSize() {
        return 0L;
    }
}

