/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.mxml;

import java.util.Collection;
import org.apache.royale.compiler.internal.mxml.EntityProcessor;
import org.apache.royale.compiler.internal.mxml.MXMLDialect;
import org.apache.royale.compiler.internal.mxml.MXMLUnitData;
import org.apache.royale.compiler.internal.parsing.ISourceFragment;
import org.apache.royale.compiler.internal.parsing.SourceFragment;
import org.apache.royale.compiler.internal.parsing.mxml.MXMLToken;
import org.apache.royale.compiler.mxml.IMXMLTextData;
import org.apache.royale.compiler.problems.ICompilerProblem;

public class MXMLTextData
extends MXMLUnitData
implements IMXMLTextData {
    private String text;
    private IMXMLTextData.TextType type;

    public MXMLTextData(MXMLToken textToken) {
        this.text = textToken.getText();
        this.setOffsets(textToken.getStart(), textToken.getEnd());
        this.setLine(textToken.getLine());
        this.setColumn(textToken.getColumn());
        this.setEndLine(textToken.getEndLine());
        this.setEndColumn(textToken.getEndColumn());
        switch (textToken.getType()) {
            case 12: {
                this.type = IMXMLTextData.TextType.TEXT;
                break;
            }
            case 13: {
                this.type = IMXMLTextData.TextType.WHITESPACE;
                break;
            }
            case 2: {
                this.type = IMXMLTextData.TextType.CDATA;
                break;
            }
            case 4: {
                this.type = IMXMLTextData.TextType.COMMENT;
                break;
            }
            case 1: {
                this.type = IMXMLTextData.TextType.ASDOC;
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getTextType());
        sb.append(' ');
        sb.append('\"');
        sb.append(this.getEscapedContent());
        sb.append('\"');
        sb.append(' ');
        sb.append(super.toString());
        return sb.toString();
    }

    @Override
    public boolean isText() {
        return true;
    }

    @Override
    public String getTypeString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getTypeString());
        sb.append(":");
        sb.append((Object)this.getTextType());
        return sb.toString();
    }

    @Override
    public String toDumpString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toDumpString());
        sb.append('\t');
        sb.append('|');
        sb.append(this.getEscapedContent());
        sb.append('|');
        return sb.toString();
    }

    @Override
    public String getContent() {
        return this.text;
    }

    @Override
    public IMXMLTextData.TextType getTextType() {
        return this.type;
    }

    private String getEscapedContent() {
        String s = this.getContent();
        s = s.replaceAll("\n", "\\\\n");
        s = s.replaceAll("\r", "\\\\r");
        s = s.replaceAll("\t", "\\\\t");
        return s;
    }

    @Override
    public String getCompilableText() {
        switch (this.type) {
            case TEXT: 
            case CDATA: 
            case WHITESPACE: {
                return this.getContents();
            }
            case ASDOC: 
            case COMMENT: {
                return "";
            }
        }
        assert (false);
        return null;
    }

    @Override
    public int getCompilableTextStart() {
        return this.getContentsStart();
    }

    @Override
    public int getCompilableTextEnd() {
        return this.getContentsEnd();
    }

    @Override
    public int getCompilableTextLine() {
        return this.getLine();
    }

    @Override
    public int getCompilableTextColumn() {
        return this.getContentsStart() - this.getAbsoluteStart() + this.getColumn();
    }

    public String getContents() {
        String tokenString = this.text;
        switch (this.type) {
            case CDATA: {
                tokenString = tokenString.endsWith("]]>") ? tokenString.substring("<![CDATA[".length(), tokenString.length() - "]]>".length()) : tokenString.substring("<![CDATA[".length());
                return tokenString;
            }
            case ASDOC: {
                tokenString = tokenString.endsWith("-->") ? tokenString.substring("<!---".length(), tokenString.length() - "-->".length()) : tokenString.substring("<!---".length());
                return tokenString;
            }
            case COMMENT: {
                tokenString = tokenString.endsWith("-->") ? tokenString.substring("<!--".length(), tokenString.length() - "-->".length()) : tokenString.substring("<!--".length());
                return tokenString;
            }
        }
        return this.text;
    }

    public int getContentsStart() {
        switch (this.type) {
            case CDATA: {
                return this.getAbsoluteStart() + "<![CDATA[".length();
            }
            case ASDOC: {
                return this.getAbsoluteStart() + "<!---".length();
            }
            case COMMENT: {
                return this.getAbsoluteStart() + "<!--".length();
            }
        }
        return this.getAbsoluteStart();
    }

    public int getContentsEnd() {
        switch (this.type) {
            case CDATA: {
                return this.text.endsWith("]]>") ? this.getAbsoluteEnd() - "]]>".length() : this.getAbsoluteEnd();
            }
            case ASDOC: {
                return this.text.endsWith("-->") ? this.getAbsoluteEnd() - "-->".length() : this.getAbsoluteEnd();
            }
            case COMMENT: {
                return this.text.endsWith("-->") ? this.getAbsoluteEnd() - "-->".length() : this.getAbsoluteEnd();
            }
        }
        return this.getAbsoluteEnd();
    }

    public int getContentsLine() {
        return this.getLine();
    }

    public int getContentsColumn() {
        switch (this.type) {
            case CDATA: {
                return this.getColumn() + "<![CDATA[".length();
            }
            case ASDOC: {
                return this.getColumn() + "<!---".length();
            }
            case COMMENT: {
                return this.getColumn() + "<!--".length();
            }
        }
        return this.getColumn();
    }

    @Override
    public ISourceFragment[] getFragments(Collection<ICompilerProblem> problems) {
        MXMLTextData location = this;
        switch (this.type) {
            case TEXT: {
                MXMLDialect mxmlDialect = this.getMXMLDialect();
                return EntityProcessor.parse(this.text, location, mxmlDialect, problems);
            }
            case WHITESPACE: {
                SourceFragment fragment = new SourceFragment(this.text, location);
                return new ISourceFragment[]{fragment};
            }
            case CDATA: {
                SourceFragment fragment = new SourceFragment(this.text, this.getContents(), this.getContentsStart(), this.getContentsLine(), this.getContentsColumn());
                return new ISourceFragment[]{fragment};
            }
        }
        assert (false) : "Unexpected type of MXMLTextData";
        return null;
    }
}

