/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.TreeMultimap;
import com.google.common.io.CharSource;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ErrorHandler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.WarningsGuard;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

@GwtIncompatible(value="java.io, java.util.regex")
public class WhitelistWarningsGuard
extends WarningsGuard {
    private static final Splitter LINE_SPLITTER = Splitter.on('\n');
    private final Set<String> whitelist;
    private static final Pattern LINE_NUMBER = Pattern.compile(":-?\\d+");

    public WhitelistWarningsGuard() {
        this(ImmutableSet.of());
    }

    public WhitelistWarningsGuard(Set<String> whitelist) {
        Preconditions.checkNotNull(whitelist);
        this.whitelist = this.normalizeWhitelist(whitelist);
    }

    protected Set<String> normalizeWhitelist(Set<String> whitelist) {
        HashSet<String> result = new HashSet<String>();
        for (String line : whitelist) {
            String trimmed = line.trim();
            if (trimmed.isEmpty() || trimmed.charAt(0) == '#') continue;
            result.add(LINE_NUMBER.matcher(trimmed).replaceFirst(":"));
        }
        return ImmutableSet.copyOf(result);
    }

    @Override
    public CheckLevel level(JSError error) {
        if (this.containWarning(this.formatWarning(error))) {
            return CheckLevel.WARNING;
        }
        return null;
    }

    protected boolean containWarning(String formattedWarning) {
        return this.whitelist.contains(formattedWarning);
    }

    @Override
    public int getPriority() {
        return WarningsGuard.Priority.SUPPRESS_BY_WHITELIST.getValue();
    }

    public static WhitelistWarningsGuard fromFile(File file) {
        return new WhitelistWarningsGuard(WhitelistWarningsGuard.loadWhitelistedJsWarnings(file));
    }

    public static Set<String> loadWhitelistedJsWarnings(File file) {
        return WhitelistWarningsGuard.loadWhitelistedJsWarnings(Files.asCharSource(file, StandardCharsets.UTF_8));
    }

    protected static Set<String> loadWhitelistedJsWarnings(CharSource supplier) {
        try {
            return WhitelistWarningsGuard.loadWhitelistedJsWarnings(supplier.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static Set<String> loadWhitelistedJsWarnings(Reader reader) throws IOException {
        Preconditions.checkNotNull(reader);
        HashSet<String> result = new HashSet<String>();
        result.addAll(CharStreams.readLines(reader));
        return result;
    }

    protected String formatWarning(JSError error) {
        return this.formatWarning(error, false);
    }

    protected String formatWarning(JSError error, boolean withMetaData) {
        StringBuilder sb = new StringBuilder();
        sb.append(error.sourceName).append(":");
        if (withMetaData) {
            sb.append(error.lineNumber);
        }
        List<String> lines = LINE_SPLITTER.splitToList(error.description);
        sb.append("  ").append(lines.get(0));
        if (withMetaData) {
            for (int i = 1; i < lines.size(); ++i) {
                sb.append("\n# ").append(lines.get(i));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String getFirstLine(String warning) {
        int lineLength = warning.indexOf(10);
        if (lineLength > 0) {
            warning = warning.substring(0, lineLength);
        }
        return warning;
    }

    public class WhitelistBuilder
    implements ErrorHandler {
        private final Set<JSError> warnings = new LinkedHashSet<JSError>();
        private String productName = null;
        private String generatorTarget = null;
        private String headerNote = null;

        public WhitelistBuilder setProductName(String name) {
            this.productName = name;
            return this;
        }

        public WhitelistBuilder setGeneratorTarget(String name) {
            this.generatorTarget = name;
            return this;
        }

        public WhitelistBuilder setNote(String note) {
            this.headerNote = note;
            return this;
        }

        @Override
        public void report(CheckLevel level, JSError error) {
            this.warnings.add(error);
        }

        public void writeWhitelist(File out) throws IOException {
            try (PrintStream stream = new PrintStream(out);){
                this.appendWhitelist(stream);
            }
        }

        public void appendWhitelist(PrintStream out) {
            out.append("# This is a list of legacy warnings that have yet to be fixed.\n");
            if (this.productName != null && !this.productName.isEmpty() && !this.warnings.isEmpty()) {
                out.append("# Please find some time and fix at least one of them and it will be the happiest day for " + this.productName + ".\n");
            }
            if (this.generatorTarget != null && !this.generatorTarget.isEmpty()) {
                out.append("# When you fix any of these warnings, run " + this.generatorTarget + " task.\n");
            }
            if (this.headerNote != null) {
                out.append("#" + Joiner.on("\n# ").join(Splitter.on('\n').split(this.headerNote)) + "\n");
            }
            TreeMultimap<DiagnosticType, String> warningsByType = TreeMultimap.create();
            for (JSError warning : this.warnings) {
                warningsByType.put(warning.getType(), WhitelistWarningsGuard.this.formatWarning(warning, true));
            }
            for (DiagnosticType type : warningsByType.keySet()) {
                if (DiagnosticGroups.DEPRECATED.matches(type)) continue;
                out.append("\n# Warning ").append(type.key).append(": ").println(Iterables.get(LINE_SPLITTER.split(type.format.toPattern()), 0));
                for (String warning : warningsByType.get(type)) {
                    out.println(warning);
                }
            }
            out.flush();
        }
    }
}

