// Copyright 2006 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview Abstract base class for positioning implementations.
 *
 * @author eae@google.com (Emil A Eklund)
 */

goog.provide('goog.positioning.AbstractPosition');

goog.forwardDeclare('goog.math.Box');
goog.forwardDeclare('goog.math.Size');
goog.forwardDeclare('goog.positioning.Corner');



/**
 * Abstract position object. Encapsulates position and overflow handling.
 *
 * @constructor
 */
goog.positioning.AbstractPosition = function() {};


/**
 * Repositions the element. Abstract method, should be overloaded.
 *
 * @param {Element} movableElement Element to position.
 * @param {goog.positioning.Corner} corner Corner of the movable element that
 *     should be positioned adjacent to the anchored element.
 * @param {goog.math.Box=} opt_margin A margin specified in pixels.
 * @param {goog.math.Size=} opt_preferredSize PreferredSize of the
 *     movableElement.
 */
goog.positioning.AbstractPosition.prototype.reposition = function(
    movableElement, corner, opt_margin, opt_preferredSize) {};
