/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.scalar;

import io.protostuff.OutputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.foundation.common.utils.bean.IntGetter;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;

public class SInt32WriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        if (Integer.TYPE.equals(propertyDescriptor.getJavaType().getRawClass())) {
            return new SInt32PrimitiveSchema(protoField, propertyDescriptor);
        }
        if (Integer.class.equals((Object)propertyDescriptor.getJavaType().getRawClass())) {
            return new SInt32Schema(protoField, propertyDescriptor);
        }
        return new SInt32DynamicSchema(protoField, propertyDescriptor);
    }

    private static class SInt32PrimitiveSchema<T>
    extends SInt32DynamicSchema<T> {
        private final IntGetter<T> primitiveGetter;

        public SInt32PrimitiveSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
            this.primitiveGetter = (IntGetter)propertyDescriptor.getGetter();
        }

        @Override
        public final void getAndWriteTo(OutputEx output, T message) throws IOException {
            int value = this.primitiveGetter.get(message);
            output.writeScalarSInt32(this.tag, this.tagSize, value);
        }
    }

    private static class SInt32Schema<T>
    extends SInt32DynamicSchema<T> {
        protected final Getter<T, Integer> getter;

        public SInt32Schema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
            this.getter = (Getter)propertyDescriptor.getGetter();
        }

        @Override
        public final void getAndWriteTo(OutputEx output, T message) throws IOException {
            Integer value = (Integer)this.getter.get(message);
            if (value != null) {
                output.writeScalarSInt32(this.tag, this.tagSize, value);
            }
        }
    }

    private static class SInt32DynamicSchema<T>
    extends FieldSchema<T> {
        public SInt32DynamicSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
        }

        @Override
        public final void writeTo(OutputEx output, Object value) throws IOException {
            if (value instanceof Number) {
                output.writeScalarSInt32(this.tag, this.tagSize, ((Number)value).intValue());
                return;
            }
            if (value instanceof String[]) {
                if (((String[])value).length == 0) {
                    return;
                }
                int parsedValue = Integer.parseInt(((String[])value)[0], 10);
                output.writeScalarSInt32(this.tag, this.tagSize, parsedValue);
                return;
            }
            if (value instanceof String) {
                int parsedValue = Integer.parseInt((String)value, 10);
                output.writeScalarSInt32(this.tag, this.tagSize, parsedValue);
                return;
            }
            ProtoUtils.throwNotSupportWrite(this.protoField, value);
        }
    }
}

