/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.element;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.WelcomeFileMapping;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.util.WebContainerUtils;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

public class WelcomeFileWebElement
implements WebElement {
    private final WelcomeFileMapping welcomeFileMapping;

    public WelcomeFileWebElement(WelcomeFileMapping welcomeFileMapping) {
        NullArgumentException.validateNotNull(welcomeFileMapping, "Welcome file mapping");
        this.welcomeFileMapping = welcomeFileMapping;
    }

    @Override
    public void register(HttpService httpService, HttpContext httpContext) throws Exception {
        if (!WebContainerUtils.isWebContainer(httpService)) {
            throw new UnsupportedOperationException("Internal error: In use HttpService is not an WebContainer (from Pax Web)");
        }
        ((WebContainer)httpService).registerWelcomeFiles(this.welcomeFileMapping.getWelcomeFiles(), this.welcomeFileMapping.isRedirect(), httpContext);
    }

    @Override
    public void unregister(HttpService httpService, HttpContext httpContext) {
        if (WebContainerUtils.isWebContainer(httpService)) {
            ((WebContainer)httpService).unregisterWelcomeFiles(this.welcomeFileMapping.getWelcomeFiles(), httpContext);
        }
    }

    @Override
    public String getHttpContextId() {
        return this.welcomeFileMapping.getHttpContextId();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "mapping=" + this.welcomeFileMapping + "}";
    }
}

