/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NoContentException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.provider.AbstractJAXBProvider;
import org.apache.cxf.jaxrs.utils.HttpUtils;

public abstract class AbstractConfigurableProvider {
    protected static final ResourceBundle BUNDLE = BundleUtils.getBundle(AbstractJAXBProvider.class);
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractJAXBProvider.class);
    private List<String> consumeMediaTypes;
    private List<String> produceMediaTypes;
    private boolean enableBuffering;
    private boolean enableStreaming;
    private Bus bus;

    public void setBus(Bus b) {
        if (this.bus != null) {
            this.bus = b;
        }
    }

    public Bus getBus() {
        return this.bus != null ? this.bus : BusFactory.getThreadDefaultBus();
    }

    public void setConsumeMediaTypes(List<String> types) {
        this.consumeMediaTypes = types;
    }

    public List<String> getConsumeMediaTypes() {
        return this.consumeMediaTypes;
    }

    public void setProduceMediaTypes(List<String> types) {
        this.produceMediaTypes = types;
    }

    public List<String> getProduceMediaTypes() {
        return this.produceMediaTypes;
    }

    public void setEnableBuffering(boolean enableBuf) {
        this.enableBuffering = enableBuf;
    }

    public boolean getEnableBuffering() {
        return this.enableBuffering;
    }

    public void setEnableStreaming(boolean enableStream) {
        this.enableStreaming = enableStream;
    }

    public boolean getEnableStreaming() {
        return this.enableStreaming;
    }

    public void init(List<ClassResourceInfo> resources) {
    }

    protected boolean isPayloadEmpty(HttpHeaders headers) {
        if (headers != null) {
            return this.isPayloadEmpty((MultivaluedMap<String, String>)headers.getRequestHeaders());
        }
        return false;
    }

    protected boolean isPayloadEmpty(MultivaluedMap<String, String> headers) {
        return HttpUtils.isPayloadEmpty(headers);
    }

    protected void reportEmptyContentLength() throws NoContentException {
        String message = new Message("EMPTY_BODY", BUNDLE, new Object[0]).toString();
        LOG.warning(message);
        throw new NoContentException(message);
    }
}

