/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.base;

import java.util.HashMap;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.storage.netcdf.base.Axis;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.base.Variable;
import org.opengis.referencing.cs.AxisDirection;

public enum AxisType {
    X,
    Y,
    Z,
    T;

    private static final Map<String, Character> TYPES;
    private static final Map<Character, AxisType> VALUES;

    private static void addAxisTypes(AxisType value, char abbreviation, String ... names) {
        Character c = Character.valueOf(abbreviation);
        for (String name : names) {
            TYPES.put(name, c);
        }
        VALUES.put(c, value);
    }

    private static Character abbreviation(String type) {
        return type != null ? TYPES.get(type.toLowerCase(Decoder.DATA_LOCALE)) : null;
    }

    private static boolean isNullOrAmbiguous(Character abbreviation) {
        return abbreviation == null || abbreviation.charValue() >= 'x' && abbreviation.charValue() <= 'z';
    }

    public static char abbreviation(Variable axis, boolean useUnit) {
        Character abbreviation = AxisType.abbreviation(axis.getAxisType());
        if (AxisType.isNullOrAmbiguous(abbreviation)) {
            Character fallback = abbreviation;
            abbreviation = AxisType.abbreviation(axis.getAttributeAsString("standard_name"));
            if (fallback == null) {
                fallback = abbreviation;
            }
            if (AxisType.isNullOrAmbiguous(abbreviation)) {
                abbreviation = AxisType.abbreviation(axis.getDescription());
                if (fallback == null) {
                    fallback = abbreviation;
                }
                if (AxisType.isNullOrAmbiguous(abbreviation)) {
                    if (useUnit && Units.isAngular(axis.getUnit())) {
                        AxisDirection direction = AxisDirections.absolute((AxisDirection)Axis.direction(axis.getUnitsString()));
                        if (direction == AxisDirection.EAST) {
                            return '\u03bb';
                        }
                        if (direction == AxisDirection.NORTH) {
                            return '\u03c6';
                        }
                    }
                    abbreviation = AxisType.abbreviation(axis.getName());
                    if (fallback == null) {
                        fallback = abbreviation;
                    }
                    if (AxisType.isNullOrAmbiguous(abbreviation)) {
                        if (useUnit) {
                            Unit<?> unit = axis.getUnit();
                            if (Units.isTemporal(unit)) {
                                return 't';
                            }
                            if (Units.isPressure(unit)) {
                                return 'z';
                            }
                        }
                        return fallback != null ? fallback.charValue() : (char)'\u0000';
                    }
                }
            }
        }
        return abbreviation.charValue();
    }

    static AxisType valueOf(Variable axis, boolean useUnit) {
        char abbreviation = AxisType.abbreviation(axis, useUnit);
        return abbreviation != '\u0000' ? VALUES.get(Character.valueOf(abbreviation)) : null;
    }

    static {
        TYPES = new HashMap<String, Character>(26);
        VALUES = new HashMap<Character, AxisType>(13);
        AxisType.addAxisTypes(X, '\u03bb', "longitude", "lon", "long");
        AxisType.addAxisTypes(Y, '\u03c6', "latitude", "lat");
        AxisType.addAxisTypes(Z, 'H', "pressure", "height", "altitude", "barometric_altitude", "elevation", "elev", "geoz");
        AxisType.addAxisTypes(Z, 'D', "depth", "depth_below_geoid");
        AxisType.addAxisTypes(X, 'E', "geox", "projection_x_coordinate");
        AxisType.addAxisTypes(Y, 'N', "geoy", "projection_y_coordinate");
        AxisType.addAxisTypes(T, 't', "t", "time", "runtime");
        AxisType.addAxisTypes(X, 'x', "x");
        AxisType.addAxisTypes(Y, 'y', "y");
        AxisType.addAxisTypes(Z, 'z', "z");
    }
}

