/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.sling.ide.eclipse.core.ISlingLaunchpadConfiguration;
import org.apache.sling.ide.eclipse.core.ISlingLaunchpadServer;
import org.apache.sling.ide.eclipse.core.SetBundleInstallLocallyCommand;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class InstallEditorSection
extends ServerEditorSection {
    protected boolean _updating;
    protected PropertyChangeListener _listener;
    private Button bundleLocalInstallButton;
    private Button quickLocalInstallButton;
    private ISlingLaunchpadServer launchpadServer;
    private PropertyChangeListener serverListener;
    private Composite actionArea;

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 458);
        section.setText("Install");
        section.setDescription("Specify how to install bundles on the server");
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(784);
        composite.setLayoutData((Object)gridData);
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        this.bundleLocalInstallButton = toolkit.createButton(composite, "Install bundles via bundle upload", 16);
        GridData data = new GridData(4, 4, true, false, 2, 1);
        this.bundleLocalInstallButton.setLayoutData((Object)data);
        this.quickLocalInstallButton = toolkit.createButton(composite, "Install bundles directly from the filesystem", 16);
        data = new GridData(4, 4, true, false, 2, 1);
        this.quickLocalInstallButton.setLayoutData((Object)data);
        this.actionArea = toolkit.createComposite(composite);
        RowLayout actionAreaLayout = new RowLayout();
        actionAreaLayout.center = true;
        this.actionArea.setLayout((Layout)actionAreaLayout);
        this.initialize();
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.serverListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("launchpad.installLocally".equals(evt.getPropertyName())) {
                    InstallEditorSection.this.quickLocalInstallButton.setSelection(((Boolean)evt.getNewValue()).booleanValue());
                    InstallEditorSection.this.bundleLocalInstallButton.setSelection((Boolean)evt.getNewValue() == false);
                }
            }
        };
        this.server.addPropertyChangeListener(this.serverListener);
        this.launchpadServer = (ISlingLaunchpadServer)this.server.getAdapter(ISlingLaunchpadServer.class);
        if (this.launchpadServer == null) {
            this.launchpadServer = (ISlingLaunchpadServer)this.server.loadAdapter(ISlingLaunchpadServer.class, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void initialize() {
        ISlingLaunchpadConfiguration config = this.launchpadServer.getConfiguration();
        this.quickLocalInstallButton.setSelection(config.bundleInstallLocally());
        this.bundleLocalInstallButton.setSelection(!config.bundleInstallLocally());
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallEditorSection.this.execute((IUndoableOperation)new SetBundleInstallLocallyCommand(InstallEditorSection.this.server, InstallEditorSection.this.quickLocalInstallButton.getSelection()));
            }
        };
        this.quickLocalInstallButton.addSelectionListener((SelectionListener)listener);
        this.bundleLocalInstallButton.addSelectionListener((SelectionListener)listener);
    }

    public void dispose() {
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.serverListener);
        }
        super.dispose();
    }
}

