/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.component.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.component.impl.DistributionConfiguration;
import org.apache.sling.distribution.component.impl.DistributionConfigurationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceConfigurationManager
implements DistributionConfigurationManager {
    private final String CONTENT_NODE = "jcr:content";
    private final String configRootPath;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String[] configProperties;
    private final Map<String, String> configDefaults;

    public ResourceConfigurationManager(String configRootPath, String[] configProperties, Map<String, String> configDefaults) {
        this.configRootPath = configRootPath;
        this.configProperties = configProperties;
        this.configDefaults = configDefaults;
    }

    @Override
    public List<DistributionConfiguration> getConfigs(ResourceResolver resolver, DistributionComponentKind kind) {
        ArrayList<DistributionConfiguration> configurations = new ArrayList<DistributionConfiguration>();
        Resource configRoot = resolver.getResource(this.configRootPath);
        if (configRoot == null) {
            return new ArrayList<DistributionConfiguration>();
        }
        for (Resource configResource : configRoot.getChildren()) {
            Map<String, Object> configMap = this.getFilteredMap(configResource);
            configurations.add(new DistributionConfiguration(kind, configResource.getName(), configMap));
        }
        return configurations;
    }

    @Override
    public DistributionConfiguration getConfig(ResourceResolver resolver, DistributionComponentKind kind, String name) {
        Resource configRoot = resolver.getResource(this.configRootPath);
        if (configRoot == null) {
            return null;
        }
        Resource configResource = configRoot.getChild(name);
        if (configResource == null) {
            return null;
        }
        Map<String, Object> configMap = this.getFilteredMap(configResource);
        return new DistributionConfiguration(kind, configResource.getName(), configMap);
    }

    @Override
    public void saveConfig(ResourceResolver resolver, DistributionConfiguration config) {
        Resource configRoot = resolver.getResource(this.configRootPath);
        if (configRoot == null) {
            return;
        }
        Resource configResource = configRoot.getChild(config.getName());
        Resource contentResource = configResource != null ? configResource.getChild("jcr:content") : null;
        try {
            if (configResource == null) {
                HashMap<String, String> configMap = new HashMap<String, String>();
                configMap.put("jcr:primaryType", "sling:Folder");
                configResource = resolver.create(configRoot, config.getName(), configMap);
            }
            if (contentResource == null) {
                HashMap<String, String> contentMap = new HashMap<String, String>();
                contentMap.put("jcr:primaryType", "nt:unstructured");
                contentResource = resolver.create(configResource, "jcr:content", contentMap);
            }
            Map<String, Object> properties = config.getProperties();
            properties = this.filterMap(properties);
            for (Map.Entry<String, String> propDefault : this.configDefaults.entrySet()) {
                if (properties.containsKey(propDefault.getKey())) continue;
                properties.put(propDefault.getKey(), propDefault.getValue());
            }
            ModifiableValueMap valueMap = (ModifiableValueMap)contentResource.adaptTo(ModifiableValueMap.class);
            valueMap.putAll(properties);
        }
        catch (PersistenceException e) {
            this.log.error("cannot save config {}", (Object)config.getName(), (Object)e);
        }
    }

    @Override
    public void deleteConfig(ResourceResolver resolver, DistributionComponentKind kind, String name) {
        Resource configRoot = resolver.getResource(this.configRootPath);
        Resource configResource = configRoot.getChild(name);
        if (configResource == null) {
            return;
        }
        try {
            resolver.delete(configResource);
            resolver.commit();
        }
        catch (PersistenceException e) {
            this.log.error("cannot delete config {}", (Object)name, (Object)e);
        }
    }

    private Map<String, Object> getMap(Resource resource) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Resource contentResource = resource.getChild("jcr:content");
        if (contentResource != null) {
            ValueMap configMap = (ValueMap)contentResource.adaptTo(ValueMap.class);
            result.putAll((Map<String, Object>)configMap);
        }
        return result;
    }

    private Map<String, Object> getFilteredMap(Resource resource) {
        Map<String, Object> result = this.getMap(resource);
        result = this.filterMap(result);
        return result;
    }

    private Map<String, Object> filterMap(Map<String, Object> configMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : configMap.keySet()) {
            if (!this.isAccepted(key)) continue;
            result.put(key, configMap.get(key));
        }
        return result;
    }

    private boolean isAccepted(String key) {
        for (String property : this.configProperties) {
            if (!property.equals(key)) continue;
            return true;
        }
        return false;
    }
}

