/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.unpack;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Directive;
import org.apache.felix.utils.manifest.Parser;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.builder.ArtifactProvider;

public class Unpack {
    public static final String UNPACK_EXTENSIONS_PROP = "org.apache.sling.feature.unpack.extensions";
    private final Map<String, Map<String, String>> registry;
    private final String defaultMapping;

    private Unpack(Map<String, Map<String, String>> registry) {
        this.registry = registry;
        this.defaultMapping = registry.entrySet().stream().filter(entry -> Boolean.parseBoolean((String)((Map)entry.getValue()).get("default"))).findFirst().map(entry -> (String)entry.getKey()).orElse(null);
    }

    public boolean handle(Extension extension, ArtifactProvider provider) {
        return this.handle(extension, provider, this::unpack);
    }

    public boolean handle(Extension extension, ArtifactProvider provider, BiConsumer<URL, Map<String, Object>> handler) {
        if (extension.getType() == ExtensionType.ARTIFACTS && this.registry.containsKey(extension.getName())) {
            String dir = this.registry.get(extension.getName()).get("dir");
            boolean override = Boolean.parseBoolean(this.registry.get(extension.getName()).get("override"));
            String key = this.registry.get(extension.getName()).get("key");
            String value = this.registry.get(extension.getName()).get("value");
            String index = this.registry.get(extension.getName()).get("index");
            for (Artifact artifact : extension.getArtifacts()) {
                HashMap<String, String> context = new HashMap<String, String>();
                context.put("artifact.id", artifact.getId().toMvnId());
                context.put("dir", dir);
                context.put("override", Boolean.toString(override));
                context.put("key", key);
                context.put("value", value);
                context.put("index", index);
                URL url = provider.provide(artifact.getId());
                handler.accept(url, context);
            }
            return true;
        }
        return false;
    }

    public boolean handles(InputStream stream, Map<String, Object> context) {
        String value;
        String key;
        String dir;
        String contextDir = (String)context.get("dir");
        if (contextDir == null && this.defaultMapping != null) {
            dir = this.registry.get(this.defaultMapping).get("dir");
            key = this.registry.get(this.defaultMapping).get("key");
            value = this.registry.get(this.defaultMapping).get("value");
        } else {
            dir = contextDir;
            key = (String)context.get("key");
            value = (String)context.get("value");
        }
        if (dir == null) {
            return false;
        }
        if (key != null && value != null) {
            return Unpack.handles(key, value, stream);
        }
        return contextDir != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean handles(String key, String value, InputStream inputStream) {
        try (JarInputStream jarInputStream = new JarInputStream(inputStream);){
            Manifest mf = jarInputStream.getManifest();
            if (mf != null) {
                boolean bl = value.equalsIgnoreCase(mf.getMainAttributes().getValue(key));
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private void unpack(URL url, Map<String, Object> context) {
        try {
            this.unpack(url.openStream(), context);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void unpack(InputStream stream, Map<String, Object> context) {
        try {
            String index;
            boolean override;
            String dir = (String)context.get("dir");
            if (dir == null && this.defaultMapping != null) {
                dir = this.registry.get(this.defaultMapping).get("dir");
                override = Boolean.parseBoolean(this.registry.get(this.defaultMapping).get("override"));
                index = this.registry.get(this.defaultMapping).get("index");
            } else {
                override = Boolean.parseBoolean((String)context.get("override"));
                index = (String)context.get("index");
            }
            if (dir == null) {
                throw new IllegalStateException("No target dir and no default configured");
            }
            this.unpack(dir, stream, override, index);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static Unpack fromMapping(String mapping) {
        Clause[] extClauses;
        HashMap<String, Map<String, String>> registry = new HashMap<String, Map<String, String>>();
        for (Clause c : extClauses = Parser.parseHeader(mapping)) {
            HashMap<String, String> cfg = new HashMap<String, String>();
            for (Directive d : c.getDirectives()) {
                cfg.put(d.getName(), d.getValue());
            }
            registry.put(c.getName(), Collections.unmodifiableMap(cfg));
        }
        return new Unpack(registry);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unpack(String dir, InputStream stream, boolean override, String index) throws IOException {
        File base = new File(dir);
        if (!base.isDirectory() && !base.mkdirs()) {
            throw new IOException("Unable to find or created base dir: " + base);
        }
        try (JarInputStream jarInputStream = new JarInputStream(stream);){
            Manifest mf;
            String indexValue = null;
            if (index != null && (mf = jarInputStream.getManifest()) != null) {
                indexValue = mf.getMainAttributes().getValue(index);
            }
            List<String> roots = this.parseRoots(indexValue);
            ZipEntry entry = jarInputStream.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory() && !entry.getName().toLowerCase().startsWith("meta-inf/") && this.isRoot(roots, entry.getName())) {
                    File target = new File(base, this.relativize(roots, entry.getName()));
                    if (!target.getParentFile().toPath().startsWith(base.toPath())) throw new IOException("Zip slip detected for: " + entry.getName());
                    if (!target.getParentFile().isDirectory() && !target.getParentFile().mkdirs()) throw new IOException("Can't create parent dir:" + target.getParentFile());
                    if (override) {
                        Files.copy(jarInputStream, target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    } else if (!target.exists()) {
                        try {
                            Files.copy(jarInputStream, target.toPath(), new CopyOption[0]);
                        }
                        catch (FileAlreadyExistsException fileAlreadyExistsException) {}
                    }
                }
                entry = jarInputStream.getNextEntry();
            }
            return;
        }
    }

    private boolean isRoot(List<String> roots, String path) {
        return roots.stream().anyMatch(root -> ("/" + path).startsWith((String)root));
    }

    private List<String> parseRoots(String index) {
        ArrayList<String> roots = new ArrayList<String>();
        if (index != null) {
            roots.addAll(Stream.of(Parser.parseDelimitedString(index, ",")).map(root -> root.endsWith("/") ? root : root + "/").map(root -> root.startsWith("/") ? root : "/" + root).collect(Collectors.toList()));
        } else {
            roots.add("/");
        }
        return roots;
    }

    private String relativize(List<String> roots, String path) {
        for (String root : roots) {
            if (!("/" + path).startsWith(root)) continue;
            return path.substring(root.length() - 1);
        }
        throw new IllegalStateException("Can't find a root for: " + path);
    }
}

