/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.util.LineInputStream;

public class FileInputSource
extends VaultInputSource {
    private final File file;
    private byte[] lineSeparator;

    public FileInputSource(File file) {
        super(file.getPath());
        this.file = file;
    }

    public void setLineSeparator(byte[] lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    @Override
    public InputStream getByteStream() {
        try {
            if (this.lineSeparator != null) {
                return new LineInputStream(new FileInputStream(this.file), this.lineSeparator);
            }
            return FileUtils.openInputStream(this.file);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public long getContentLength() {
        return this.file.length();
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    public void discard() {
        this.file.delete();
        this.file.deleteOnExit();
    }
}

