/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.Operand;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.commons.iterator.RowIteratorAdapter;
import org.apache.jackrabbit.core.query.lucene.LuceneQueryFactory;
import org.apache.jackrabbit.core.query.lucene.join.ConstraintSplitInfo;
import org.apache.jackrabbit.core.query.lucene.join.ConstraintSplitter;
import org.apache.jackrabbit.core.query.lucene.join.Constraints;
import org.apache.jackrabbit.core.query.lucene.join.JoinMerger;
import org.apache.jackrabbit.core.query.lucene.join.OperandEvaluator;
import org.apache.jackrabbit.core.query.lucene.join.RowPathComparator;
import org.apache.jackrabbit.core.query.lucene.join.SimpleQueryResult;
import org.apache.jackrabbit.core.query.lucene.join.ValueComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryEngine {
    private static final Logger log = LoggerFactory.getLogger(QueryEngine.class);
    private static final int printIndentStep = 4;
    private final LuceneQueryFactory lqf;
    private final NodeTypeManager ntManager;
    private final QueryObjectModelFactory qomFactory;
    private final ValueFactory valueFactory;
    private final OperandEvaluator evaluator;

    public QueryEngine(Session session, LuceneQueryFactory lqf, Map<String, Value> variables) throws RepositoryException {
        this.lqf = lqf;
        Workspace workspace = session.getWorkspace();
        this.ntManager = workspace.getNodeTypeManager();
        this.qomFactory = workspace.getQueryManager().getQOMFactory();
        this.valueFactory = session.getValueFactory();
        this.evaluator = new OperandEvaluator(this.valueFactory, variables);
    }

    public QueryResult execute(Column[] columns, Source source, Constraint constraint, Ordering[] orderings, long offset, long limit) throws RepositoryException {
        long time = System.currentTimeMillis();
        QueryResult qr = this.execute(columns, source, constraint, orderings, offset, limit, 2);
        log.debug("SQL2 QUERY execute took {} ms.", (Object)(System.currentTimeMillis() - time));
        return qr;
    }

    protected QueryResult execute(Column[] columns, Source source, Constraint constraint, Ordering[] orderings, long offset, long limit, int printIndentation) throws RepositoryException {
        if (source instanceof Selector) {
            return this.execute(columns, (Selector)source, constraint, orderings, offset, limit, printIndentation);
        }
        if (source instanceof Join) {
            return this.execute(columns, (Join)source, constraint, orderings, offset, limit, printIndentation);
        }
        throw new UnsupportedRepositoryOperationException("Unknown source type: " + source);
    }

    protected QueryResult execute(Column[] columns, Join join, Constraint constraint, Ordering[] orderings, long offset, long limit, int printIndentation) throws RepositoryException {
        if ("jcr.join.type.right.outer".equalsIgnoreCase(join.getJoinType())) {
            log.debug("{} SQL2 RIGHT OUTER JOIN transformed to LEFT OUTER JOIN.", (Object)QueryEngine.genString(printIndentation));
            Join betterJoin = this.qomFactory.join(join.getRight(), join.getLeft(), "jcr.join.type.left.outer", join.getJoinCondition());
            return this.execute(columns, betterJoin, constraint, orderings, offset, limit, printIndentation);
        }
        JoinMerger merger = JoinMerger.getJoinMerger(join, this.getColumnMap(columns, this.getSelectorNames((Source)join)), this.evaluator, this.qomFactory);
        ConstraintSplitter splitter = new ConstraintSplitter(constraint, this.qomFactory, merger.getLeftSelectors(), merger.getRightSelectors(), join);
        ConstraintSplitInfo csInfo = splitter.getConstraintSplitInfo();
        QueryEngine.logQueryAnalysis(csInfo, printIndentation);
        boolean isOuterJoin = "jcr.join.type.left.outer".equalsIgnoreCase(join.getJoinType());
        QueryResult result = this.execute(merger, csInfo, isOuterJoin, printIndentation);
        long sort = System.currentTimeMillis();
        QueryResult sortedResult = QueryEngine.sort(result, orderings, this.evaluator, offset, limit);
        log.debug(" {} SQL2 SORT took {} ms.", (Object)QueryEngine.genString(printIndentation), (Object)(System.currentTimeMillis() - sort));
        return sortedResult;
    }

    protected QueryResult execute(JoinMerger merger, ConstraintSplitInfo csInfo, boolean isOuterJoin, int printIndentation) throws RepositoryException {
        RowPathComparator leftCo = new RowPathComparator(merger.getLeftSelectors());
        long timeJoinLeftSide = System.currentTimeMillis();
        if (csInfo.isMultiple()) {
            log.debug("{} SQL2 JOIN execute: there are multiple inner splits.", (Object)QueryEngine.genString(printIndentation));
            long bTime = System.currentTimeMillis();
            QueryResult branch1 = this.execute(merger, csInfo.getLeftInnerConstraints(), isOuterJoin, printIndentation + 4);
            TreeSet<Row> allRows = new TreeSet<Row>(new RowPathComparator(Arrays.asList(merger.getSelectorNames())));
            RowIterator ri1 = branch1.getRows();
            while (ri1.hasNext()) {
                Row r = ri1.nextRow();
                allRows.add(r);
            }
            log.debug("{} SQL2 JOIN executed first branch, took {} ms.", (Object)QueryEngine.genString(printIndentation), (Object)(System.currentTimeMillis() - bTime));
            bTime = System.currentTimeMillis();
            QueryResult branch2 = this.execute(merger, csInfo.getRightInnerConstraints(), isOuterJoin, printIndentation + 4);
            RowIterator ri2 = branch2.getRows();
            while (ri2.hasNext()) {
                Row r = ri2.nextRow();
                allRows.add(r);
            }
            log.debug("{} SQL2 JOIN executed second branch, took {} ms.", (Object)QueryEngine.genString(printIndentation), (Object)(System.currentTimeMillis() - bTime));
            return new SimpleQueryResult(merger.getColumnNames(), merger.getSelectorNames(), new RowIteratorAdapter(allRows));
        }
        Set<Row> leftRows = this.buildLeftRowsJoin(csInfo, leftCo, printIndentation + 4);
        if (log.isDebugEnabled()) {
            timeJoinLeftSide = System.currentTimeMillis() - timeJoinLeftSide;
            log.debug(QueryEngine.genString(printIndentation) + "SQL2 JOIN LEFT SIDE took " + timeJoinLeftSide + " ms. fetched " + leftRows.size() + " rows.");
        }
        long timeJoinRightSide = System.currentTimeMillis();
        List<Constraint> rightConstraints = merger.getRightJoinConstraints(leftRows);
        RowPathComparator rightCo = new RowPathComparator(merger.getRightSelectors());
        Set<Row> rightRows = this.buildRightRowsJoin(csInfo, rightConstraints, isOuterJoin, rightCo, printIndentation + 4);
        Set<Row> excludingOuterJoinRowsSet = null;
        if (isOuterJoin && csInfo.getRightConstraint() != null) {
            excludingOuterJoinRowsSet = this.buildRightRowsJoin(csInfo, rightConstraints, false, rightCo, printIndentation + 4);
        }
        if (log.isDebugEnabled()) {
            timeJoinRightSide = System.currentTimeMillis() - timeJoinRightSide;
            log.debug(QueryEngine.genString(printIndentation) + "SQL2 JOIN RIGHT SIDE took " + timeJoinRightSide + " ms. fetched " + rightRows.size() + " rows.");
        }
        return merger.merge(new RowIteratorAdapter(leftRows), new RowIteratorAdapter(rightRows), excludingOuterJoinRowsSet, rightCo);
    }

    private Set<Row> buildLeftRowsJoin(ConstraintSplitInfo csi, Comparator<Row> comparator, int printIndentation) throws RepositoryException {
        if (csi.isMultiple()) {
            if (log.isDebugEnabled()) {
                log.debug(QueryEngine.genString(printIndentation) + "SQL2 JOIN LEFT SIDE there are multiple inner splits.");
            }
            TreeSet<Row> leftRows = new TreeSet<Row>(comparator);
            leftRows.addAll(this.buildLeftRowsJoin(csi.getLeftInnerConstraints(), comparator, printIndentation + 4));
            leftRows.addAll(this.buildLeftRowsJoin(csi.getRightInnerConstraints(), comparator, printIndentation + 4));
            return leftRows;
        }
        TreeSet<Row> leftRows = new TreeSet<Row>(comparator);
        QueryResult leftResult = this.execute(null, csi.getSource().getLeft(), csi.getLeftConstraint(), null, 0L, -1L, printIndentation);
        for (Row row : JcrUtils.getRows(leftResult)) {
            leftRows.add(row);
        }
        return leftRows;
    }

    private Set<Row> buildRightRowsJoin(ConstraintSplitInfo csi, List<Constraint> rightConstraints, boolean ignoreWhereConstraints, Comparator<Row> comparator, int printIndentation) throws RepositoryException {
        if (csi.isMultiple()) {
            if (log.isDebugEnabled()) {
                log.debug(QueryEngine.genString(printIndentation) + "SQL2 JOIN RIGHT SIDE there are multiple inner splits.");
            }
            TreeSet<Row> rightRows = new TreeSet<Row>(comparator);
            rightRows.addAll(this.buildRightRowsJoin(csi.getLeftInnerConstraints(), rightConstraints, ignoreWhereConstraints, comparator, printIndentation + 4));
            rightRows.addAll(this.buildRightRowsJoin(csi.getRightInnerConstraints(), rightConstraints, ignoreWhereConstraints, comparator, printIndentation + 4));
            return rightRows;
        }
        if (rightConstraints.size() < 500) {
            TreeSet<Row> rightRows = new TreeSet<Row>(comparator);
            List<Constraint> localRightContraints = rightConstraints;
            Constraint rightConstraint = Constraints.and(this.qomFactory, Constraints.or(this.qomFactory, localRightContraints), csi.getRightConstraint());
            if (ignoreWhereConstraints) {
                rightConstraint = Constraints.or(this.qomFactory, localRightContraints);
            }
            QueryResult rightResult = this.execute(null, csi.getSource().getRight(), rightConstraint, null, 0L, -1L, printIndentation);
            for (Row row : JcrUtils.getRows(rightResult)) {
                rightRows.add(row);
            }
            return rightRows;
        }
        TreeSet<Row> rightRows = new TreeSet<Row>(comparator);
        for (int i = 0; i < rightConstraints.size(); i += 500) {
            if (log.isDebugEnabled()) {
                log.debug(QueryEngine.genString(printIndentation) + "SQL2 JOIN RIGHT SIDE executing batch # " + i + ".");
            }
            List<Constraint> localRightContraints = rightConstraints.subList(i, Math.min(i + 500, rightConstraints.size()));
            Constraint rightConstraint = Constraints.and(this.qomFactory, Constraints.or(this.qomFactory, localRightContraints), csi.getRightConstraint());
            if (ignoreWhereConstraints) {
                rightConstraint = Constraints.or(this.qomFactory, localRightContraints);
            }
            QueryResult rightResult = this.execute(null, csi.getSource().getRight(), rightConstraint, null, 0L, -1L, printIndentation);
            for (Row row : JcrUtils.getRows(rightResult)) {
                rightRows.add(row);
            }
        }
        return rightRows;
    }

    private static String genString(int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private static void logQueryAnalysis(ConstraintSplitInfo csi, int printIndentation) throws RepositoryException {
        if (!log.isDebugEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(QueryEngine.genString(printIndentation));
        sb.append("SQL2 JOIN analysis:");
        sb.append(IOUtils.LINE_SEPARATOR);
        sb.append(QueryEngine.constraintSplitInfoToString(csi, 2));
        log.debug(sb.toString());
    }

    private static String constraintSplitInfoToString(ConstraintSplitInfo csi, int printIndentation) throws RepositoryException {
        if (csi.isMultiple()) {
            StringBuilder sb = new StringBuilder();
            sb.append(QueryEngine.genString(printIndentation));
            sb.append("SQL2 JOIN inner split -> ");
            sb.append(IOUtils.LINE_SEPARATOR);
            sb.append(QueryEngine.genString(printIndentation));
            sb.append("+");
            sb.append(IOUtils.LINE_SEPARATOR);
            sb.append(QueryEngine.constraintSplitInfoToString(csi.getLeftInnerConstraints(), printIndentation + 4));
            sb.append(IOUtils.LINE_SEPARATOR);
            sb.append(QueryEngine.genString(printIndentation));
            sb.append("+");
            sb.append(IOUtils.LINE_SEPARATOR);
            sb.append(QueryEngine.constraintSplitInfoToString(csi.getRightInnerConstraints(), printIndentation + 4));
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(QueryEngine.genString(printIndentation));
        sb.append("SQL2 JOIN source: ");
        sb.append(csi.getSource());
        sb.append(IOUtils.LINE_SEPARATOR);
        sb.append(QueryEngine.genString(printIndentation));
        sb.append("SQL2 JOIN left constraint:  ");
        sb.append(csi.getLeftConstraint());
        sb.append(IOUtils.LINE_SEPARATOR);
        sb.append(QueryEngine.genString(printIndentation));
        sb.append("SQL2 JOIN right constraint: ");
        sb.append(csi.getRightConstraint());
        return sb.toString();
    }

    protected QueryResult execute(Column[] columns, Selector selector, Constraint constraint, Ordering[] orderings, long offset, long limit, int printIndentation) throws RepositoryException {
        long time = System.currentTimeMillis();
        Map<String, NodeType> selectorMap = this.getSelectorNames((Source)selector);
        String[] selectorNames = selectorMap.keySet().toArray(new String[selectorMap.size()]);
        Map<String, PropertyValue> columnMap = this.getColumnMap(columns, selectorMap);
        Object[] columnNames = columnMap.keySet().toArray(new String[columnMap.size()]);
        try {
            RowIteratorAdapter rows = new RowIteratorAdapter(this.lqf.execute(columnMap, selector, constraint));
            SimpleQueryResult result = new SimpleQueryResult((String[])columnNames, selectorNames, rows);
            QueryResult queryResult = QueryEngine.sort(result, orderings, this.evaluator, offset, limit);
            return queryResult;
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to access the query index", (Throwable)e);
        }
        finally {
            if (log.isDebugEnabled()) {
                time = System.currentTimeMillis() - time;
                log.debug(QueryEngine.genString(printIndentation) + "SQL2 SELECT took " + time + " ms. selector: " + selector + ", columns: " + Arrays.toString(columnNames) + ", constraint: " + constraint);
            }
        }
    }

    private Map<String, PropertyValue> getColumnMap(Column[] columns, Map<String, NodeType> selectors) throws RepositoryException {
        LinkedHashMap<String, PropertyValue> map = new LinkedHashMap<String, PropertyValue>();
        if (columns != null && columns.length > 0) {
            for (int i = 0; i < columns.length; ++i) {
                String name = columns[i].getColumnName();
                if (name != null) {
                    map.put(name, this.qomFactory.propertyValue(columns[i].getSelectorName(), columns[i].getPropertyName()));
                    continue;
                }
                String selector = columns[i].getSelectorName();
                map.putAll(this.getColumnMap(selector, selectors.get(selector)));
            }
        } else {
            for (Map.Entry<String, NodeType> selector : selectors.entrySet()) {
                map.putAll(this.getColumnMap(selector.getKey(), selector.getValue()));
            }
        }
        return map;
    }

    private Map<String, PropertyValue> getColumnMap(String selector, NodeType type) throws RepositoryException {
        LinkedHashMap<String, PropertyValue> map = new LinkedHashMap<String, PropertyValue>();
        for (PropertyDefinition definition : type.getPropertyDefinitions()) {
            String name = definition.getName();
            if (definition.isMultiple() || "*".equals(name)) continue;
            map.put(selector + "." + name, this.qomFactory.propertyValue(selector, name));
        }
        return map;
    }

    private Map<String, NodeType> getSelectorNames(Source source) throws RepositoryException {
        if (source instanceof Selector) {
            Selector selector = (Selector)source;
            return Collections.singletonMap(selector.getSelectorName(), this.getNodeType(selector));
        }
        if (source instanceof Join) {
            Join join = (Join)source;
            LinkedHashMap<String, NodeType> map = new LinkedHashMap<String, NodeType>();
            map.putAll(this.getSelectorNames(join.getLeft()));
            map.putAll(this.getSelectorNames(join.getRight()));
            return map;
        }
        throw new UnsupportedRepositoryOperationException("Unknown source type: " + source);
    }

    private NodeType getNodeType(Selector selector) throws RepositoryException {
        try {
            return this.ntManager.getNodeType(selector.getNodeTypeName());
        }
        catch (NoSuchNodeTypeException e) {
            throw new InvalidQueryException("Selected node type does not exist: " + selector, (Throwable)e);
        }
    }

    protected static QueryResult sort(QueryResult result, Ordering[] orderings, OperandEvaluator evaluator, long offset, long limit) throws RepositoryException {
        if (orderings != null && orderings.length > 0 || offset != 0L || limit >= 0L) {
            int size;
            List<Object> rows = new ArrayList<Row>();
            RowIterator iterator = result.getRows();
            while (iterator.hasNext()) {
                rows.add(iterator.nextRow());
            }
            if (orderings != null && orderings.length > 0) {
                Collections.sort(rows, new RowComparator(orderings, evaluator));
            }
            if (offset > 0L) {
                size = rows.size();
                rows = rows.subList((int)Math.min(offset, (long)size), size);
            }
            if (limit >= 0L) {
                size = rows.size();
                rows = rows.subList(0, (int)Math.min(limit, (long)size));
            }
            return new SimpleQueryResult(result.getColumnNames(), result.getSelectorNames(), new RowIteratorAdapter(rows));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RowComparator
    implements Comparator<Row> {
        private final ValueComparator comparator = new ValueComparator();
        private final Ordering[] orderings;
        private final OperandEvaluator evaluator;

        private RowComparator(Ordering[] orderings, OperandEvaluator evaluator) {
            this.orderings = orderings;
            this.evaluator = evaluator;
        }

        @Override
        public int compare(Row a, Row b) {
            try {
                for (Ordering ordering : this.orderings) {
                    Value[] vb;
                    DynamicOperand operand = ordering.getOperand();
                    Value[] va = this.evaluator.getValues((Operand)operand, a);
                    int d = this.compare(va, vb = this.evaluator.getValues((Operand)operand, b));
                    if (d == 0) continue;
                    if ("jcr.order.descending".equals(ordering.getOrder())) {
                        return -d;
                    }
                    return d;
                }
                return 0;
            }
            catch (RepositoryException e) {
                throw new RuntimeException("Unable to compare rows " + a + " and " + b, e);
            }
        }

        @Override
        private int compare(Value[] a, Value[] b) {
            for (int i = 0; i < a.length && i < b.length; ++i) {
                int d = this.comparator.compare(a[i], b[i]);
                if (d == 0) continue;
                return d;
            }
            return a.length - b.length;
        }
    }
}

