/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.zip.CRC32;

public final class Buffer {
    private final ByteBuffer buffer;

    private Buffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public static Buffer map(FileChannel channel, FileChannel.MapMode mode, long position, long size) throws IOException {
        return new Buffer(channel.map(mode, position, size));
    }

    public static Buffer wrap(byte[] buffer) {
        return new Buffer(ByteBuffer.wrap(buffer));
    }

    public static Buffer wrap(byte[] buffer, int pos, int len) {
        return new Buffer(ByteBuffer.wrap(buffer, pos, len));
    }

    public static Buffer allocate(int cap) {
        return new Buffer(ByteBuffer.allocate(cap));
    }

    public static Buffer allocateDirect(int cap) {
        return new Buffer(ByteBuffer.allocateDirect(cap));
    }

    public int remaining() {
        return this.buffer.remaining();
    }

    public Buffer asReadOnlyBuffer() {
        return new Buffer(this.buffer.asReadOnlyBuffer());
    }

    public Buffer position(int pos) {
        ((java.nio.Buffer)this.buffer).position(pos);
        return this;
    }

    public int position() {
        return this.buffer.position();
    }

    public Buffer limit(int lim) {
        ((java.nio.Buffer)this.buffer).limit(lim);
        return this;
    }

    public int limit() {
        return this.buffer.limit();
    }

    public Buffer slice() {
        return new Buffer(this.buffer.slice());
    }

    public int readFully(FileChannel channel, int position) throws IOException {
        int count;
        int result = 0;
        while (this.buffer.remaining() > 0 && (count = channel.read(this.buffer, position)) >= 0) {
            result += count;
            position += count;
        }
        return result;
    }

    public Buffer flip() {
        ((java.nio.Buffer)this.buffer).flip();
        return this;
    }

    public int getInt() {
        return this.buffer.getInt();
    }

    public int getInt(int pos) {
        return this.buffer.getInt(pos);
    }

    public Buffer mark() {
        ((java.nio.Buffer)this.buffer).mark();
        return this;
    }

    public Buffer get(byte[] b) {
        this.buffer.get(b);
        return this;
    }

    public Buffer get(byte[] b, int pos, int len) {
        this.buffer.get(b, pos, len);
        return this;
    }

    public byte get(int pos) {
        return this.buffer.get(pos);
    }

    public byte get() {
        return this.buffer.get();
    }

    public Buffer reset() {
        ((java.nio.Buffer)this.buffer).reset();
        return this;
    }

    public void update(CRC32 checksum) {
        checksum.update(this.buffer);
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public Buffer put(byte[] b) {
        this.buffer.put(b);
        return this;
    }

    public Buffer put(byte[] buf, int pos, int len) {
        this.buffer.put(buf, pos, len);
        return this;
    }

    public Buffer put(byte b) {
        this.buffer.put(b);
        return this;
    }

    public Buffer put(Buffer b) {
        this.buffer.put(b.buffer);
        return this;
    }

    public Buffer rewind() {
        ((java.nio.Buffer)this.buffer).rewind();
        return this;
    }

    public long getLong(int pos) {
        return this.buffer.getLong(pos);
    }

    public long getLong() {
        return this.buffer.getLong();
    }

    public short getShort(int pos) {
        return this.buffer.getShort(pos);
    }

    public Buffer duplicate() {
        return new Buffer(this.buffer.duplicate());
    }

    public CharBuffer decode(Charset charset) {
        return charset.decode(this.buffer);
    }

    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    public int write(WritableByteChannel channel) throws IOException {
        return channel.write(this.buffer);
    }

    public Buffer putInt(int i) {
        this.buffer.putInt(i);
        return this;
    }

    public Buffer putLong(long l) {
        this.buffer.putLong(l);
        return this;
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Buffer) {
            return this.buffer.equals(((Buffer)obj).buffer);
        }
        return false;
    }
}

