/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.value.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.api.JackrabbitValueFactory;
import org.apache.jackrabbit.api.ReferenceBinary;
import org.apache.jackrabbit.api.binary.BinaryUpload;
import org.apache.jackrabbit.api.binary.BinaryUploadOptions;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.blob.BlobAccessProvider;
import org.apache.jackrabbit.oak.api.blob.BlobUpload;
import org.apache.jackrabbit.oak.api.blob.BlobUploadOptions;
import org.apache.jackrabbit.oak.commons.PerfLogger;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.BinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.value.ErrorValue;
import org.apache.jackrabbit.oak.plugins.value.jcr.BinaryImpl;
import org.apache.jackrabbit.oak.plugins.value.jcr.PartialValueFactory;
import org.apache.jackrabbit.oak.plugins.value.jcr.ValueImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;
import sling-mock-oak.com.google.common.base.Preconditions;

public class ValueFactoryImpl
extends PartialValueFactory
implements JackrabbitValueFactory {
    private static final PerfLogger binOpsLogger = new PerfLogger(LoggerFactory.getLogger((String)"org.apache.jackrabbit.oak.jcr.operations.binary.perf"));
    @NotNull
    private final Root root;

    public ValueFactoryImpl(@NotNull Root root, @NotNull NamePathMapper namePathMapper, @NotNull BlobAccessProvider blobAccessProvider) {
        super(namePathMapper, blobAccessProvider);
        this.root = Preconditions.checkNotNull(root);
    }

    public ValueFactoryImpl(@NotNull Root root, @NotNull NamePathMapper namePathMapper) {
        this(root, namePathMapper, DEFAULT_BLOB_ACCESS_PROVIDER);
    }

    @NotNull
    public Value createValue(@NotNull InputStream value) {
        try {
            return this.createBinaryValue(value);
        }
        catch (IOException e) {
            return new ErrorValue(e, 2);
        }
        catch (RepositoryException e) {
            return new ErrorValue((Exception)((Object)e), 2);
        }
    }

    @NotNull
    public Value createValue(@NotNull Binary value) {
        try {
            String reference;
            Blob blob;
            if (value instanceof BinaryImpl) {
                return ((BinaryImpl)value).getBinaryValue();
            }
            if (value instanceof ReferenceBinary && (blob = this.root.getBlob(reference = ((ReferenceBinary)value).getReference())) != null) {
                return this.createBinaryValue(blob);
            }
            InputStream stream = value.getStream();
            if (stream == null) {
                throw new ValueFormatException("null");
            }
            return this.createBinaryValue(stream);
        }
        catch (RepositoryException e) {
            return new ErrorValue((Exception)((Object)e), 2);
        }
        catch (IOException e) {
            return new ErrorValue(e, 2);
        }
    }

    @NotNull
    public Binary createBinary(@NotNull InputStream stream) throws RepositoryException {
        try {
            return new BinaryImpl(this.createBinaryValue(stream));
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    @Nullable
    public BinaryUpload initiateBinaryUpload(long maxSize, int maxParts) {
        return this.initiateBinaryUpload(maxSize, maxParts, BinaryUploadOptions.DEFAULT);
    }

    @Override
    @Nullable
    public BinaryUpload initiateBinaryUpload(long maxSize, int maxParts, @NotNull BinaryUploadOptions options) {
        final BlobUpload upload = this.getBlobAccessProvider().initiateBlobUpload(maxSize, maxParts, new BlobUploadOptions(options.isDomainOverrideIgnored()));
        if (null == upload) {
            return null;
        }
        return new BinaryUpload(){

            @Override
            @NotNull
            public Iterable<URI> getUploadURIs() {
                return upload.getUploadURIs();
            }

            @Override
            public long getMinPartSize() {
                return upload.getMinPartSize();
            }

            @Override
            public long getMaxPartSize() {
                return upload.getMaxPartSize();
            }

            @Override
            @NotNull
            public String getUploadToken() {
                return upload.getUploadToken();
            }
        };
    }

    @Override
    @Nullable
    public Binary completeBinaryUpload(@NotNull String uploadToken) throws RepositoryException {
        return this.createBinary(this.getBlobAccessProvider().completeBlobUpload(uploadToken));
    }

    @NotNull
    private ValueImpl createBinaryValue(@NotNull InputStream value) throws IOException, RepositoryException {
        long start = binOpsLogger.start();
        Blob blob = this.root.createBlob(value);
        binOpsLogger.end(start, -1L, "Created binary property of size [{}]", (Object)blob.length());
        return this.createBinaryValue(blob);
    }

    @NotNull
    private ValueImpl createBinaryValue(@NotNull Blob blob) throws RepositoryException {
        return new ValueImpl(BinaryPropertyState.binaryProperty("", blob), this.getNamePathMapper(), this.getBlobAccessProvider());
    }

    @Nullable
    public Binary createBinary(Blob blob) throws RepositoryException {
        return null != blob ? this.createBinaryValue(blob).getBinary() : null;
    }

    @Nullable
    public Blob getBlob(Binary binary) throws RepositoryException {
        if (binary instanceof BinaryImpl) {
            return ((BinaryImpl)binary).getBinaryValue().getBlob();
        }
        return null;
    }
}

