/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos.apis;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.maven.ProjectHelper;
import org.apache.sling.feature.maven.mojos.selection.IncludeExcludeMatcher;

public class ApisConfiguration {
    private static final String EXTENSION_NAME = "apis-jar-config";
    private static final String PROP_LICENSE_REPORT = "license-report";
    private static final String PROP_MANIFEST_ENTRIES = "manifest-entries";
    private static final String PROP_CLASSIFIER_MAPPINGS = "classifier-mappings";
    private static final String PROP_REGION_MAPPINGS = "region-mappings";
    private static final String PROP_BUNDLE_RESOURCES = "bundle-resources";
    private static final String PROP_BUNDLE_RESOURCE_FOLDERS = "bundle-resource-folders";
    private static final String PROP_API_VERSION = "api-version";
    private static final String PROP_API_NAME = "api-name";
    private static final String PROP_JAVADOC_SOURCE_LEVEL = "javadoc-source-level";
    private static final String PROP_JAVADOC_CLASSPATH_TOPS = "javadoc-classpath-tops";
    private static final String PROP_JAVADOC_CLASSPATH_HIGHEST_VERSIONS = "javadoc-classpath-highest-versions";
    private static final String PROP_JAVADOC_CLASSPATH_REMOVALS = "javadoc-classpath-removals";
    private static final String PROP_JAVADOC_LINKS = "javadoc-links";
    private static final String PROP_LICENSE_DEFAULTS = "license-defaults";
    private static final String PROP_LICENSE_FOOTER = "license-footer";
    private static final String PROP_LICENSE_HEADER = "license-header";
    private static final String PROP_ADDITIONAL_JAVADOC_EXTENSIONS = "javadoc-extensions";
    private String licenseReport;
    private final List<String> licenseDefaults = new ArrayList<String>();
    private String licenseReportHeader;
    private String licenseReportFooter;
    private final List<String> javadocLinks = new ArrayList<String>();
    private final List<String> javadocClasspathRemovals = new ArrayList<String>();
    private final List<String> javadocClasspathHighestVersions = new ArrayList<String>();
    private final List<String> javadocClasspathTops = new ArrayList<String>();
    private String javadocSourceLevel;
    private String apiVersion;
    private String apiName;
    private final List<String> bundleResourceFolders = new ArrayList<String>();
    private final List<String> bundleResources = new ArrayList<String>();
    private final Map<String, String> regionMappings = new HashMap<String, String>();
    private final Map<String, String> classifierMappings = new HashMap<String, String>();
    private final Map<String, String> manifestEntries = new HashMap<String, String>();
    private final Set<String> enabledToggles = new HashSet<String>();
    private boolean useApiDependencies;
    private final Set<String> dependencyRepositories = new HashSet<String>();
    private boolean useApiDependenciesForJavadoc;
    private boolean generateJavadocForAllApi;
    private final Map<String, Set<String>> additionJavadocExtensionNames = new HashMap<String, Set<String>>();
    private IncludeExcludeMatcher licenseDefaultMatcher;

    public ApisConfiguration(Feature feature) throws MojoExecutionException {
        Extension ext = feature.getExtensions().getByName(EXTENSION_NAME);
        if (ext != null) {
            if (ext.getType() != ExtensionType.JSON) {
                throw new MojoExecutionException("Invalid extension type for " + ext.getName() + " : " + ext.getType());
            }
            JsonObject json = ext.getJSONStructure().asJsonObject();
            this.licenseReport = json.getString(PROP_LICENSE_REPORT, null);
            this.licenseReportHeader = this.getStringOrArray(json, PROP_LICENSE_HEADER);
            this.licenseReportFooter = this.getStringOrArray(json, PROP_LICENSE_FOOTER);
            this.add(this.licenseDefaults, json, PROP_LICENSE_DEFAULTS);
            this.add(this.javadocLinks, json, PROP_JAVADOC_LINKS);
            this.add(this.javadocClasspathRemovals, json, PROP_JAVADOC_CLASSPATH_REMOVALS);
            this.add(this.javadocClasspathHighestVersions, json, PROP_JAVADOC_CLASSPATH_HIGHEST_VERSIONS);
            this.add(this.javadocClasspathTops, json, PROP_JAVADOC_CLASSPATH_TOPS);
            this.javadocSourceLevel = json.getString(PROP_JAVADOC_SOURCE_LEVEL, null);
            this.apiVersion = json.getString(PROP_API_VERSION, null);
            this.apiName = json.getString(PROP_API_NAME, null);
            this.add(this.bundleResourceFolders, json, PROP_BUNDLE_RESOURCE_FOLDERS);
            this.add(this.bundleResources, json, PROP_BUNDLE_RESOURCES);
            this.add(this.regionMappings, json, PROP_REGION_MAPPINGS);
            this.add(this.classifierMappings, json, PROP_CLASSIFIER_MAPPINGS);
            this.add(this.manifestEntries, json, PROP_MANIFEST_ENTRIES);
            ArrayList<String> additionalExtensions = new ArrayList<String>();
            this.add(additionalExtensions, json, PROP_ADDITIONAL_JAVADOC_EXTENSIONS);
            this.setAdditionalJavadocExtensions(additionalExtensions);
        }
    }

    public void logConfiguration(Log log) {
        if (log.isInfoEnabled()) {
            log.info((CharSequence)"Using configuration:");
            log.info((CharSequence)("- useApiDependencies : " + this.useApiDependencies));
            if (this.useApiDependencies) {
                log.info((CharSequence)("- dependencyRepositories : " + (this.dependencyRepositories.isEmpty() ? "NONE" : this.dependencyRepositories.toString())));
                log.info((CharSequence)("- useApiDependenciesForJavadoc : " + this.useApiDependenciesForJavadoc));
                log.info((CharSequence)("- generateJavadocForAllApi : " + this.generateJavadocForAllApi));
            }
            log.info((CharSequence)("- enabledToggles : " + this.getEnabledToggles()));
            log.info((CharSequence)("- javadoc-source-level : " + this.javadocSourceLevel));
            log.info((CharSequence)("- javadoc-links : " + this.javadocLinks));
            log.info((CharSequence)("- api-version : " + this.apiVersion));
            log.info((CharSequence)("- api-name : " + this.apiName));
            log.info((CharSequence)("- bundle-resource-folders : " + this.bundleResourceFolders));
            log.info((CharSequence)("- bundle-resources : " + this.bundleResources));
            log.info((CharSequence)("- region-mappings : " + this.regionMappings));
            log.info((CharSequence)("- classifier-mappings : " + this.classifierMappings));
            log.info((CharSequence)("- javadoc-classpath-removals : " + this.javadocClasspathRemovals));
            log.info((CharSequence)("- javadoc-classpath-highest-versions : " + this.javadocClasspathHighestVersions));
            log.info((CharSequence)("- javadoc-classpath-tops : " + this.javadocClasspathTops));
            log.info((CharSequence)("- manifest-entries : " + this.manifestEntries));
            log.info((CharSequence)("- license-report : " + this.licenseReport));
            log.info((CharSequence)("- license-defaults : " + this.licenseDefaults));
            log.info((CharSequence)("- license-header : " + this.licenseReportHeader));
            log.info((CharSequence)("- license-footer : " + this.licenseReportFooter));
            log.info((CharSequence)("- javadoc-extensions : " + this.additionJavadocExtensionNames));
        }
    }

    private String getStringOrArray(JsonObject json, String propName) {
        JsonValue val;
        String result = null;
        JsonValue jsonValue = val = json.containsKey((Object)propName) ? (JsonValue)json.get((Object)propName) : null;
        if (val != null) {
            if (val.getValueType() == JsonValue.ValueType.ARRAY) {
                StringBuilder sb = new StringBuilder();
                for (JsonValue v : val.asJsonArray()) {
                    sb.append(v);
                    sb.append('\n');
                }
                result = sb.toString();
            } else {
                result = ((JsonString)val).getString();
            }
        }
        return result;
    }

    private void add(List<String> list, JsonObject json, String propName) {
        JsonArray array;
        JsonArray jsonArray = array = json.containsKey((Object)propName) ? json.getJsonArray(propName) : null;
        if (array != null) {
            for (JsonValue val : array) {
                list.add(((JsonString)val).getString());
            }
        }
    }

    private void add(Map<String, String> map, JsonObject json, String propName) {
        JsonObject obj;
        JsonObject jsonObject = obj = json.containsKey((Object)propName) ? json.getJsonObject(propName) : null;
        if (obj != null) {
            for (Map.Entry entry : obj.entrySet()) {
                map.put((String)entry.getKey(), ((JsonString)entry.getValue()).getString());
            }
        }
    }

    public List<String> getBundleResources() {
        return this.bundleResources;
    }

    public List<String> getJavadocLinks() {
        return this.javadocLinks;
    }

    public String getJavadocSourceLevel() {
        return this.javadocSourceLevel;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getApiName() {
        return this.apiName;
    }

    public List<String> getBundleResourceFolders() {
        return this.bundleResourceFolders;
    }

    public String getLicenseReport() {
        return this.licenseReport;
    }

    public List<String> getLicenseDefaults() {
        return this.licenseDefaults;
    }

    public String getLicenseReportHeader() {
        return this.licenseReportHeader;
    }

    public String getLicenseReportFooter() {
        return this.licenseReportFooter;
    }

    public Map<String, String> getManifestEntries() {
        return this.manifestEntries;
    }

    public List<String> getJavadocClasspathRemovals() {
        return this.javadocClasspathRemovals;
    }

    public List<String> getJavadocClasspathHighestVersions() {
        return this.javadocClasspathHighestVersions;
    }

    public List<String> getJavadocClasspathTops() {
        return this.javadocClasspathTops;
    }

    public String mapApiRegionName(String regionName) {
        if (this.regionMappings.containsKey(regionName)) {
            return this.regionMappings.get(regionName);
        }
        return regionName;
    }

    public String mapApiClassifier(String classifier) {
        if (this.classifierMappings.containsKey(classifier)) {
            return this.classifierMappings.get(classifier);
        }
        return classifier;
    }

    public String getLicenseDefault(ArtifactId id) {
        return this.licenseDefaultMatcher.matches(id);
    }

    public void setLicenseDefaults(List<String> licenseDefaultsFromProjcect) throws MojoExecutionException {
        if (this.licenseDefaults.isEmpty() && licenseDefaultsFromProjcect != null) {
            this.licenseDefaults.addAll(licenseDefaultsFromProjcect);
        }
        this.licenseDefaultMatcher = new IncludeExcludeMatcher(this.licenseDefaults, null, "=", true);
    }

    public void setLicenseReport(String licenseReportFromProjcect) {
        if (this.licenseReport == null) {
            this.licenseReport = licenseReportFromProjcect;
        }
    }

    public void setLicenseReportHeader(String licenseReportHeaderFromProjcect) {
        if (this.licenseReportHeader == null) {
            this.licenseReportHeader = licenseReportHeaderFromProjcect;
        }
    }

    public void setLicenseReportFooter(String licenseReportFooterFromProjcect) {
        if (this.licenseReportFooter == null) {
            this.licenseReportFooter = licenseReportFooterFromProjcect;
        }
    }

    public void setJavadocLinks(String[] javadocLinksFromProject) {
        if (this.javadocLinks.isEmpty() && javadocLinksFromProject != null) {
            for (String v : javadocLinksFromProject) {
                this.javadocLinks.add(v);
            }
        }
    }

    public void setJavadocClasspathRemovals(List<String> javadocClasspathRemovalsFromProject) {
        if (this.javadocClasspathRemovals.isEmpty() && javadocClasspathRemovalsFromProject != null) {
            this.javadocClasspathRemovals.addAll(javadocClasspathRemovalsFromProject);
        }
    }

    public void setJavadocClasspathHighestVersions(List<String> javadocClasspathHighestVersionsFromProject) {
        if (this.javadocClasspathHighestVersions.isEmpty() && javadocClasspathHighestVersionsFromProject != null) {
            this.javadocClasspathHighestVersions.addAll(javadocClasspathHighestVersionsFromProject);
        }
    }

    public void setJavadocClasspathTops(List<String> javadocClasspathTopsFromProject) {
        if (this.javadocClasspathTops.isEmpty() && javadocClasspathTopsFromProject != null) {
            this.javadocClasspathTops.addAll(javadocClasspathTopsFromProject);
        }
    }

    public void setJavadocSourceLevel(String javadocSourceLevelFromProject) {
        if (this.javadocSourceLevel == null) {
            this.javadocSourceLevel = javadocSourceLevelFromProject;
        }
    }

    public void setApiVersion(String apiVersionFromProject) {
        if (this.apiVersion == null) {
            this.apiVersion = apiVersionFromProject;
        }
    }

    public void setBundleResources(String[] includeResourcesFromProject) {
        if (this.bundleResources.isEmpty() && includeResourcesFromProject != null) {
            for (String v : includeResourcesFromProject) {
                this.bundleResources.add(v);
            }
        }
    }

    public void setBundleResourceFolders(String resourceFoldersFromProject) {
        if (this.bundleResourceFolders.isEmpty() && resourceFoldersFromProject != null) {
            for (String v : resourceFoldersFromProject.split(",")) {
                this.bundleResourceFolders.add(v.trim());
            }
        }
    }

    public void setRegionMappings(Map<String, String> valuesFromProject) {
        if (this.regionMappings.isEmpty() && valuesFromProject != null) {
            this.regionMappings.putAll(valuesFromProject);
        }
    }

    public void setClassifierMappings(Map<String, String> valuesFromProject) {
        if (this.classifierMappings.isEmpty() && valuesFromProject != null) {
            this.classifierMappings.putAll(valuesFromProject);
        }
    }

    public void setManifestEntries(Properties valuesFromProject) {
        if (this.manifestEntries.isEmpty() && valuesFromProject != null) {
            this.manifestEntries.putAll(ProjectHelper.propertiesToMap(valuesFromProject));
        }
    }

    public void setEnabledToggles(String value) {
        if (value != null) {
            for (String name : value.split(",")) {
                this.enabledToggles.add(name.trim());
            }
        }
    }

    public Set<String> getEnabledToggles() {
        return this.enabledToggles;
    }

    public void setAdditionalJavadocExtensions(List<String> javadocAdditionalExtensions) {
        if (javadocAdditionalExtensions != null) {
            for (String val : javadocAdditionalExtensions) {
                int sepPos = val.indexOf(":");
                String regionName = sepPos == -1 ? "*" : val.substring(0, sepPos);
                for (String name : val.substring(sepPos + 1).split(",")) {
                    if (name.trim().isEmpty()) continue;
                    this.additionJavadocExtensionNames.computeIfAbsent(regionName, key -> new LinkedHashSet()).add(name.trim());
                }
            }
        }
    }

    public Set<String> getAdditionalJavadocExtensions(String regionName) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(this.additionJavadocExtensionNames.getOrDefault("*", Collections.emptySet()));
        result.addAll(this.additionJavadocExtensionNames.getOrDefault(regionName, Collections.emptySet()));
        return result;
    }

    public boolean isUseApiDependencies() {
        return this.useApiDependencies;
    }

    public void setUseApiDependencies(boolean flag) {
        this.useApiDependencies = flag;
    }

    public boolean isUseApiDependenciesForJavadoc() {
        return this.useApiDependenciesForJavadoc;
    }

    public void setUseApiDependenciesForJavadoc(boolean flag) {
        this.useApiDependenciesForJavadoc = flag;
    }

    public boolean isGenerateJavadocForAllApi() {
        return this.generateJavadocForAllApi;
    }

    public void setGenerateJavadocForAllApi(boolean generateJavadocForAllApi) {
        this.generateJavadocForAllApi = generateJavadocForAllApi;
    }

    public Set<String> getDependencyRepositories() {
        return this.dependencyRepositories;
    }

    public void setDependencyRepositories(String list) {
        this.dependencyRepositories.clear();
        if (list != null) {
            for (String val : list.split(",")) {
                if (!(val = val.trim()).endsWith("/")) {
                    val = val.concat("/");
                }
                this.dependencyRepositories.add(val);
            }
        }
    }

    public void setApiName(String value) {
        if (this.apiName == null) {
            this.apiName = value;
        }
    }
}

