/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.TableName;

public class ExecSPSNode
extends StatementNode {
    private TableName name;
    private SPSDescriptor spsd;
    private ExecPreparedStatement ps;

    public void init(Object object) {
        this.name = (TableName)object;
    }

    public void bindStatement() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        String string = this.name.getSchemaName();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(this.name.getSchemaName());
        if (string == null) {
            this.name.setSchemaName(schemaDescriptor.getSchemaName());
        }
        if (schemaDescriptor.getUUID() != null) {
            this.spsd = dataDictionary.getSPSDescriptor(this.name.getTableName(), schemaDescriptor);
        }
        if (this.spsd == null) {
            throw StandardException.newException("42X94", (Object)"STATEMENT", (Object)this.name);
        }
        if (this.spsd.getType() == 'T') {
            throw StandardException.newException("42Y41", this.name);
        }
        this.getCompilerContext().createDependency(this.spsd);
    }

    public boolean isAtomic() {
        return this.ps.isAtomic();
    }

    public GeneratedClass generate(ByteArray byteArray) throws StandardException {
        if (!this.spsd.isValid()) {
            this.getLanguageConnectionContext().commitNestedTransaction();
            this.getLanguageConnectionContext().beginNestedTransaction(true);
        }
        this.ps = this.spsd.getPreparedStatement();
        this.getCompilerContext().setSavedObjects(this.ps.getSavedObjects());
        this.getCompilerContext().setCursorInfo(this.ps.getCursorInfo());
        GeneratedClass generatedClass = this.ps.getActivationClass();
        return generatedClass;
    }

    public ResultDescription makeResultDescription() {
        return this.ps.getResultDescription();
    }

    public Object getCursorInfo() {
        return this.ps.getCursorInfo();
    }

    public DataTypeDescriptor[] getParameterTypes() throws StandardException {
        return this.spsd.getParams();
    }

    public ConstantAction makeConstantAction() {
        return this.ps.getConstantAction();
    }

    public boolean needsSavepoint() {
        return this.ps.needsSavepoint();
    }

    public String executeStatementName() {
        return this.name.getTableName();
    }

    public String executeSchemaName() {
        return this.name.getSchemaName();
    }

    public String getSPSName() {
        return this.spsd.getQualifiedName();
    }

    int activationKind() {
        return 2;
    }

    public String statementToString() {
        return "EXECUTE STATEMENT";
    }
}

