/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.ssl;

import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.DefaultWriteFuture;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestWrapper;
import org.apache.mina.core.write.WriteToClosedSessionException;
import org.apache.mina.filter.ssl.SslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslFilter
extends IoFilterAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslFilter.class);
    public static final AttributeKey SSL_SESSION = new AttributeKey(SslFilter.class, "session");
    public static final AttributeKey DISABLE_ENCRYPTION_ONCE = new AttributeKey(SslFilter.class, "disableOnce");
    public static final AttributeKey USE_NOTIFICATION = new AttributeKey(SslFilter.class, "useNotification");
    public static final AttributeKey PEER_ADDRESS = new AttributeKey(SslFilter.class, "peerAddress");
    public static final SslFilterMessage SESSION_SECURED = new SslFilterMessage("SESSION_SECURED");
    public static final SslFilterMessage SESSION_UNSECURED = new SslFilterMessage("SESSION_UNSECURED");
    private static final AttributeKey NEXT_FILTER = new AttributeKey(SslFilter.class, "nextFilter");
    private static final AttributeKey SSL_HANDLER = new AttributeKey(SslFilter.class, "handler");
    final SSLContext sslContext;
    private final boolean autoStart;
    private static final boolean START_HANDSHAKE = true;
    private boolean client;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private String[] enabledCipherSuites;
    private String[] enabledProtocols;

    public SslFilter(SSLContext sslContext) {
        this(sslContext, true);
    }

    public SslFilter(SSLContext sslContext, boolean autoStart) {
        if (sslContext == null) {
            throw new IllegalArgumentException("sslContext");
        }
        this.sslContext = sslContext;
        this.autoStart = autoStart;
    }

    public SSLSession getSslSession(IoSession session) {
        return (SSLSession)session.getAttribute(SSL_SESSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startSsl(IoSession session) throws SSLException {
        boolean started;
        SslHandler sslHandler = this.getSslSessionHandler(session);
        try {
            SslHandler sslHandler2 = sslHandler;
            synchronized (sslHandler2) {
                if (sslHandler.isOutboundDone()) {
                    IoFilter.NextFilter nextFilter = (IoFilter.NextFilter)session.getAttribute(NEXT_FILTER);
                    sslHandler.destroy();
                    sslHandler.init();
                    sslHandler.handshake(nextFilter);
                    started = true;
                } else {
                    started = false;
                }
            }
            sslHandler.flushScheduledEvents();
        }
        catch (SSLException se) {
            sslHandler.release();
            throw se;
        }
        return started;
    }

    String getSessionInfo(IoSession session) {
        StringBuilder sb = new StringBuilder();
        if (session.getService() instanceof IoAcceptor) {
            sb.append("Session Server");
        } else {
            sb.append("Session Client");
        }
        sb.append('[').append(session.getId()).append(']');
        SslHandler sslHandler = (SslHandler)session.getAttribute(SSL_HANDLER);
        if (sslHandler == null) {
            sb.append("(no sslEngine)");
        } else if (this.isSslStarted(session)) {
            if (sslHandler.isHandshakeComplete()) {
                sb.append("(SSL)");
            } else {
                sb.append("(ssl...)");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSslStarted(IoSession session) {
        SslHandler sslHandler = (SslHandler)session.getAttribute(SSL_HANDLER);
        if (sslHandler == null) {
            return false;
        }
        SslHandler sslHandler2 = sslHandler;
        synchronized (sslHandler2) {
            return !sslHandler.isOutboundDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteFuture stopSsl(IoSession session) throws SSLException {
        WriteFuture future;
        SslHandler sslHandler = this.getSslSessionHandler(session);
        IoFilter.NextFilter nextFilter = (IoFilter.NextFilter)session.getAttribute(NEXT_FILTER);
        try {
            SslHandler sslHandler2 = sslHandler;
            synchronized (sslHandler2) {
                future = this.initiateClosure(nextFilter, session);
            }
            sslHandler.flushScheduledEvents();
        }
        catch (SSLException se) {
            sslHandler.release();
            throw se;
        }
        return future;
    }

    public boolean isUseClientMode() {
        return this.client;
    }

    public void setUseClientMode(boolean clientMode) {
        this.client = clientMode;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] cipherSuites) {
        this.enabledCipherSuites = cipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] protocols) {
        this.enabledProtocols = protocols;
    }

    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws SSLException {
        if (parent.contains(SslFilter.class)) {
            String msg = "Only one SSL filter is permitted in a chain.";
            LOGGER.error(msg);
            throw new IllegalStateException(msg);
        }
        LOGGER.debug("Adding the SSL Filter {} to the chain", (Object)name);
        IoSession session = parent.getSession();
        session.setAttribute(NEXT_FILTER, nextFilter);
        SslHandler sslHandler = new SslHandler(this, session);
        sslHandler.init();
        String[] ciphers = this.sslContext.getServerSocketFactory().getSupportedCipherSuites();
        this.setEnabledCipherSuites(ciphers);
        session.setAttribute(SSL_HANDLER, sslHandler);
    }

    public void onPostAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws SSLException {
        if (this.autoStart) {
            this.initiateHandshake(nextFilter, parent.getSession());
        }
    }

    public void onPreRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws SSLException {
        IoSession session = parent.getSession();
        this.stopSsl(session);
        session.removeAttribute(NEXT_FILTER);
        session.removeAttribute(SSL_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws SSLException {
        SslHandler sslHandler = this.getSslSessionHandler(session);
        try {
            SslHandler sslHandler2 = sslHandler;
            synchronized (sslHandler2) {
                sslHandler.destroy();
            }
            sslHandler.flushScheduledEvents();
        }
        finally {
            nextFilter.sessionClosed(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws SSLException {
        SslHandler sslHandler;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}: Message received : {}", (Object)this.getSessionInfo(session), message);
        }
        SslHandler sslHandler2 = sslHandler = this.getSslSessionHandler(session);
        synchronized (sslHandler2) {
            if (!this.isSslStarted(session) && sslHandler.isInboundDone()) {
                sslHandler.scheduleMessageReceived(nextFilter, message);
            } else {
                IoBuffer buf = (IoBuffer)message;
                try {
                    sslHandler.messageReceived(nextFilter, buf.buf());
                    this.handleSslData(nextFilter, sslHandler);
                    if (sslHandler.isInboundDone()) {
                        if (sslHandler.isOutboundDone()) {
                            sslHandler.destroy();
                        } else {
                            this.initiateClosure(nextFilter, session);
                        }
                        if (buf.hasRemaining()) {
                            sslHandler.scheduleMessageReceived(nextFilter, buf);
                        }
                    }
                }
                catch (SSLException ssle2) {
                    SSLHandshakeException ssle2;
                    if (!sslHandler.isHandshakeComplete()) {
                        SSLHandshakeException newSsle = new SSLHandshakeException("SSL handshake failed.");
                        newSsle.initCause(ssle2);
                        ssle2 = newSsle;
                    } else {
                        sslHandler.release();
                    }
                    throw ssle2;
                }
            }
        }
        sslHandler.flushScheduledEvents();
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) {
        if (writeRequest instanceof EncryptedWriteRequest) {
            EncryptedWriteRequest wrappedRequest = (EncryptedWriteRequest)writeRequest;
            nextFilter.messageSent(session, wrappedRequest.getParentRequest());
        }
    }

    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) throws Exception {
        if (cause instanceof WriteToClosedSessionException) {
            WriteToClosedSessionException e = (WriteToClosedSessionException)cause;
            List<WriteRequest> failedRequests = e.getRequests();
            boolean containsCloseNotify = false;
            for (WriteRequest r : failedRequests) {
                if (!this.isCloseNotify(r.getMessage())) continue;
                containsCloseNotify = true;
                break;
            }
            if (containsCloseNotify) {
                if (failedRequests.size() == 1) {
                    return;
                }
                ArrayList<WriteRequest> newFailedRequests = new ArrayList<WriteRequest>(failedRequests.size() - 1);
                for (WriteRequest r : failedRequests) {
                    if (this.isCloseNotify(r.getMessage())) continue;
                    newFailedRequests.add(r);
                }
                if (newFailedRequests.isEmpty()) {
                    return;
                }
                cause = new WriteToClosedSessionException(newFailedRequests, cause.getMessage(), cause.getCause());
            }
        }
        nextFilter.exceptionCaught(session, cause);
    }

    private boolean isCloseNotify(Object message) {
        if (!(message instanceof IoBuffer)) {
            return false;
        }
        IoBuffer buf = (IoBuffer)message;
        int offset = buf.position();
        return buf.get(offset + 0) == 21 && buf.get(offset + 1) == 3 && (buf.get(offset + 2) == 0 || buf.get(offset + 2) == 1 || buf.get(offset + 2) == 2 || buf.get(offset + 2) == 3) && buf.get(offset + 3) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws SSLException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}: Writing Message : {}", (Object)this.getSessionInfo(session), (Object)writeRequest);
        }
        boolean needsFlush = true;
        SslHandler sslHandler = this.getSslSessionHandler(session);
        try {
            SslHandler sslHandler2 = sslHandler;
            synchronized (sslHandler2) {
                if (!this.isSslStarted(session)) {
                    sslHandler.scheduleFilterWrite(nextFilter, writeRequest);
                } else if (session.containsAttribute(DISABLE_ENCRYPTION_ONCE)) {
                    session.removeAttribute(DISABLE_ENCRYPTION_ONCE);
                    sslHandler.scheduleFilterWrite(nextFilter, writeRequest);
                } else {
                    IoBuffer buf = (IoBuffer)writeRequest.getMessage();
                    if (sslHandler.isWritingEncryptedData()) {
                        sslHandler.scheduleFilterWrite(nextFilter, writeRequest);
                    } else if (sslHandler.isHandshakeComplete()) {
                        int pos = buf.position();
                        sslHandler.encrypt(buf.buf());
                        buf.position(pos);
                        IoBuffer encryptedBuffer = sslHandler.fetchOutNetBuffer();
                        sslHandler.scheduleFilterWrite(nextFilter, new EncryptedWriteRequest(writeRequest, encryptedBuffer));
                    } else {
                        if (session.isConnected()) {
                            sslHandler.schedulePreHandshakeWriteRequest(nextFilter, writeRequest);
                        }
                        needsFlush = false;
                    }
                }
            }
            if (needsFlush) {
                sslHandler.flushScheduledEvents();
            }
        }
        catch (SSLException se) {
            sslHandler.release();
            throw se;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterClose(final IoFilter.NextFilter nextFilter, final IoSession session) throws SSLException {
        SslHandler sslHandler = (SslHandler)session.getAttribute(SSL_HANDLER);
        if (sslHandler == null) {
            nextFilter.filterClose(session);
            return;
        }
        WriteFuture future = null;
        try {
            SslHandler sslHandler2 = sslHandler;
            synchronized (sslHandler2) {
                if (this.isSslStarted(session)) {
                    future = this.initiateClosure(nextFilter, session);
                    future.addListener(new IoFutureListener<IoFuture>(){

                        @Override
                        public void operationComplete(IoFuture future) {
                            nextFilter.filterClose(session);
                        }
                    });
                }
            }
            sslHandler.flushScheduledEvents();
        }
        catch (SSLException se) {
            sslHandler.release();
            throw se;
        }
        finally {
            if (future == null) {
                nextFilter.filterClose(session);
            }
        }
    }

    public void initiateHandshake(IoSession session) throws SSLException {
        IoFilterChain filterChain = session.getFilterChain();
        if (filterChain == null) {
            throw new SSLException("No filter chain");
        }
        IoFilter.NextFilter nextFilter = filterChain.getNextFilter(SslFilter.class);
        if (nextFilter == null) {
            throw new SSLException("No SSL next filter in the chain");
        }
        this.initiateHandshake(nextFilter, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateHandshake(IoFilter.NextFilter nextFilter, IoSession session) throws SSLException {
        LOGGER.debug("{} : Starting the first handshake", (Object)this.getSessionInfo(session));
        SslHandler sslHandler = this.getSslSessionHandler(session);
        try {
            SslHandler sslHandler2 = sslHandler;
            synchronized (sslHandler2) {
                sslHandler.handshake(nextFilter);
            }
            sslHandler.flushScheduledEvents();
        }
        catch (SSLException se) {
            sslHandler.release();
            throw se;
        }
    }

    private WriteFuture initiateClosure(IoFilter.NextFilter nextFilter, IoSession session) throws SSLException {
        SslHandler sslHandler = this.getSslSessionHandler(session);
        WriteFuture future = null;
        try {
            if (!sslHandler.closeOutbound()) {
                return DefaultWriteFuture.newNotWrittenFuture(session, new IllegalStateException("SSL session is shut down already."));
            }
            future = sslHandler.writeNetBuffer(nextFilter);
            if (future == null) {
                future = DefaultWriteFuture.newWrittenFuture(session);
            }
            if (sslHandler.isInboundDone()) {
                sslHandler.destroy();
            }
            if (session.containsAttribute(USE_NOTIFICATION)) {
                sslHandler.scheduleMessageReceived(nextFilter, SESSION_UNSECURED);
            }
        }
        catch (SSLException se) {
            sslHandler.release();
            throw se;
        }
        return future;
    }

    private void handleSslData(IoFilter.NextFilter nextFilter, SslHandler sslHandler) throws SSLException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}: Processing the SSL Data ", (Object)this.getSessionInfo(sslHandler.getSession()));
        }
        if (sslHandler.isHandshakeComplete()) {
            sslHandler.flushPreHandshakeEvents();
        }
        sslHandler.writeNetBuffer(nextFilter);
        this.handleAppDataRead(nextFilter, sslHandler);
    }

    private void handleAppDataRead(IoFilter.NextFilter nextFilter, SslHandler sslHandler) {
        IoBuffer readBuffer = sslHandler.fetchAppBuffer();
        if (readBuffer.hasRemaining()) {
            sslHandler.scheduleMessageReceived(nextFilter, readBuffer);
        }
    }

    private SslHandler getSslSessionHandler(IoSession session) {
        SslHandler sslHandler = (SslHandler)session.getAttribute(SSL_HANDLER);
        if (sslHandler == null) {
            throw new IllegalStateException();
        }
        if (sslHandler.getSslFilter() != this) {
            throw new IllegalArgumentException("Not managed by this filter.");
        }
        return sslHandler;
    }

    private static class EncryptedWriteRequest
    extends WriteRequestWrapper {
        private final IoBuffer encryptedMessage;

        private EncryptedWriteRequest(WriteRequest writeRequest, IoBuffer encryptedMessage) {
            super(writeRequest);
            this.encryptedMessage = encryptedMessage;
        }

        public Object getMessage() {
            return this.encryptedMessage;
        }
    }

    public static class SslFilterMessage {
        private final String name;

        private SslFilterMessage(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

