/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.databinding.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.bind.util.JAXBSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.datasource.SourceDataSource;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.databinding.SourceBlock;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.impl.BlockImpl;
import org.apache.axis2.jaxws.message.util.Reader2Writer;
import org.apache.axis2.jaxws.utility.ConvertUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SourceBlockImpl
extends BlockImpl
implements SourceBlock {
    private static final Log log;
    private static Class staxSource;

    SourceBlockImpl(Source busObject, QName qName, BlockFactory factory) throws WebServiceException {
        super(busObject, null, qName, factory);
        if (busObject instanceof DOMSource || busObject instanceof SAXSource || busObject instanceof StreamSource || busObject.getClass().equals(staxSource) || busObject instanceof JAXBSource) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("data object is a " + busObject.getClass().getName()));
            }
        } else {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SourceNotSupported", (String)busObject.getClass().getName()));
        }
    }

    public SourceBlockImpl(OMElement omElement, QName qName, BlockFactory factory) {
        super(omElement, (Object)null, qName, factory);
    }

    protected Object _getBOFromReader(XMLStreamReader reader, Object busContext) throws XMLStreamException {
        Reader2Writer r2w = new Reader2Writer(reader);
        String text = r2w.getAsString();
        StringReader sr = new StringReader(text);
        return new StreamSource(sr);
    }

    protected Object _getBOFromOM(OMElement omElement, Object busContext) throws XMLStreamException, WebServiceException {
        Object busObject;
        OMDataSource ds;
        if (omElement instanceof OMSourcedElement && (ds = ((OMSourcedElement)omElement).getDataSource()) instanceof SourceDataSource) {
            return ((SourceDataSource)ds).getObject();
        }
        boolean hasFault = false;
        if (this.parent != null && this.parent.isFault() || omElement.getQName().getLocalPart().equals("Fault")) {
            hasFault = true;
        }
        if (!hasFault) {
            busObject = super._getBOFromOM(omElement, busContext);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            omElement.serialize((OutputStream)baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            busObject = new StreamSource(bais);
        }
        return busObject;
    }

    protected XMLStreamReader _getReaderFromBO(Object busObj, Object busContext) throws XMLStreamException, WebServiceException {
        try {
            if (busObj instanceof StreamSource) {
                XMLInputFactory f = StAXUtils.getXMLInputFactory();
                return f.createXMLStreamReader((Source)busObj);
            }
            return this._slow_getReaderFromSource((Source)busObj);
        }
        catch (Exception e) {
            String className = busObj == null ? "none" : busObj.getClass().getName();
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SourceReadErr", (String)className), (Throwable)e);
        }
    }

    private XMLStreamReader _slow_getReaderFromSource(Source src) throws XMLStreamException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start _slow_getReaderFromSource");
        }
        byte[] bytes = (byte[])ConvertUtils.convert(src, byte[].class);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully converted to ByteArray");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        XMLStreamReader reader = StAXUtils.createXMLStreamReader((InputStream)bais);
        if (log.isDebugEnabled()) {
            log.debug((Object)("End _slow_getReaderFromSource =" + reader));
        }
        return reader;
    }

    protected void _outputFromBO(Object busObject, Object busContext, XMLStreamWriter writer) throws XMLStreamException, WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start _outputFromBO");
        }
        XMLStreamReader reader = this._getReaderFromBO(busObject, busContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Obtained reader=" + reader));
        }
        this._outputFromReader(reader, writer);
        if (log.isDebugEnabled()) {
            log.debug((Object)"End _outputReaderFromBO");
        }
    }

    protected Object _getBOFromBO(Object busObject, Object busContext, boolean consume) {
        if (consume) {
            return busObject;
        }
        throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SourceMissingSupport", (String)busObject.getClass().getName()));
    }

    public boolean isElementData() {
        return false;
    }

    private static Class forName(final String className) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Class.forName(className);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    public void close() {
    }

    public InputStream getXMLInputStream(String encoding) throws UnsupportedEncodingException {
        try {
            byte[] bytes = (byte[])ConvertUtils.convert(this.getBusinessObject(false), byte[].class);
            return new ByteArrayInputStream(bytes);
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public Object getObject() {
        try {
            return this.getBusinessObject(false);
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public boolean isDestructiveRead() {
        return true;
    }

    public boolean isDestructiveWrite() {
        return true;
    }

    public byte[] getXMLBytes(String encoding) throws UnsupportedEncodingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start getXMLBytes");
        }
        byte[] bytes = null;
        try {
            bytes = (byte[])ConvertUtils.convert(this.getBusinessObject(false), byte[].class);
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End getXMLBytes");
        }
        return bytes;
    }

    static {
        block5: {
            log = LogFactory.getLog(SourceBlockImpl.class);
            staxSource = null;
            try {
                staxSource = SourceBlockImpl.forName("javax.xml.transform.stax.StAXSource");
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)"StAXSource is not present in the JDK.  This is acceptable.  Processing continues");
            }
        }
        try {
            if (XMLInputFactory.newInstance().getClass().getName().indexOf("wstx") != -1) {
                staxSource = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

