/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.StringTokenizer;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;

public abstract class BaseWSDLLocator {
    private static Log log = LogFactory.getLog(BaseWSDLLocator.class);
    protected String baseURI;
    protected String lastestImportURI;
    protected InputStream baseInputStream;
    private static final char WSDL_PATH_SEPERATOR_CHAR = '/';
    private static final String WSDL_PATH_SEPERATOR = Character.valueOf('/').toString();

    protected abstract InputStream getInputStream(String var1) throws IOException;

    protected abstract String getRedirectedURI(String var1, String var2);

    public InputSource getBaseInputSource() {
        return new InputSource(this.baseInputStream);
    }

    public InputSource getImportInputSource(String parentLocation, String relativeLocation) {
        InputStream is;
        block18: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getImportInputSource, parentLocation= " + parentLocation + " relativeLocation= " + relativeLocation));
            }
            is = null;
            URL absoluteURL = null;
            String redirectedURI = this.getRedirectedURI(relativeLocation, parentLocation);
            if (redirectedURI != null) {
                relativeLocation = redirectedURI;
            }
            try {
                if (this.isAbsoluteImport(relativeLocation)) {
                    block17: {
                        try {
                            absoluteURL = new URL(relativeLocation);
                            is = absoluteURL.openStream();
                            this.lastestImportURI = absoluteURL.toExternalForm();
                        }
                        catch (Throwable t) {
                            if (!relativeLocation.startsWith("file://")) break block17;
                            try {
                                relativeLocation = "file:/" + relativeLocation.substring("file://".length());
                                absoluteURL = new URL(relativeLocation);
                                is = absoluteURL.openStream();
                                this.lastestImportURI = absoluteURL.toExternalForm();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    if (is == null) {
                        try {
                            URI fileURI = new URI(relativeLocation);
                            absoluteURL = fileURI.toURL();
                            is = absoluteURL.openStream();
                            this.lastestImportURI = absoluteURL.toExternalForm();
                        }
                        catch (Throwable fileURI) {
                            // empty catch block
                        }
                    }
                    if (is == null) {
                        try {
                            File file = new File(relativeLocation);
                            absoluteURL = file.toURI().toURL();
                            is = absoluteURL.openStream();
                            this.lastestImportURI = absoluteURL.toExternalForm();
                        }
                        catch (Throwable file) {}
                    }
                    break block18;
                }
                String importPath = this.normalizePath(parentLocation, relativeLocation);
                is = this.getInputStream(importPath);
                this.lastestImportURI = importPath;
            }
            catch (IOException ex) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("WSDLRelativeErr1", relativeLocation, parentLocation, ex.toString()));
            }
        }
        if (is == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("WSDLRelativeErr2", relativeLocation, parentLocation));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loaded file: " + relativeLocation));
        }
        return new InputSource(is);
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public String getLatestImportURI() {
        return this.lastestImportURI;
    }

    protected String convertURI(String rawURI) {
        int idx = rawURI.lastIndexOf(47);
        if (idx > 0) {
            rawURI = rawURI.substring(0, idx + 1);
            return rawURI;
        }
        idx = rawURI.lastIndexOf(92);
        if (idx > 0) {
            rawURI = rawURI.substring(0, idx + 1);
            return rawURI;
        }
        return "";
    }

    protected boolean isAbsoluteImport(String uri) {
        boolean absolute = false;
        if (uri != null) {
            if (uri.indexOf(":/") != -1) {
                absolute = true;
            } else if (uri.indexOf(":\\") != -1) {
                absolute = true;
            }
        }
        return absolute;
    }

    protected String normalizePath(String parentLocation, String relativeLocation) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("normalizePath, parentLocation= " + parentLocation + " relativeLocation= " + relativeLocation));
        }
        String pathFromRoot = this.convertURI(parentLocation);
        StringBuffer pathToRelativeLocation = new StringBuffer(pathFromRoot);
        StringTokenizer tokenizedRelativeLocation = new StringTokenizer(relativeLocation, WSDL_PATH_SEPERATOR);
        if (log.isDebugEnabled()) {
            log.debug((Object)("pathFromRoot = " + pathFromRoot));
            log.debug((Object)("relativeLocation = " + relativeLocation));
        }
        while (tokenizedRelativeLocation.hasMoreTokens()) {
            String nextToken = tokenizedRelativeLocation.nextToken();
            if (nextToken.equals("..")) {
                int charToDelete = pathToRelativeLocation.length() - 1;
                if (pathToRelativeLocation.charAt(charToDelete) == '/' || pathToRelativeLocation.charAt(charToDelete) == '\\') {
                    pathToRelativeLocation.deleteCharAt(charToDelete--);
                }
                while (pathToRelativeLocation.charAt(charToDelete) != '/' && pathToRelativeLocation.charAt(charToDelete) != '\\') {
                    pathToRelativeLocation.deleteCharAt(charToDelete--);
                }
                continue;
            }
            if (nextToken.equals(".")) continue;
            if (pathToRelativeLocation.indexOf(String.valueOf('/')) != -1 && pathToRelativeLocation.charAt(pathToRelativeLocation.length() - 1) != '/') {
                pathToRelativeLocation.append('/');
            } else if (pathToRelativeLocation.indexOf("\\") != -1 && pathToRelativeLocation.charAt(pathToRelativeLocation.length() - 1) != '\\') {
                pathToRelativeLocation.append('\\');
            }
            pathToRelativeLocation.append(nextToken);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Built path = " + pathToRelativeLocation.toString()));
        }
        return pathToRelativeLocation.toString();
    }
}

