/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.SparseBlock;
import org.apache.sysml.runtime.matrix.data.SparseBlockMCSR;
import org.apache.sysml.runtime.util.MapReduceTool;

public abstract class MatrixReader {
    protected static final Log LOG = LogFactory.getLog(MatrixReader.class.getName());
    protected static final boolean AGGREGATE_BLOCK_NNZ = true;
    protected static final boolean RETURN_EMPTY_NNZ0 = true;

    public abstract MatrixBlock readMatrixFromHDFS(String var1, long var2, long var4, int var6, int var7, long var8) throws IOException, DMLRuntimeException;

    public abstract MatrixBlock readMatrixFromInputStream(InputStream var1, long var2, long var4, int var6, int var7, long var8) throws IOException, DMLRuntimeException;

    protected static MatrixBlock createOutputMatrixBlock(long rlen, long clen, int bclen, int brlen, long estnnz, boolean mallocDense, boolean mallocSparse) throws IOException {
        MatrixBlock ret;
        block7: {
            long numBlocks;
            int numThreads;
            boolean sparse;
            block6: {
                if (!OptimizerUtils.isValidCPDimensions(rlen, clen)) {
                    throw new DMLRuntimeException("Matrix dimensions too large for CP runtime: " + rlen + " x " + clen);
                }
                sparse = MatrixBlock.evalSparseFormatInMemory(rlen, clen, estnnz);
                numThreads = OptimizerUtils.getParallelBinaryReadParallelism();
                numBlocks = (long)Math.ceil((double)rlen / (double)brlen);
                ret = new MatrixBlock((int)rlen, (int)clen, sparse, estnnz);
                if (sparse || !mallocDense) break block6;
                ret.allocateDenseBlockUnsafe((int)rlen, (int)clen);
                break block7;
            }
            if (!sparse || !mallocSparse) break block7;
            ret.allocateSparseRowsBlock();
            SparseBlock sblock = ret.getSparseBlock();
            if (sblock instanceof SparseBlockMCSR && clen > (long)bclen && clen >= 0L && bclen > 0 && rlen >= 0L && brlen > 0) {
                if ((long)numThreads <= numBlocks) {
                    int i = 0;
                    while ((long)i < rlen) {
                        sblock.allocate(i, Math.max((int)(estnnz / rlen), 2), (int)clen);
                        i += brlen;
                    }
                } else {
                    int i = 0;
                    while ((long)i < rlen) {
                        sblock.allocate(i, Math.max((int)(estnnz / rlen), 2), (int)clen);
                        ++i;
                    }
                }
            }
        }
        return ret;
    }

    protected static void checkValidInputFile(FileSystem fs, Path path) throws IOException {
        if (!fs.exists(path)) {
            throw new IOException("File " + path.toString() + " does not exist on HDFS/LFS.");
        }
        if (MapReduceTool.isFileEmpty(fs, path)) {
            throw new EOFException("Empty input file " + path.toString() + ".");
        }
    }

    protected static void sortSparseRowsParallel(MatrixBlock dest, long rlen, int k, ExecutorService pool) throws InterruptedException, ExecutionException {
        ArrayList<SortRowsTask> tasks = new ArrayList<SortRowsTask>();
        int k2 = (int)Math.min((long)(8 * k), rlen);
        int blklen = (int)Math.ceil((double)rlen / (double)k2);
        int i = 0;
        while (i < k2 & (long)(i * blklen) < rlen) {
            tasks.add(new SortRowsTask(dest, i * blklen, Math.min((i + 1) * blklen, (int)rlen)));
            ++i;
        }
        List rt2 = pool.invokeAll(tasks);
        for (Future task : rt2) {
            task.get();
        }
    }

    private static class SortRowsTask
    implements Callable<Object> {
        private MatrixBlock _dest = null;
        private int _rl = -1;
        private int _ru = -1;

        public SortRowsTask(MatrixBlock dest, int rl, int ru) {
            this._dest = dest;
            this._rl = rl;
            this._ru = ru;
        }

        @Override
        public Object call() throws Exception {
            SparseBlock sblock = this._dest.getSparseBlock();
            if (sblock != null) {
                for (int i = this._rl; i < this._ru; ++i) {
                    if (sblock.isEmpty(i)) continue;
                    sblock.sort(i);
                }
            }
            return null;
        }
    }
}

