/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;

public class BinaryMatrixScalarCPInstruction
extends BinaryCPInstruction {
    protected BinaryMatrixScalarCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.Binary, op, in1, in2, out, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        CPOperand mat = this.input1.getDataType() == Types.DataType.MATRIX ? this.input1 : this.input2;
        CPOperand scalar = this.input1.getDataType() == Types.DataType.MATRIX ? this.input2 : this.input1;
        MatrixBlock inBlock = ec.getMatrixInput(mat.getName());
        ScalarObject constant = ec.getScalarInput(scalar);
        ScalarOperator sc_op = (ScalarOperator)this._optr;
        sc_op = sc_op.setConstant(constant.getDoubleValue());
        MatrixBlock retBlock = inBlock.scalarOperations(sc_op, new MatrixBlock());
        ec.releaseMatrixInput(mat.getName());
        if (this.checkGuardedRepresentationChange(inBlock, retBlock)) {
            retBlock.examSparsity();
        }
        ec.setMatrixOutput(this.output.getName(), retBlock);
    }
}

