/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.codegen.CodegenUtils;
import org.apache.sysds.runtime.codegen.SpoofOperator;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.lineage.LineageCodegenItem;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class SpoofCPInstruction
extends ComputationCPInstruction {
    private final Class<?> _class;
    private final SpoofOperator _op;
    private final int _numThreads;
    private final CPOperand[] _in;

    private SpoofCPInstruction(SpoofOperator op, Class<?> cla, int k, CPOperand[] in, CPOperand out, String opcode, String str) {
        super(CPInstruction.CPType.SpoofFused, null, null, null, out, opcode, str);
        this._class = cla;
        this._op = op;
        this._numThreads = k;
        this._in = in;
    }

    public Class<?> getOperatorClass() {
        return this._class;
    }

    public static SpoofCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        ArrayList<CPOperand> inlist = new ArrayList<CPOperand>();
        Class<?> cla = CodegenUtils.getClass(parts[1]);
        SpoofOperator op = CodegenUtils.createInstance(cla);
        String opcode = parts[0] + op.getSpoofType();
        for (int i = 2; i < parts.length - 2; ++i) {
            inlist.add(new CPOperand(parts[i]));
        }
        CPOperand out = new CPOperand(parts[parts.length - 2]);
        int k = Integer.parseInt(parts[parts.length - 1]);
        return new SpoofCPInstruction(op, cla, k, inlist.toArray(new CPOperand[0]), out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        Serializable out;
        ArrayList<MatrixBlock> inputs = new ArrayList<MatrixBlock>();
        ArrayList<ScalarObject> scalars = new ArrayList<ScalarObject>();
        for (CPOperand input : this._in) {
            if (input.getDataType() == Types.DataType.MATRIX) {
                inputs.add(ec.getMatrixInput(input.getName()));
                continue;
            }
            if (input.getDataType() != Types.DataType.SCALAR) continue;
            scalars.add(ec.getScalarInput(input));
        }
        if (this.output.getDataType() == Types.DataType.MATRIX) {
            out = this._op.execute(inputs, scalars, new MatrixBlock(), this._numThreads);
            ec.setMatrixOutput(this.output.getName(), (MatrixBlock)out);
        } else if (this.output.getDataType() == Types.DataType.SCALAR) {
            out = this._op.execute(inputs, scalars, this._numThreads);
            ec.setScalarOutput(this.output.getName(), (ScalarObject)out);
        }
        for (CPOperand input : this._in) {
            if (input.getDataType() != Types.DataType.MATRIX) continue;
            ec.releaseMatrixInput(input.getName());
        }
    }

    @Override
    public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
        LineageItem LIroot = LineageCodegenItem.getCodegenLTrace(this.getOperatorClass().getName()).deepCopy();
        LineageItemUtils.replaceDagLeaves(ec, LIroot, this._in);
        return Pair.of((Object)this.output.getName(), (Object)LIroot);
    }
}

