/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.privacy.propagation;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.sysds.runtime.instructions.cp.ListObject;
import org.apache.sysds.runtime.privacy.PrivacyConstraint;
import org.apache.sysds.runtime.privacy.PrivacyUtils;
import org.apache.sysds.runtime.privacy.finegrained.DataRange;
import org.apache.sysds.runtime.privacy.propagation.Propagator;

public class ListAppendPropagator
implements Propagator {
    private final ListObject input1;
    private final ListObject input2;
    private final PrivacyConstraint privacyConstraint1;
    private final PrivacyConstraint privacyConstraint2;

    public ListAppendPropagator(ListObject input1, PrivacyConstraint privacyConstraint1, ListObject input2, PrivacyConstraint privacyConstraint2) {
        this.input1 = input1;
        this.input2 = input2;
        this.privacyConstraint1 = privacyConstraint1;
        this.privacyConstraint2 = privacyConstraint2;
    }

    @Override
    public PrivacyConstraint propagate() {
        PrivacyConstraint mergedPrivacyConstraint = new PrivacyConstraint();
        this.propagateInput1Constraint(mergedPrivacyConstraint);
        this.propagateInput2Constraint(mergedPrivacyConstraint);
        return mergedPrivacyConstraint;
    }

    private void propagateInput1Constraint(PrivacyConstraint mergedPrivacyConstraint) {
        if (PrivacyUtils.privacyConstraintActivated(this.privacyConstraint1)) {
            mergedPrivacyConstraint.getFineGrainedPrivacy().put(new DataRange(new long[]{0L}, new long[]{this.input1.getLength() - 1}), this.privacyConstraint1.getPrivacyLevel());
        }
        if (PrivacyUtils.privacyConstraintFineGrainedActivated(this.privacyConstraint1)) {
            this.privacyConstraint1.getFineGrainedPrivacy().getAllConstraintsList().forEach((Consumer<Map.Entry<DataRange, PrivacyConstraint.PrivacyLevel>>)((Consumer<Map.Entry>)constraint -> mergedPrivacyConstraint.getFineGrainedPrivacy().put((DataRange)constraint.getKey(), (PrivacyConstraint.PrivacyLevel)((Object)((Object)constraint.getValue())))));
        }
    }

    private void propagateInput2Constraint(PrivacyConstraint mergedPrivacyConstraint) {
        if (PrivacyUtils.privacyConstraintActivated(this.privacyConstraint2)) {
            mergedPrivacyConstraint.getFineGrainedPrivacy().put(new DataRange(new long[]{this.input1.getLength()}, new long[]{this.input1.getLength() + this.input2.getLength() - 1}), this.privacyConstraint2.getPrivacyLevel());
        }
        if (PrivacyUtils.privacyConstraintFineGrainedActivated(this.privacyConstraint2)) {
            for (Map.Entry<DataRange, PrivacyConstraint.PrivacyLevel> constraint : this.privacyConstraint2.getFineGrainedPrivacy().getAllConstraintsList()) {
                long beginIndex = constraint.getKey().getBeginDims()[0] + (long)this.input1.getLength();
                long endIndex = constraint.getKey().getEndDims()[0] + (long)this.input1.getLength();
                mergedPrivacyConstraint.getFineGrainedPrivacy().put(new DataRange(new long[]{beginIndex}, new long[]{endIndex}), constraint.getValue());
            }
        }
    }
}

