/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.codehaus.commons.compiler.ICompilerFactory;
import org.codehaus.commons.nullanalysis.Nullable;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.ExpressionEvaluator;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.InternalCompilerException;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.TokenType;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.util.Benchmark;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.StringPattern;
import org.codehaus.janino.util.Traverser;
import org.codehaus.janino.util.iterator.DirectoryIterator;
import org.codehaus.janino.util.resource.PathResourceFinder;

public class JGrep {
    private static final Logger LOGGER = Logger.getLogger(JGrep.class.getName());
    private final List<UnitCompiler> parsedCompilationUnits = new ArrayList<UnitCompiler>();
    private static final String[] USAGE = new String[]{"Usage:", "", "  java org.codehaus.janino.tools.JGrep [ <option> ... ] <root-dir> ... <pattern> ...", "  java org.codehaus.janino.tools.JGrep -help", "", "Reads a set of compilation units from the files in the <root-dir>s and their", "subdirectories and searches them for specific Java[TM] constructs, e.g.", "invocations of a particular method.", "", "Supported <option>s are ('cp' is a 'combined pattern, like '*.java-*Generated*'):", "  -dirs <dir-cp>             Ignore subdirectories which don't match", "  -files <file-cp>           Include only matching files (default is '*.java')", "  -classpath <classpath>", "  -extdirs <classpath>", "  -bootclasspath <classpath>", "  -encoding <encoding>", "  -verbose", "", "Supported <pattern>s are:", "  -method-invocation <method-pattern> [ predicate:<predicate-expression> | action:<action-script> ] ...", "<method-pattern> is ('<ip>' is an 'identifier pattern' like '*foo*'):", "  -method-invocation <method-ip>", "  -method-invocation <simple-class-ip>.<method-ip>", "  -method-invocation <fully-qualified-class-ip>.<method-ip>", "  -method-invocation <method-ip>([<parameter-ip>[,<parameter-ip>]...])", "", "<predicate-expression> is a Java[TM] expression with the following signature:", "  boolean evaluate(UnitCompiler uc, Java.Invocation invocation, IClass.IMethod method)", "", "<action-script> is either", "  print-location-and-match", "  print-location", ", or a Java[TM] script (method body) with the following signature:", "  void execute(UnitCompiler uc, Java.Invocation invocation, IClass.IMethod method)"};
    private final IClassLoader iClassLoader;
    @Nullable
    private final String optionalCharacterEncoding;
    private final Benchmark benchmark;

    public static void main(String[] args) {
        String arg;
        int idx;
        StringPattern[] directoryNamePatterns = StringPattern.PATTERNS_ALL;
        StringPattern[] fileNamePatterns = new StringPattern[]{new StringPattern("*.java")};
        File[] classPath = new File[]{new File(".")};
        File[] optionalExtDirs = null;
        File[] optionalBootClassPath = null;
        String optionalCharacterEncoding = null;
        boolean verbose = false;
        for (idx = 0; idx < args.length && (arg = args[idx]).charAt(0) == '-'; ++idx) {
            if ("-dirs".equals(arg)) {
                directoryNamePatterns = StringPattern.parseCombinedPattern(args[++idx]);
                continue;
            }
            if ("-files".equals(arg)) {
                fileNamePatterns = StringPattern.parseCombinedPattern(args[++idx]);
                continue;
            }
            if ("-classpath".equals(arg)) {
                classPath = PathResourceFinder.parsePath(args[++idx]);
                continue;
            }
            if ("-extdirs".equals(arg)) {
                optionalExtDirs = PathResourceFinder.parsePath(args[++idx]);
                continue;
            }
            if ("-bootclasspath".equals(arg)) {
                optionalBootClassPath = PathResourceFinder.parsePath(args[++idx]);
                continue;
            }
            if ("-encoding".equals(arg)) {
                optionalCharacterEncoding = args[++idx];
                continue;
            }
            if ("-verbose".equals(arg)) {
                verbose = true;
                continue;
            }
            if ("-help".equals(arg)) {
                for (String s : USAGE) {
                    System.out.println(s);
                }
                System.exit(1);
                continue;
            }
            System.err.println("Unexpected command-line argument \"" + arg + "\", try \"-help\".");
            System.exit(1);
            return;
        }
        int first = idx;
        while (idx < args.length && args[idx].charAt(0) != '-') {
            ++idx;
        }
        if (idx == first) {
            System.err.println("No <directory-path>es given, try \"-help\".");
            System.exit(1);
            return;
        }
        File[] rootDirectories = new File[idx - first];
        for (int i = first; i < idx; ++i) {
            rootDirectories[i - first] = new File(args[i]);
        }
        JGrep jGrep = new JGrep(classPath, optionalExtDirs, optionalBootClassPath, optionalCharacterEncoding, verbose);
        ArrayList<MethodInvocationTarget> mits = new ArrayList<MethodInvocationTarget>();
        while (idx < args.length) {
            MethodInvocationTarget mit;
            String arg2 = args[idx];
            if ("-method-invocation".equals(arg2)) {
                try {
                    mit = JGrep.parseMethodInvocationPattern(args[++idx]);
                }
                catch (Exception ex) {
                    System.err.println("Parsing method invocation pattern \"" + args[idx] + "\": " + ex.getMessage());
                    System.exit(1);
                    return;
                }
                while (idx < args.length - 1) {
                    arg2 = args[idx + 1];
                    if (arg2.startsWith("predicate:")) {
                        String predicateExpression = arg2.substring(10);
                        try {
                            ExpressionEvaluator ee = new ExpressionEvaluator();
                            ee.setClassName(JGrep.class.getName() + "PE");
                            mit.predicates.add((MethodInvocationPredicate)ee.createFastEvaluator(predicateExpression, MethodInvocationPredicate.class, new String[]{"uc", "invocation", "method"}));
                        }
                        catch (Exception ex) {
                            System.err.println("Compiling predicate expression \"" + predicateExpression + "\": " + ex.getMessage());
                            System.exit(1);
                            return;
                        }
                    }
                    if (!arg2.startsWith("action:")) break;
                    String action = arg2.substring(7);
                    try {
                        mit.actions.add(JGrep.getMethodInvocationAction(action));
                    }
                    catch (Exception ex) {
                        System.err.println("Compiling method invocation action \"" + action + "\": " + ex.getMessage());
                        System.exit(1);
                        return;
                    }
                    ++idx;
                }
            } else {
                System.err.println("Unexpected command-line argument \"" + arg2 + "\", try \"-help\".");
                System.exit(1);
                return;
            }
            mits.add(mit);
            ++idx;
        }
        try {
            jGrep.jGrep(rootDirectories, directoryNamePatterns, fileNamePatterns, mits);
        }
        catch (Exception e) {
            System.err.println(e.toString());
            System.exit(1);
        }
    }

    private static MethodInvocationAction getMethodInvocationAction(String action) throws CompileException {
        ICompilerFactory cf;
        if ("print-location-and-match".equals(action)) {
            return new MethodInvocationAction(){

                @Override
                public void execute(UnitCompiler uc, Java.Invocation invocation, IClass.IMethod method) {
                    System.out.println(invocation.getLocation() + ": " + method);
                }
            };
        }
        if ("print-location".equals(action)) {
            return new MethodInvocationAction(){

                @Override
                public void execute(UnitCompiler uc, Java.Invocation invocation, IClass.IMethod method) {
                    System.out.println(invocation.getLocation());
                }
            };
        }
        try {
            cf = CompilerFactoryFactory.getDefaultCompilerFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalCompilerException("Getting default compiler factory", e);
        }
        return (MethodInvocationAction)cf.newScriptEvaluator().createFastEvaluator(action, MethodInvocationAction.class, new String[]{"uc", "invocation", "method"});
    }

    private static MethodInvocationTarget parseMethodInvocationPattern(String mip) throws CompileException, IOException {
        String s;
        MethodInvocationTarget mit = new MethodInvocationTarget();
        Scanner scanner = new Scanner(null, new StringReader(mip));
        Parser parser = new Parser(scanner);
        while (true) {
            s = JGrep.readIdentifierPattern(parser);
            if (parser.peekRead("(")) {
                mit.methodNamePattern = s;
                ArrayList<String> l = new ArrayList<String>();
                if (!parser.peekRead(")")) {
                    while (true) {
                        l.add(JGrep.readIdentifierPattern(parser));
                        if (parser.peek(")")) break;
                        parser.read(",");
                    }
                }
                mit.optionalArgumentTypeNamePatterns = l.toArray(new String[l.size()]);
                return mit;
            }
            if (parser.peekRead(".")) {
                if (mit.optionalClassNamePattern == null) {
                    mit.optionalClassNamePattern = s;
                    continue;
                }
                mit.optionalClassNamePattern = mit.optionalClassNamePattern + '.' + s;
                continue;
            }
            if (parser.peek(TokenType.END_OF_INPUT)) break;
        }
        mit.methodNamePattern = s;
        return mit;
    }

    private static String readIdentifierPattern(Parser p) throws CompileException, IOException {
        StringBuilder sb = new StringBuilder();
        if (p.peekRead("*")) {
            sb.append('*');
        } else {
            sb.append(p.read(TokenType.IDENTIFIER));
        }
        while (true) {
            if (p.peekRead("*")) {
                sb.append('*');
                continue;
            }
            if (!p.peek(TokenType.IDENTIFIER)) break;
            sb.append(p.read(TokenType.IDENTIFIER));
        }
        return sb.toString();
    }

    static boolean typeMatches(@Nullable String pattern, String typeName) {
        return pattern == null || new StringPattern(pattern).matches(pattern.indexOf(46) == -1 ? typeName.substring(typeName.lastIndexOf(46) + 1) : typeName);
    }

    public JGrep(File[] classPath, @Nullable File[] optionalExtDirs, @Nullable File[] optionalBootClassPath, @Nullable String optionalCharacterEncoding, boolean verbose) {
        this(IClassLoader.createJavacLikePathIClassLoader(optionalBootClassPath, optionalExtDirs, classPath), optionalCharacterEncoding, verbose);
        this.benchmark.report("*** JGrep - search Java(TM) source files for specific language constructs");
        this.benchmark.report("*** For more information visit http://janino.codehaus.org");
        this.benchmark.report("Class path", classPath);
        this.benchmark.report("Ext dirs", optionalExtDirs);
        this.benchmark.report("Boot class path", optionalBootClassPath);
        this.benchmark.report("Character encoding", optionalCharacterEncoding);
    }

    public JGrep(IClassLoader iClassLoader, @Nullable String optionalCharacterEncoding, boolean verbose) {
        this.iClassLoader = new JGrepIClassLoader(iClassLoader);
        this.optionalCharacterEncoding = optionalCharacterEncoding;
        this.benchmark = new Benchmark(verbose);
    }

    private void jGrep(File[] rootDirectories, final StringPattern[] directoryNamePatterns, final StringPattern[] fileNamePatterns, List<MethodInvocationTarget> methodInvocationTargets) throws CompileException, IOException {
        this.benchmark.report("Root dirs", rootDirectories);
        this.benchmark.report("Directory name patterns", directoryNamePatterns);
        this.benchmark.report("File name patterns", fileNamePatterns);
        this.jGrep(DirectoryIterator.traverseDirectories(rootDirectories, new FilenameFilter(){

            @Override
            public boolean accept(@Nullable File dir, @Nullable String name) {
                assert (dir != null);
                assert (name != null);
                return StringPattern.matches(directoryNamePatterns, name);
            }
        }, new FilenameFilter(){

            @Override
            public boolean accept(@Nullable File dir, @Nullable String name) {
                assert (dir != null);
                assert (name != null);
                return StringPattern.matches(fileNamePatterns, name);
            }
        }), methodInvocationTargets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jGrep(Iterator<File> sourceFilesIterator, final List<MethodInvocationTarget> methodInvocationTargets) throws CompileException, IOException {
        this.benchmark.beginReporting();
        int sourceFileCount = 0;
        try {
            while (sourceFilesIterator.hasNext()) {
                File sourceFile = sourceFilesIterator.next();
                UnitCompiler uc = new UnitCompiler(this.parseCompilationUnit(sourceFile, this.optionalCharacterEncoding), this.iClassLoader);
                this.parsedCompilationUnits.add(uc);
                ++sourceFileCount;
            }
        }
        finally {
            this.benchmark.endReporting("Parsed " + sourceFileCount + " source file(s)");
        }
        this.benchmark.beginReporting();
        try {
            for (final UnitCompiler unitCompiler : this.parsedCompilationUnits) {
                Java.CompilationUnit compilationUnit = unitCompiler.getCompilationUnit();
                this.benchmark.beginReporting("Grepping \"" + compilationUnit.optionalFileName + "\"");
                try {
                    new Traverser<CompileException>(){

                        @Override
                        public void traverseMethodInvocation(Java.MethodInvocation mi) throws CompileException {
                            this.match(mi, unitCompiler.findIMethod(mi));
                            super.traverseMethodInvocation(mi);
                        }

                        @Override
                        public void traverseSuperclassMethodInvocation(Java.SuperclassMethodInvocation scmi) throws CompileException {
                            this.match(scmi, unitCompiler.findIMethod(scmi));
                            super.traverseSuperclassMethodInvocation(scmi);
                        }

                        @Override
                        public void traverseNewClassInstance(Java.NewClassInstance nci) throws CompileException {
                            super.traverseNewClassInstance(nci);
                        }

                        @Override
                        public void traverseNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) throws CompileException {
                            super.traverseNewAnonymousClassInstance(naci);
                        }

                        @Override
                        public void traverseConstructorInvocation(Java.ConstructorInvocation ci) throws CompileException {
                            super.traverseConstructorInvocation(ci);
                        }

                        private void match(Java.Invocation invocation, IClass.IMethod method) throws CompileException {
                            for (MethodInvocationTarget mit : methodInvocationTargets) {
                                mit.apply(unitCompiler, invocation, method);
                            }
                        }
                    }.traverseCompilationUnit(compilationUnit);
                }
                finally {
                    this.benchmark.endReporting();
                }
            }
        }
        finally {
            this.benchmark.endReporting("Traversed " + sourceFileCount + " compilation units");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Java.CompilationUnit parseCompilationUnit(File sourceFile, @Nullable String optionalCharacterEncoding) throws CompileException, IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(sourceFile));
        try {
            Parser parser = new Parser(new Scanner(sourceFile.getPath(), is, optionalCharacterEncoding));
            this.benchmark.beginReporting("Parsing \"" + sourceFile + "\"");
            try {
                Java.CompilationUnit compilationUnit = parser.parseCompilationUnit();
                this.benchmark.endReporting();
                return compilationUnit;
            }
            catch (Throwable throwable) {
                this.benchmark.endReporting();
                throw throwable;
            }
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static File getClassFile(String className, File sourceFile, @Nullable File optionalDestinationDirectory) {
        if (optionalDestinationDirectory != null) {
            return new File(optionalDestinationDirectory, ClassFile.getClassFileResourceName(className));
        }
        int idx = className.lastIndexOf(46);
        return new File(sourceFile.getParentFile(), ClassFile.getClassFileResourceName(className.substring(idx + 1)));
    }

    private class JGrepIClassLoader
    extends IClassLoader {
        JGrepIClassLoader(IClassLoader optionalParentIClassLoader) {
            super(optionalParentIClassLoader);
            super.postConstruct();
        }

        @Override
        @Nullable
        protected IClass findIClass(String type) {
            LOGGER.entering(null, "findIClass", type);
            String className = Descriptor.toClassName(type);
            LOGGER.log(Level.FINE, "className={0}", className);
            if (className.startsWith("java.")) {
                return null;
            }
            for (int i = 0; i < JGrep.this.parsedCompilationUnits.size(); ++i) {
                UnitCompiler uc = (UnitCompiler)JGrep.this.parsedCompilationUnits.get(i);
                IClass res = uc.findClass(className);
                if (res == null) continue;
                this.defineIClass(res);
                return res;
            }
            return null;
        }
    }

    static interface MethodInvocationAction {
        public void execute(UnitCompiler var1, Java.Invocation var2, IClass.IMethod var3) throws Exception;
    }

    static interface MethodInvocationPredicate {
        public boolean evaluate(UnitCompiler var1, Java.Invocation var2, IClass.IMethod var3) throws Exception;
    }

    private static class MethodInvocationTarget {
        @Nullable
        String optionalClassNamePattern;
        @Nullable
        String methodNamePattern;
        @Nullable
        String[] optionalArgumentTypeNamePatterns;
        List<MethodInvocationPredicate> predicates = new ArrayList<MethodInvocationPredicate>();
        List<MethodInvocationAction> actions = new ArrayList<MethodInvocationAction>();

        private MethodInvocationTarget() {
        }

        void apply(UnitCompiler uc, Java.Invocation invocation, IClass.IMethod method) throws CompileException {
            if (this.optionalClassNamePattern != null && !JGrep.typeMatches(this.optionalClassNamePattern, Descriptor.toClassName(method.getDeclaringIClass().getDescriptor()))) {
                return;
            }
            if (!new StringPattern(this.methodNamePattern).matches(method.getName())) {
                return;
            }
            IClass[] fpts = method.getParameterTypes();
            if (this.optionalArgumentTypeNamePatterns != null) {
                String[] atnps = this.optionalArgumentTypeNamePatterns;
                if (atnps.length != fpts.length) {
                    return;
                }
                for (int i = 0; i < atnps.length; ++i) {
                    if (new StringPattern(atnps[i]).matches(Descriptor.toClassName(fpts[i].getDescriptor()))) continue;
                    return;
                }
            }
            for (MethodInvocationPredicate mip : this.predicates) {
                try {
                    if (mip.evaluate(uc, invocation, method)) continue;
                    return;
                }
                catch (Exception ex) {
                    return;
                }
            }
            for (MethodInvocationAction mia : this.actions) {
                try {
                    mia.execute(uc, invocation, method);
                }
                catch (Exception exception) {}
            }
        }
    }
}

