/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.plus.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import org.spark_project.jetty.util.ConcurrentHashSet;
import org.spark_project.jetty.util.Loader;
import org.spark_project.jetty.util.StringUtil;
import org.spark_project.jetty.util.log.Log;
import org.spark_project.jetty.util.log.Logger;
import org.spark_project.jetty.webapp.WebAppContext;

public class ContainerInitializer {
    private static final Logger LOG = Log.getLogger(ContainerInitializer.class);
    protected final ServletContainerInitializer _target;
    protected final Class<?>[] _interestedTypes;
    protected final Set<String> _applicableTypeNames = new ConcurrentHashSet<String>();
    protected final Set<String> _annotatedTypeNames = new ConcurrentHashSet<String>();

    public ContainerInitializer(ServletContainerInitializer target, Class<?>[] classes) {
        this._target = target;
        this._interestedTypes = classes;
    }

    public ContainerInitializer(ClassLoader loader, String toString2) {
        Matcher m = Pattern.compile("ContainerInitializer\\{(.*),interested=(.*),applicable=(.*),annotated=(.*)\\}").matcher(toString2);
        if (!m.matches()) {
            throw new IllegalArgumentException(toString2);
        }
        try {
            this._target = (ServletContainerInitializer)loader.loadClass(m.group(1)).newInstance();
            String[] interested = StringUtil.arrayFromString(m.group(2));
            this._interestedTypes = new Class[interested.length];
            for (int i = 0; i < interested.length; ++i) {
                this._interestedTypes[i] = loader.loadClass(interested[i]);
            }
            for (String s : StringUtil.arrayFromString(m.group(3))) {
                this._applicableTypeNames.add(s);
            }
            for (String s : StringUtil.arrayFromString(m.group(4))) {
                this._annotatedTypeNames.add(s);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(toString2, e);
        }
    }

    public ServletContainerInitializer getTarget() {
        return this._target;
    }

    public Class[] getInterestedTypes() {
        return this._interestedTypes;
    }

    public void addAnnotatedTypeName(String className) {
        this._annotatedTypeNames.add(className);
    }

    public Set<String> getAnnotatedTypeNames() {
        return Collections.unmodifiableSet(this._annotatedTypeNames);
    }

    public void addApplicableTypeName(String className) {
        this._applicableTypeNames.add(className);
    }

    public Set<String> getApplicableTypeNames() {
        return Collections.unmodifiableSet(this._applicableTypeNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callStartup(WebAppContext context) throws Exception {
        if (this._target != null) {
            HashSet<Class> classes = new HashSet<Class>();
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(context.getClassLoader());
            try {
                for (String s : this._applicableTypeNames) {
                    classes.add(Loader.loadClass(context.getClass(), s));
                }
                context.getServletContext().setExtendedListenerTypes(true);
                if (LOG.isDebugEnabled()) {
                    long start2 = System.nanoTime();
                    this._target.onStartup(classes, (ServletContext)context.getServletContext());
                    LOG.debug("ContainerInitializer {} called in {}ms", this._target.getClass().getName(), TimeUnit.MILLISECONDS.convert(System.nanoTime() - start2, TimeUnit.NANOSECONDS));
                } else {
                    this._target.onStartup(classes, (ServletContext)context.getServletContext());
                }
            }
            finally {
                context.getServletContext().setExtendedListenerTypes(false);
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
    }

    public String toString() {
        List interested = Collections.emptyList();
        if (this._interestedTypes != null) {
            interested = new ArrayList(this._interestedTypes.length);
            for (Class<?> c : this._interestedTypes) {
                interested.add(c.getName());
            }
        }
        return String.format("ContainerInitializer{%s,interested=%s,applicable=%s,annotated=%s}", this._target.getClass().getName(), interested, this._applicableTypeNames, this._annotatedTypeNames);
    }

    public void resolveClasses(WebAppContext context, Map<String, Set<String>> classMap) {
        Set<String> annotatedClassNames = this.getAnnotatedTypeNames();
        if (annotatedClassNames != null && !annotatedClassNames.isEmpty()) {
            for (String name : annotatedClassNames) {
                this.addApplicableTypeName(name);
                this.addInheritedTypes(classMap, classMap.get(name));
            }
        }
        if (this.getInterestedTypes() != null) {
            for (Class c : this.getInterestedTypes()) {
                if (c.isAnnotation()) continue;
                this.addInheritedTypes(classMap, classMap.get(c.getName()));
            }
        }
    }

    private void addInheritedTypes(Map<String, Set<String>> classMap, Set<String> names) {
        if (names == null || names.isEmpty()) {
            return;
        }
        for (String s : names) {
            this.addApplicableTypeName(s);
            this.addInheritedTypes(classMap, classMap.get(s));
        }
    }
}

