/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.utils.MemoryEstimates;

public class MapToBit
extends AMapToData {
    private static final long serialVersionUID = -8065234231282619923L;
    private final BitSet _data;
    private final int _size;

    public MapToBit(int unique, int size) {
        super(unique);
        this._data = new BitSet(size);
        this._size = size;
    }

    private MapToBit(int unique, BitSet d, int size) {
        super(unique);
        this._data = d;
        this._size = size;
    }

    @Override
    public int getIndex(int n) {
        return this._data.get(n) ? 1 : 0;
    }

    @Override
    public void fill(int v) {
        this._data.set(0, this._size, true);
    }

    @Override
    public long getInMemorySize() {
        return MapToBit.getInMemorySize(this._data.size());
    }

    public static long getInMemorySize(int dataLength) {
        long size = 28L;
        return size += MemoryEstimates.bitSetCost(dataLength);
    }

    @Override
    public long getExactSizeOnDisk() {
        int dSize = this._data.size();
        long size = 13L;
        size += (long)(dSize / 64 * 8);
        return size += (long)(dSize % 64 == 0 ? 0 : 8);
    }

    @Override
    public void set(int n, int v) {
        this._data.set(n, v == 1);
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public void replace(int v, int r) {
        if (v == 0 && r == 1) {
            this._data.set(0, this.size(), true);
        } else if (v == 1 && r == 0) {
            this._data.clear();
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        long[] internals = this._data.toLongArray();
        out.writeByte(MapToFactory.MAP_TYPE.BIT.ordinal());
        out.writeInt(this.getUnique());
        out.writeInt(this._size);
        out.writeInt(internals.length);
        for (int i = 0; i < internals.length; ++i) {
            out.writeLong(internals[i]);
        }
    }

    public static MapToBit readFields(DataInput in) throws IOException {
        int unique = in.readInt();
        int size = in.readInt();
        long[] internalLong = new long[in.readInt()];
        for (int i = 0; i < internalLong.length; ++i) {
            internalLong[i] = in.readLong();
        }
        return new MapToBit(unique, BitSet.valueOf(internalLong), size);
    }
}

