/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import java.util.ArrayList;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.AggBinaryOp;
import org.apache.sysds.lops.Data;
import org.apache.sysds.lops.LopProperties;
import org.apache.sysds.lops.LopsException;
import org.apache.sysds.lops.OutputParameters;
import org.apache.sysds.lops.compile.Dag;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.privacy.PrivacyConstraint;

public abstract class Lop {
    public static final String FILE_SEPARATOR = "/";
    public static final String PROCESS_PREFIX = "_p";
    public static final String CP_ROOT_THREAD_ID = "_t0";
    public static final String CP_CHILD_THREAD = "_t";
    public static final double SAMPLE_FRACTION = 0.01;
    public static final String INSTRUCTION_DELIMITOR = "\u2021";
    public static final String OPERAND_DELIMITOR = "\u00b0";
    public static final String VALUETYPE_PREFIX = "\u00b7";
    public static final String DATATYPE_PREFIX = "\u00b7";
    public static final String LITERAL_PREFIX = "\u00b7";
    public static final String VARIABLE_NAME_PLACEHOLDER = "\u00b6";
    public static final String NAME_VALUE_SEPARATOR = "=";
    public static final String MATRIX_VAR_NAME_PREFIX = "_mVar";
    public static final String FRAME_VAR_NAME_PREFIX = "_fVar";
    public static final String SCALAR_VAR_NAME_PREFIX = "_Var";
    public static final String UPDATE_INPLACE_PREFIX = "_uip";
    private boolean[] reachable = null;
    private Types.DataType _dataType;
    private Types.ValueType _valueType;
    private VisitStatus _visited = VisitStatus.NOTVISITED;
    protected Type type;
    protected ArrayList<Lop> inputs;
    protected ArrayList<Lop> outputs;
    protected PrivacyConstraint privacyConstraint;
    protected FEDInstruction.FederatedOutput _fedOutput = null;
    protected int consumerCount;
    protected OutputParameters outParams = null;
    protected LopProperties lps = null;
    public int _beginLine;
    public int _beginColumn;
    public int _endLine;
    public int _endColumn;
    public String _filename;

    public Lop(Type t, Types.DataType dt, Types.ValueType vt) {
        this.type = t;
        this._dataType = dt;
        this._valueType = vt;
        this.inputs = new ArrayList();
        this.outputs = new ArrayList();
        this.outParams = new OutputParameters();
        this.lps = new LopProperties();
    }

    public VisitStatus getVisited() {
        return this._visited;
    }

    public void setVisited(VisitStatus visited) {
        this._visited = visited;
    }

    public boolean[] getReachable() {
        return this.reachable;
    }

    public boolean[] createReachable(int size) {
        this.reachable = new boolean[size];
        return this.reachable;
    }

    public boolean isDataExecLocation() {
        return this instanceof Data;
    }

    protected void setupLopProperties(Types.ExecType et) {
        this.lps.setProperties(this.inputs, et);
    }

    public Types.DataType getDataType() {
        return this._dataType;
    }

    public void setDataType(Types.DataType dt) {
        this._dataType = dt;
    }

    public Types.ValueType getValueType() {
        return this._valueType;
    }

    public void setValueType(Types.ValueType vt) {
        this._valueType = vt;
    }

    public Type getType() {
        return this.type;
    }

    public ArrayList<Lop> getInputs() {
        return this.inputs;
    }

    public ArrayList<Lop> getOutputs() {
        return this.outputs;
    }

    public void addInput(Lop op) {
        this.inputs.add(op);
    }

    public void replaceInput(Lop oldInp, Lop newInp) {
        if (this.inputs.contains(oldInp)) {
            int index = this.inputs.indexOf(oldInp);
            this.inputs.set(index, newInp);
        }
    }

    public void addOutput(Lop op) {
        this.outputs.add(op);
    }

    public void removeOutput(Lop op) {
        this.outputs.remove(op);
    }

    public void setPrivacyConstraint(PrivacyConstraint privacy) {
        this.privacyConstraint = privacy;
    }

    public PrivacyConstraint getPrivacyConstraint() {
        return this.privacyConstraint;
    }

    public void setFederatedOutput(FEDInstruction.FederatedOutput fedOutput) {
        this._fedOutput = fedOutput;
    }

    public void setConsumerCount(int cc) {
        this.consumerCount = cc;
    }

    public int removeConsumer() {
        --this.consumerCount;
        return this.consumerCount;
    }

    public abstract String toString();

    public void resetVisitStatus() {
        if (this.getVisited() == VisitStatus.NOTVISITED) {
            return;
        }
        for (int i = 0; i < this.getInputs().size(); ++i) {
            this.getInputs().get(i).resetVisitStatus();
        }
        this.setVisited(VisitStatus.NOTVISITED);
    }

    public long getID() {
        return this.lps.getID();
    }

    public int getLevel() {
        return this.lps.getLevel();
    }

    protected void setLevel() {
        this.lps.setLevel(this.inputs);
    }

    protected void updateLevel(int newLevel) {
        if (newLevel < this.getLevel()) {
            throw new RuntimeException("Decrement the levels not supported.");
        }
        if (newLevel > this.getLevel()) {
            this.lps.setLevel(newLevel);
            for (Lop out : this.outputs) {
                if (out.getLevel() >= newLevel + 1) continue;
                out.updateLevel(newLevel + 1);
            }
        }
    }

    public Types.ExecType getExecType() {
        return this.lps.getExecType();
    }

    public void setExecType(Types.ExecType newExecType) {
        this.lps.setExecType(newExecType);
    }

    public boolean getProducesIntermediateOutput() {
        return this.lps.getProducesIntermediateOutput();
    }

    public final void addToDag(Dag<Lop> dag) {
        if (dag.addNode(this)) {
            for (Lop l : this.getInputs()) {
                l.addToDag(dag);
            }
        }
    }

    public OutputParameters getOutputParameters() {
        return this.outParams;
    }

    public AggBinaryOp.SparkAggType getAggType() {
        return AggBinaryOp.SparkAggType.NONE;
    }

    public Lop getBroadcastInput() {
        return null;
    }

    public String getInstructions(String output) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions(String input1, String output) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions(String input1, String input2, String output) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions(String input1, String input2, String input3, String output) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions(String input1, String input2, String input3, String input4, String output) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions(String input1, String input2, String input3, String input4, String input5, String output) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions(String input1, String input2, String input3, String input4, String input5, String input6, String output) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions(String input1, String input2, String input3, String input4, String input5, String input6, String input7, String output) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions(String[] inputs, String outputs) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions(String[] inputs, String[] outputs) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions() {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public SimpleInstType getSimpleInstructionType() {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public void setBeginLine(int passed) {
        this._beginLine = passed;
    }

    public void setBeginColumn(int passed) {
        this._beginColumn = passed;
    }

    public void setEndLine(int passed) {
        this._endLine = passed;
    }

    public void setEndColumn(int passed) {
        this._endColumn = passed;
    }

    public void setFilename(String passed) {
        this._filename = passed;
    }

    public void setAllPositions(String filename, int blp, int bcp, int elp, int ecp) {
        this._filename = filename;
        this._beginLine = blp;
        this._beginColumn = bcp;
        this._endLine = elp;
        this._endColumn = ecp;
    }

    public int getBeginLine() {
        return this._beginLine;
    }

    public int getBeginColumn() {
        return this._beginColumn;
    }

    public int getEndLine() {
        return this._endLine;
    }

    public int getEndColumn() {
        return this._endColumn;
    }

    public String getFilename() {
        return this._filename;
    }

    public String printErrorLocation() {
        return "ERROR: line " + this._beginLine + ", column " + this._beginColumn + " -- ";
    }

    public String getInstructions(int input, int rowl, int rowu, int coll, int colu, int leftRowDim, int leftColDim, int output) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public boolean isVariable() {
        return this.isDataExecLocation() && !((Data)this).isLiteral() || !this.isDataExecLocation();
    }

    public boolean isAllOutputsCP() {
        if (this.outputs.isEmpty()) {
            return false;
        }
        boolean outCP = true;
        for (Lop out : this.getOutputs()) {
            if (out.getExecType() == Types.ExecType.CP) continue;
            outCP = false;
            break;
        }
        return outCP;
    }

    public String prepOperand(String label, Types.DataType dt, Types.ValueType vt) {
        StringBuilder sb = new StringBuilder();
        sb.append(label);
        sb.append("\u00b7");
        sb.append((Object)dt);
        sb.append("\u00b7");
        sb.append((Object)vt);
        return sb.toString();
    }

    public String prepOperand(String label, Types.DataType dt, Types.ValueType vt, boolean literal) {
        StringBuilder sb = new StringBuilder();
        sb.append(label);
        sb.append("\u00b7");
        sb.append((Object)dt);
        sb.append("\u00b7");
        sb.append((Object)vt);
        sb.append("\u00b7");
        sb.append(literal);
        return sb.toString();
    }

    private String prepOperand(String label) {
        StringBuilder sb = new StringBuilder("");
        sb.append(label);
        sb.append("\u00b7");
        sb.append((Object)this.getDataType());
        sb.append("\u00b7");
        sb.append((Object)this.getValueType());
        return sb.toString();
    }

    public String prepOutputOperand() {
        return this.prepOperand(this.getOutputParameters().getLabel());
    }

    public String prepOutputOperand(int index) {
        return this.prepOperand(String.valueOf(index));
    }

    public String prepOutputOperand(String label) {
        return this.prepOperand(label);
    }

    public String prepScalarLabel() {
        String ret = this.getOutputParameters().getLabel();
        if (this.isVariable()) {
            ret = VARIABLE_NAME_PLACEHOLDER + ret + VARIABLE_NAME_PLACEHOLDER;
        }
        return ret;
    }

    public String prepScalarOperand(Types.ExecType et, String label) {
        boolean isData = this.isDataExecLocation();
        boolean isLiteral = isData && ((Data)this).isLiteral();
        StringBuilder sb = new StringBuilder("");
        if (et == Types.ExecType.CP || et == Types.ExecType.SPARK || et == Types.ExecType.GPU || isData && isLiteral) {
            sb.append(label);
        } else {
            sb.append(VARIABLE_NAME_PLACEHOLDER);
            sb.append(label);
            sb.append(VARIABLE_NAME_PLACEHOLDER);
        }
        sb.append("\u00b7");
        sb.append((Object)this.getDataType());
        sb.append("\u00b7");
        sb.append((Object)this.getValueType());
        sb.append("\u00b7");
        sb.append(isLiteral);
        return sb.toString();
    }

    public String prepScalarInputOperand(Types.ExecType et) {
        return this.prepScalarOperand(et, this.getOutputParameters().getLabel());
    }

    public String prepScalarInputOperand(String label) {
        boolean isData = this.isDataExecLocation();
        boolean isLiteral = isData && ((Data)this).isLiteral();
        StringBuilder sb = new StringBuilder("");
        sb.append(label);
        sb.append("\u00b7");
        sb.append((Object)this.getDataType());
        sb.append("\u00b7");
        sb.append((Object)this.getValueType());
        sb.append("\u00b7");
        sb.append(isLiteral);
        return sb.toString();
    }

    public String prepInputOperand(int index) {
        return this.prepInputOperand(String.valueOf(index));
    }

    public String prepInputOperand(String label) {
        Types.DataType dt = this.getDataType();
        if (dt == Types.DataType.MATRIX) {
            return this.prepOperand(label);
        }
        return this.prepScalarInputOperand(label);
    }

    public static enum VisitStatus {
        DONE,
        NOTVISITED;

    }

    public static enum SimpleInstType {
        Scalar;

    }

    public static enum Type {
        Data,
        DataGen,
        ReBlock,
        CSVReBlock,
        MatMultCP,
        MMCJ,
        MMRJ,
        MMTSJ,
        PMMJ,
        MapMult,
        MapMultChain,
        UnaryCP,
        UNARY,
        BinaryCP,
        Binary,
        Ternary,
        Nary,
        RightIndex,
        LeftIndex,
        ZeroOut,
        Aggregate,
        PartialAggregate,
        BinUaggChain,
        UaggOuterChain,
        TernaryAggregate,
        Grouping,
        Append,
        CombineUnary,
        CombineBinary,
        CombineTernary,
        CentralMoment,
        CoVariance,
        GroupedAgg,
        GroupedAggM,
        Transform,
        DataPartition,
        RepMat,
        ParameterizedBuiltin,
        FunctionCallCP,
        FunctionCallCPSingle,
        CumulativePartialAggregate,
        CumulativeSplitAggregate,
        CumulativeOffsetBinary,
        WeightedSquaredLoss,
        WeightedSigmoid,
        WeightedDivMM,
        WeightedCeMM,
        WeightedUMM,
        SortKeys,
        PickValues,
        Ctable,
        Checkpoint,
        PlusMult,
        MinusMult,
        SpoofFused,
        Sql,
        Federated;

    }
}

