/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.codegen.cplan;

import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.codegen.SpoofCompiler;
import org.apache.sysds.hops.codegen.cplan.CNode;
import org.apache.sysds.hops.codegen.cplan.CNodeData;
import org.apache.sysds.runtime.util.UtilFunctions;

public class CNodeUnary
extends CNode {
    private UnaryType _type;

    public CNodeUnary(CNode in1, UnaryType type) {
        this._inputs.add(in1);
        this._type = type;
        this.setOutputDims();
    }

    public UnaryType getType() {
        return this._type;
    }

    public void setType(UnaryType type) {
        this._type = type;
    }

    @Override
    public String codegen(boolean sparse, SpoofCompiler.GeneratorAPI api) {
        if (this.isGenerated()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(((CNode)this._inputs.get(0)).codegen(sparse, api));
        boolean lsparse = sparse && this._inputs.get(0) instanceof CNodeData && ((CNode)this._inputs.get(0)).getVarname().startsWith("a") && !((CNode)this._inputs.get(0)).isLiteral();
        String var = this.createVarname();
        String tmp = this.getLanguageTemplateClass(this, api).getTemplate(this._type, lsparse);
        tmp = tmp.replaceAll("%TMP%", var);
        String varj = ((CNode)this._inputs.get(0)).getVarname();
        boolean vectIn = varj.startsWith("b") && !this._type.isScalarLookup();
        tmp = this.replaceUnaryPlaceholders(tmp, varj, vectIn, api);
        sb.append(tmp);
        this._generated = true;
        return sb.toString();
    }

    public String toString() {
        switch (this._type) {
            case ROW_SUMS: {
                return "u(R+)";
            }
            case ROW_SUMSQS: {
                return "u(Rsq+)";
            }
            case ROW_MINS: {
                return "u(Rmin)";
            }
            case ROW_MAXS: {
                return "u(Rmax)";
            }
            case ROW_MEANS: {
                return "u(Rmean)";
            }
            case ROW_COUNTNNZS: {
                return "u(Rnnz)";
            }
            case VECT_EXP: 
            case VECT_POW2: 
            case VECT_MULT2: 
            case VECT_SQRT: 
            case VECT_LOG: 
            case VECT_ABS: 
            case VECT_ROUND: 
            case VECT_CEIL: 
            case VECT_SIN: 
            case VECT_COS: 
            case VECT_TAN: 
            case VECT_ASIN: 
            case VECT_ACOS: 
            case VECT_ATAN: 
            case VECT_SINH: 
            case VECT_COSH: 
            case VECT_TANH: 
            case VECT_FLOOR: 
            case VECT_CUMSUM: 
            case VECT_CUMMIN: 
            case VECT_CUMMAX: 
            case VECT_SIGN: 
            case VECT_SIGMOID: 
            case VECT_SPROP: {
                return "u(v" + this._type.name().toLowerCase() + ")";
            }
            case LOOKUP_R: {
                return "u(ixr)";
            }
            case LOOKUP_C: {
                return "u(ixc)";
            }
            case LOOKUP_RC: {
                return "u(ixrc)";
            }
            case LOOKUP0: {
                return "u(ix0)";
            }
            case POW2: {
                return "^2";
            }
        }
        return "u(" + this._type.name().toLowerCase() + ")";
    }

    @Override
    public void setOutputDims() {
        switch (this._type) {
            case VECT_EXP: 
            case VECT_POW2: 
            case VECT_MULT2: 
            case VECT_SQRT: 
            case VECT_LOG: 
            case VECT_ABS: 
            case VECT_ROUND: 
            case VECT_CEIL: 
            case VECT_SIN: 
            case VECT_COS: 
            case VECT_TAN: 
            case VECT_ASIN: 
            case VECT_ACOS: 
            case VECT_ATAN: 
            case VECT_SINH: 
            case VECT_COSH: 
            case VECT_TANH: 
            case VECT_FLOOR: 
            case VECT_CUMSUM: 
            case VECT_CUMMIN: 
            case VECT_CUMMAX: 
            case VECT_SIGN: 
            case VECT_SIGMOID: 
            case VECT_SPROP: {
                this._rows = ((CNode)this._inputs.get((int)0))._rows;
                this._cols = ((CNode)this._inputs.get((int)0))._cols;
                this._dataType = Types.DataType.MATRIX;
                break;
            }
            case ROW_SUMS: 
            case ROW_SUMSQS: 
            case ROW_MINS: 
            case ROW_MAXS: 
            case ROW_MEANS: 
            case ROW_COUNTNNZS: 
            case LOOKUP_R: 
            case LOOKUP_C: 
            case LOOKUP_RC: 
            case LOOKUP0: 
            case POW2: 
            case EXP: 
            case MULT2: 
            case ABS: 
            case SIN: 
            case COS: 
            case TAN: 
            case ASIN: 
            case ACOS: 
            case ATAN: 
            case SINH: 
            case COSH: 
            case TANH: 
            case SIGN: 
            case SQRT: 
            case LOG: 
            case ROUND: 
            case CEIL: 
            case FLOOR: 
            case SPROP: 
            case SIGMOID: 
            case LOG_NZ: {
                this._rows = 0L;
                this._cols = 0L;
                this._dataType = Types.DataType.SCALAR;
                break;
            }
            default: {
                throw new RuntimeException("Operation " + this._type.toString() + " has no output dimensions, dimensions needs to be specified for the CNode ");
            }
        }
    }

    @Override
    public int hashCode() {
        if (this._hash == 0) {
            this._hash = UtilFunctions.intHashCode(super.hashCode(), this._type.hashCode());
        }
        return this._hash;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CNodeUnary)) {
            return false;
        }
        CNodeUnary that = (CNodeUnary)o;
        return super.equals(that) && this._type == that._type;
    }

    @Override
    public boolean isSupported(SpoofCompiler.GeneratorAPI api) {
        boolean is_supported;
        boolean bl = is_supported = api == SpoofCompiler.GeneratorAPI.CUDA || api == SpoofCompiler.GeneratorAPI.JAVA;
        if (api == SpoofCompiler.GeneratorAPI.CUDA) {
            is_supported = !this._type.isNotSupportedBySpoofCUDA();
        }
        int i = 0;
        while (is_supported && i < this._inputs.size()) {
            CNode in = (CNode)this._inputs.get(i++);
            is_supported = in.isSupported(api);
        }
        return is_supported;
    }

    public static enum UnaryType {
        LOOKUP_R,
        LOOKUP_C,
        LOOKUP_RC,
        LOOKUP0,
        ROW_SUMS,
        ROW_SUMSQS,
        ROW_COUNTNNZS,
        ROW_MEANS,
        ROW_MINS,
        ROW_MAXS,
        VECT_EXP,
        VECT_POW2,
        VECT_MULT2,
        VECT_SQRT,
        VECT_LOG,
        VECT_ABS,
        VECT_ROUND,
        VECT_CEIL,
        VECT_FLOOR,
        VECT_SIGN,
        VECT_SIN,
        VECT_COS,
        VECT_TAN,
        VECT_ASIN,
        VECT_ACOS,
        VECT_ATAN,
        VECT_SINH,
        VECT_COSH,
        VECT_TANH,
        VECT_CUMSUM,
        VECT_CUMMIN,
        VECT_CUMMAX,
        VECT_SPROP,
        VECT_SIGMOID,
        EXP,
        POW2,
        MULT2,
        SQRT,
        LOG,
        LOG_NZ,
        ABS,
        ROUND,
        CEIL,
        FLOOR,
        SIGN,
        SIN,
        COS,
        TAN,
        ASIN,
        ACOS,
        ATAN,
        SINH,
        COSH,
        TANH,
        SPROP,
        SIGMOID;


        public static boolean contains(String value) {
            return Arrays.stream(UnaryType.values()).anyMatch(ut -> ut.name().equals(value));
        }

        public boolean isVectorScalarPrimitive() {
            return this == VECT_EXP || this == VECT_POW2 || this == VECT_MULT2 || this == VECT_SQRT || this == VECT_LOG || this == VECT_ABS || this == VECT_ROUND || this == VECT_CEIL || this == VECT_FLOOR || this == VECT_SIGN || this == VECT_SIN || this == VECT_COS || this == VECT_TAN || this == VECT_ASIN || this == VECT_ACOS || this == VECT_ATAN || this == VECT_SINH || this == VECT_COSH || this == VECT_TANH || this == VECT_CUMSUM || this == VECT_CUMMIN || this == VECT_CUMMAX || this == VECT_SPROP || this == VECT_SIGMOID;
        }

        public UnaryType getVectorAddPrimitive() {
            return UnaryType.valueOf("VECT_" + this.getVectorPrimitiveName().toUpperCase() + "_ADD");
        }

        public String getVectorPrimitiveName() {
            String[] tmp = this.name().split("_");
            return StringUtils.capitalize((String)tmp[1].toLowerCase());
        }

        public boolean isScalarLookup() {
            return ArrayUtils.contains((Object[])new UnaryType[]{LOOKUP0, LOOKUP_R, LOOKUP_C, LOOKUP_RC}, (Object)((Object)this));
        }

        public boolean isSparseSafeScalar() {
            return ArrayUtils.contains((Object[])new UnaryType[]{POW2, MULT2, ABS, ROUND, CEIL, FLOOR, SIGN, SIN, TAN, SPROP}, (Object)((Object)this));
        }

        public boolean isNotSupportedBySpoofCUDA() {
            return this == VECT_CUMSUM || this == VECT_CUMMIN || this == VECT_CUMMAX || this == VECT_SPROP || this == VECT_SIGMOID;
        }
    }
}

