/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.scheme;

import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class EmptyScheme
implements ICLAScheme {
    final ColGroupEmpty g;

    protected EmptyScheme(ColGroupEmpty g) {
        this.g = g;
    }

    public static EmptyScheme create(ColGroupEmpty g) {
        return new EmptyScheme(g);
    }

    @Override
    public AColGroup encode(MatrixBlock data) {
        return this.encode(data, this.g.getColIndices());
    }

    @Override
    public AColGroup encode(MatrixBlock data, IColIndex columns) {
        if (columns.size() != this.g.getColIndices().size()) {
            throw new IllegalArgumentException("Invalid columns to encode");
        }
        int nCol = data.getNumColumns();
        int nRow = data.getNumRows();
        if (nCol < columns.get(columns.size() - 1)) {
            LOG.warn((Object)"Invalid to encode matrix with less columns than encode scheme max column");
            return null;
        }
        if (data.isEmpty()) {
            return this.returnG(columns);
        }
        if (data.isInSparseFormat()) {
            return this.encodeSparse(data, columns, nRow, nCol);
        }
        if (data.getDenseBlock().isContiguous()) {
            return this.encodeDense(data, columns, nRow, nCol);
        }
        return this.encodeGeneric(data, columns, nRow, nCol);
    }

    private AColGroup encodeDense(MatrixBlock data, IColIndex cols, int nRow, int nCol) {
        double[] dv = data.getDenseBlockValues();
        for (int r = 0; r < nRow; ++r) {
            int off = r * nCol;
            for (int ci = 0; ci < cols.size(); ++ci) {
                if (dv[off + cols.get(ci)] == 0.0) continue;
                return null;
            }
        }
        return this.g;
    }

    private AColGroup encodeSparse(MatrixBlock data, IColIndex cols, int nRow, int nCol) {
        SparseBlock sb = data.getSparseBlock();
        for (int r = 0; r < nRow; ++r) {
            if (sb.isEmpty(r)) continue;
            int apos = sb.pos(r);
            int alen = apos + sb.size(r);
            int[] aix = sb.indexes(r);
            int p = 0;
            for (int j = apos; j < alen; ++j) {
                while (p < cols.size() && cols.get(p) < aix[j]) {
                    ++p;
                }
                if (p < cols.size() && aix[j] == cols.get(p)) {
                    return null;
                }
                if (p < cols.size()) continue;
            }
        }
        return this.returnG(cols);
    }

    private AColGroup encodeGeneric(MatrixBlock data, IColIndex cols, int nRow, int nCol) {
        for (int r = 0; r < nRow; ++r) {
            for (int ci = 0; ci < cols.size(); ++ci) {
                if (data.quickGetValue(r, cols.get(ci)) == 0.0) continue;
                return null;
            }
        }
        return this.returnG(cols);
    }

    private AColGroup returnG(IColIndex columns) {
        if (columns == this.g.getColIndices()) {
            return this.g;
        }
        return new ColGroupEmpty(columns);
    }
}

