/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.io.FrameReader;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.iogen.CustomProperties;
import org.apache.sysds.runtime.iogen.FastStringTokenizer;
import org.apache.sysds.runtime.util.InputStreamInputFormat;
import org.apache.sysds.runtime.util.UtilFunctions;

public abstract class FrameGenerateReader
extends FrameReader {
    protected CustomProperties _props;
    protected final FastStringTokenizer fastStringTokenizerDelim;

    public FrameGenerateReader(CustomProperties _props) {
        this._props = _props;
        this.fastStringTokenizerDelim = new FastStringTokenizer(_props.getDelim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNumRows(List<Path> files, FileSystem fs) throws IOException, DMLRuntimeException {
        int rows = 0;
        for (int fileNo = 0; fileNo < files.size(); ++fileNo) {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(files.get(fileNo))));
            try {
                String value;
                if (this._props.getRowPattern().equals((Object)CustomProperties.GRPattern.Regular)) {
                    while (br.readLine() != null) {
                        ++rows;
                    }
                    continue;
                }
                FastStringTokenizer st = new FastStringTokenizer(this._props.getDelim());
                while ((value = br.readLine()) != null) {
                    st.reset(value);
                    int row = st.nextInt();
                    rows = Math.max(rows, row);
                }
                ++rows;
                continue;
            }
            finally {
                IOUtilFunctions.closeSilently(br);
            }
        }
        return rows;
    }

    @Override
    public FrameBlock readFrameFromHDFS(String fname, Types.ValueType[] schema, String[] names, long rlen, long clen) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        FileInputFormat.addInputPath((JobConf)job, (Path)path);
        FrameGenerateReader.checkValidInputFile(fs, path);
        if (rlen <= 0L) {
            ArrayList<Path> paths = new ArrayList<Path>();
            paths.add(path);
            rlen = this.getNumRows(paths, fs);
        }
        Types.ValueType[] lschema = FrameGenerateReader.createOutputSchema(schema, clen);
        String[] lnames = FrameGenerateReader.createOutputNames(names, clen);
        FrameBlock ret = FrameGenerateReader.createOutputFrameBlock(lschema, lnames, rlen);
        this.readFrameFromHDFS(path, job, fs, ret, lschema, lnames, rlen, clen);
        return ret;
    }

    @Override
    public FrameBlock readFrameFromInputStream(InputStream is, Types.ValueType[] schema, String[] names, long rlen, long clen) throws IOException, DMLRuntimeException {
        Types.ValueType[] lschema = FrameGenerateReader.createOutputSchema(schema, clen);
        String[] lnames = FrameGenerateReader.createOutputNames(names, clen);
        FrameBlock ret = FrameGenerateReader.createOutputFrameBlock(lschema, lnames, rlen);
        InputStreamInputFormat informat = new InputStreamInputFormat(is);
        InputSplit split = informat.getSplits(null, 1)[0];
        this.readFrameFromInputSplit(split, informat, null, ret, schema, names, rlen, clen, 0, true);
        return ret;
    }

    protected void readFrameFromHDFS(Path path, JobConf job, FileSystem fs, FrameBlock dest, Types.ValueType[] schema, String[] names, long rlen, long clen) throws IOException {
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        InputSplit[] splits = informat.getSplits(job, 1);
        splits = IOUtilFunctions.sortInputSplits(splits);
        int rpos = 0;
        for (int i = 0; i < splits.length; ++i) {
            rpos = this.readFrameFromInputSplit(splits[i], (InputFormat<LongWritable, Text>)informat, job, dest, schema, names, rlen, clen, rpos, i == 0);
        }
    }

    protected abstract int readFrameFromInputSplit(InputSplit var1, InputFormat<LongWritable, Text> var2, JobConf var3, FrameBlock var4, Types.ValueType[] var5, String[] var6, long var7, long var9, int var11, boolean var12) throws IOException;

    public static class FrameReaderRowIrregular
    extends FrameGenerateReader {
        public FrameReaderRowIrregular(CustomProperties _props) {
            super(_props);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int readFrameFromInputSplit(InputSplit split, InputFormat<LongWritable, Text> informat, JobConf job, FrameBlock dest, Types.ValueType[] schema, String[] names, long rlen, long clen, int rl, boolean first) throws IOException {
            this.fastStringTokenizerDelim.setNaStrings(this._props.getNaStrings());
            RecordReader reader = informat.getRecordReader(split, job, Reporter.NULL);
            LongWritable key = new LongWritable();
            Text value = new Text();
            int row = rl;
            int col = 0;
            try {
                while (reader.next((Object)key, (Object)value)) {
                    String cellStr = value.toString();
                    this.fastStringTokenizerDelim.reset(cellStr);
                    int ri = this.fastStringTokenizerDelim.nextInt();
                    col = this.fastStringTokenizerDelim.nextInt();
                    String cellValue = this.fastStringTokenizerDelim.nextToken();
                    if (col != -1 && cellValue != null) {
                        dest.set(ri - this._props.getFirstRowIndex(), col - this._props.getFirstColIndex(), UtilFunctions.stringToObject(schema[col - this._props.getFirstColIndex()], cellValue));
                    }
                    row = Math.max(row, ri);
                }
            }
            finally {
                IOUtilFunctions.closeSilently(reader);
            }
            return row;
        }
    }

    public static class FrameReaderRowRegularColIrregular
    extends FrameGenerateReader {
        public FrameReaderRowRegularColIrregular(CustomProperties _props) {
            super(_props);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int readFrameFromInputSplit(InputSplit split, InputFormat<LongWritable, Text> informat, JobConf job, FrameBlock dest, Types.ValueType[] schema, String[] names, long rlen, long clen, int rl, boolean first) throws IOException {
            FastStringTokenizer fastStringTokenizerIndexDelim = new FastStringTokenizer(this._props.getIndexDelim());
            RecordReader reader = informat.getRecordReader(split, job, Reporter.NULL);
            LongWritable key = new LongWritable();
            Text value = new Text();
            int row = rl;
            int col = 0;
            try {
                while (reader.next((Object)key, (Object)value)) {
                    String cellStr = value.toString();
                    this.fastStringTokenizerDelim.reset(cellStr);
                    String cellValueString = this.fastStringTokenizerDelim.nextToken();
                    dest.set(row, (int)clen - 1 - this._props.getFirstColIndex(), UtilFunctions.stringToObject(schema[(int)clen - 1 - this._props.getFirstColIndex()], cellValueString));
                    while (col != -1) {
                        String nt = this.fastStringTokenizerDelim.nextToken();
                        if (this.fastStringTokenizerDelim.getIndex() == -1) break;
                        fastStringTokenizerIndexDelim.reset(nt);
                        col = fastStringTokenizerIndexDelim.nextInt();
                        String cellValue = fastStringTokenizerIndexDelim.nextToken();
                        if (col == -1 || cellValue == null) continue;
                        dest.set(row, col - this._props.getFirstColIndex(), UtilFunctions.stringToObject(schema[col - this._props.getFirstColIndex()], cellValue));
                    }
                    ++row;
                    col = 0;
                }
            }
            finally {
                IOUtilFunctions.closeSilently(reader);
            }
            return row;
        }
    }

    public static class FrameReaderRowRegularColRegular
    extends FrameGenerateReader {
        public FrameReaderRowRegularColRegular(CustomProperties _props) {
            super(_props);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int readFrameFromInputSplit(InputSplit split, InputFormat<LongWritable, Text> informat, JobConf job, FrameBlock dest, Types.ValueType[] schema, String[] names, long rlen, long clen, int rl, boolean first) throws IOException {
            this.fastStringTokenizerDelim.setNaStrings(this._props.getNaStrings());
            RecordReader reader = informat.getRecordReader(split, job, Reporter.NULL);
            LongWritable key = new LongWritable();
            Text value = new Text();
            int row = rl;
            int col = 0;
            HashSet<String> naValues = this._props.getNaStrings();
            try {
                while (reader.next((Object)key, (Object)value)) {
                    String cellStr = value.toString();
                    this.fastStringTokenizerDelim.reset(cellStr);
                    while (col != -1) {
                        String cellValue = this.fastStringTokenizerDelim.nextToken();
                        col = this.fastStringTokenizerDelim.getIndex();
                        if (col == -1 || cellValue == null || naValues != null && naValues.contains(cellValue)) continue;
                        dest.set(row, col, UtilFunctions.stringToObject(schema[col], cellValue));
                    }
                    ++row;
                    col = 0;
                }
            }
            finally {
                IOUtilFunctions.closeSilently(reader);
            }
            return row;
        }
    }
}

