/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public enum GType {
    BIG_DECIMAL(BigDecimal.class),
    BIG_INTEGER(BigInteger.class),
    BOOLEAN(Boolean.class),
    BYTE(Byte.class),
    CHARACTER(Character.class),
    DATETIME(OffsetDateTime.class),
    DOUBLE(Double.class),
    FLOAT(Float.class),
    INTEGER(Integer.class),
    LIST(List.class),
    LONG(Long.class),
    MAP(Map.class),
    SET(Set.class),
    SHORT(Short.class),
    STRING(String.class),
    UNKNOWN(null),
    UUID(UUID.class),
    VERTEX(Vertex.class);

    private Class<?> javaType;

    private GType(Class<?> javaType) {
        this.javaType = javaType;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public boolean isNumeric() {
        return this == BYTE || this == SHORT || this == INTEGER || this == LONG || this == FLOAT || this == DOUBLE || this == BIG_INTEGER || this == BIG_DECIMAL;
    }

    public boolean isCollection() {
        return this == LIST || this == SET;
    }

    public static GType getType(Object object) {
        if (object instanceof String) {
            return STRING;
        }
        if (object instanceof Byte) {
            return BYTE;
        }
        if (object instanceof Short) {
            return SHORT;
        }
        if (object instanceof Character) {
            return CHARACTER;
        }
        if (object instanceof Integer) {
            return INTEGER;
        }
        if (object instanceof Boolean) {
            return BOOLEAN;
        }
        if (object instanceof Float) {
            return FLOAT;
        }
        if (object instanceof Double) {
            return DOUBLE;
        }
        if (object instanceof Long) {
            return LONG;
        }
        if (object instanceof Map) {
            return MAP;
        }
        if (object instanceof List) {
            return LIST;
        }
        if (object instanceof Set) {
            return SET;
        }
        if (object instanceof Vertex) {
            return VERTEX;
        }
        if (object instanceof BigInteger) {
            return BIG_INTEGER;
        }
        if (object instanceof BigDecimal) {
            return BIG_DECIMAL;
        }
        if (object instanceof OffsetDateTime) {
            return DATETIME;
        }
        if (object instanceof UUID) {
            return UUID;
        }
        return UNKNOWN;
    }
}

