/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.hsqldb;

import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.fulcrum.hsqldb.HSQLService;
import org.hsqldb.Server;
import org.hsqldb.persist.HsqlProperties;

public class HSQLServiceImpl
extends AbstractLogEnabled
implements HSQLService,
Configurable,
Initializable,
Startable,
Disposable {
    private Server server;
    private HsqlProperties serverProperties;

    public void configure(Configuration cfg) throws ConfigurationException {
        String[] names = cfg.getAttributeNames();
        for (int i = 0; i < names.length; ++i) {
            this.getLogger().debug(names[i] + " --> " + cfg.getAttribute(names[i]));
        }
        this.serverProperties = new HsqlProperties();
        this.serverProperties.setProperty("server.database.0", cfg.getAttribute("database"));
        this.serverProperties.setProperty("server.dbname.0", cfg.getAttribute("dbname"));
        this.serverProperties.setProperty("server.trace", cfg.getAttributeAsBoolean("trace", false));
        this.serverProperties.setProperty("server.silent", cfg.getAttributeAsBoolean("silent", true));
        this.serverProperties.setProperty("server.port", cfg.getAttribute("port"));
        this.serverProperties.setProperty("server.tls", cfg.getAttribute("tls", "false"));
    }

    public void initialize() throws Exception {
        this.server = new Server();
        this.server.setProperties(this.serverProperties);
    }

    public void start() throws Exception {
        this.server.start();
        this.pollForState(1, 100);
    }

    public void stop() throws Exception {
        this.server.stop();
        this.pollForState(16, 100);
    }

    public void dispose() {
        this.server = null;
        this.serverProperties = null;
    }

    public boolean isOnline() {
        return this.server.getState() == 1;
    }

    private void pollForState(int desiredState, int lim) throws Exception {
        boolean isSuccessful = false;
        this.getLogger().debug("Polling for state : " + desiredState);
        for (int i = 0; i < lim; ++i) {
            int currentState = this.server.getState();
            if (desiredState == currentState) {
                isSuccessful = true;
                break;
            }
            Thread.sleep(100L);
        }
        if (!isSuccessful) {
            Throwable serverError = this.server.getServerError();
            String msg = "Unable to change the HSQLDB server to state : " + desiredState;
            if (serverError != null) {
                this.getLogger().error(msg, serverError);
                if (serverError instanceof Exception) {
                    throw (Exception)serverError;
                }
                throw new RuntimeException(serverError.getMessage());
            }
            this.getLogger().error(msg);
            throw new RuntimeException(msg);
        }
    }
}

