/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.DB;
import org.apache.torque.om.DateKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.SqlEnum;
import org.apache.torque.util.SqlExpression;
import org.apache.torque.util.UniqueList;

public class Criteria
extends Hashtable {
    private static final long serialVersionUID = -9001666575933085601L;
    public static final SqlEnum EQUAL = SqlEnum.EQUAL;
    public static final SqlEnum NOT_EQUAL = SqlEnum.NOT_EQUAL;
    public static final SqlEnum ALT_NOT_EQUAL = SqlEnum.ALT_NOT_EQUAL;
    public static final SqlEnum GREATER_THAN = SqlEnum.GREATER_THAN;
    public static final SqlEnum LESS_THAN = SqlEnum.LESS_THAN;
    public static final SqlEnum GREATER_EQUAL = SqlEnum.GREATER_EQUAL;
    public static final SqlEnum LESS_EQUAL = SqlEnum.LESS_EQUAL;
    public static final SqlEnum LIKE = SqlEnum.LIKE;
    public static final SqlEnum NOT_LIKE = SqlEnum.NOT_LIKE;
    public static final SqlEnum ILIKE = SqlEnum.ILIKE;
    public static final SqlEnum NOT_ILIKE = SqlEnum.NOT_ILIKE;
    public static final SqlEnum CUSTOM = SqlEnum.CUSTOM;
    public static final SqlEnum DISTINCT = SqlEnum.DISTINCT;
    public static final SqlEnum IN = SqlEnum.IN;
    public static final SqlEnum NOT_IN = SqlEnum.NOT_IN;
    public static final SqlEnum ALL = SqlEnum.ALL;
    public static final SqlEnum JOIN = SqlEnum.JOIN;
    private static final SqlEnum ASC = SqlEnum.ASC;
    private static final SqlEnum DESC = SqlEnum.DESC;
    public static final SqlEnum ISNULL = SqlEnum.ISNULL;
    public static final SqlEnum ISNOTNULL = SqlEnum.ISNOTNULL;
    public static final SqlEnum CURRENT_DATE = SqlEnum.CURRENT_DATE;
    public static final SqlEnum CURRENT_TIME = SqlEnum.CURRENT_TIME;
    public static final SqlEnum LEFT_JOIN = SqlEnum.LEFT_JOIN;
    public static final SqlEnum RIGHT_JOIN = SqlEnum.RIGHT_JOIN;
    public static final SqlEnum INNER_JOIN = SqlEnum.INNER_JOIN;
    private static final int DEFAULT_CAPACITY = 10;
    private boolean ignoreCase = false;
    private boolean singleRecord = false;
    private boolean cascade = false;
    private UniqueList selectModifiers = new UniqueList();
    private UniqueList selectColumns = new UniqueList();
    private UniqueList orderByColumns = new UniqueList();
    private UniqueList groupByColumns = new UniqueList();
    private Criterion having = null;
    private OrderedMap asColumns = ListOrderedMap.decorate(new HashMap());
    private transient List joins = new ArrayList(3);
    private String dbName;
    private String originalDbName;
    private int limit = -1;
    private int offset = 0;
    private HashMap aliases = new HashMap(8);
    private boolean useTransaction = false;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$torque$util$Criteria == null ? (class$org$apache$torque$util$Criteria = Criteria.class$("org.apache.torque.util.Criteria")) : class$org$apache$torque$util$Criteria));
    static /* synthetic */ Class class$org$apache$torque$util$Criteria;

    public Criteria() {
        this(10);
    }

    public Criteria(int initialCapacity) {
        this(Torque.getDefaultDB(), initialCapacity);
    }

    public Criteria(String dbName) {
        this(dbName, 10);
    }

    public Criteria(String dbName, int initialCapacity) {
        super(initialCapacity);
        this.dbName = dbName;
        this.originalDbName = dbName;
    }

    public void clear() {
        super.clear();
        this.ignoreCase = false;
        this.singleRecord = false;
        this.cascade = false;
        this.selectModifiers.clear();
        this.selectColumns.clear();
        this.orderByColumns.clear();
        this.groupByColumns.clear();
        this.having = null;
        this.asColumns.clear();
        this.joins.clear();
        this.dbName = this.originalDbName;
        this.offset = 0;
        this.limit = -1;
        this.aliases.clear();
        this.useTransaction = false;
    }

    public Criteria addAsColumn(String name, String clause) {
        this.asColumns.put((Object)name, (Object)clause);
        return this;
    }

    public Map getAsColumns() {
        return this.asColumns;
    }

    public Map getAliases() {
        return this.aliases;
    }

    public void addAlias(String alias, String table) {
        this.aliases.put(alias, table);
    }

    public String getTableForAlias(String alias) {
        return (String)this.aliases.get(alias);
    }

    public boolean containsKey(String table, String column) {
        return this.containsKey(table + '.' + column);
    }

    public boolean getBoolean(String column) {
        return (Boolean)this.getCriterion(column).getValue();
    }

    public boolean getBoolean(String table, String column) {
        return this.getBoolean(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public void setUseTransaction(boolean v) {
        this.useTransaction = v;
    }

    protected boolean isUseTransaction() {
        return this.useTransaction;
    }

    public Criterion getCriterion(String column) {
        return (Criterion)super.get(column);
    }

    public Criterion getCriterion(String table, String column) {
        return this.getCriterion(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public Criterion getNewCriterion(String column, Object value, SqlEnum comparison) {
        return new Criterion(column, value, comparison);
    }

    public Criterion getNewCriterion(String table, String column, Object value, SqlEnum comparison) {
        return new Criterion(table, column, value, comparison);
    }

    public Criteria add(Criterion c) {
        StringBuffer sb = new StringBuffer(c.getTable().length() + c.getColumn().length() + 1);
        sb.append(c.getTable());
        sb.append('.');
        sb.append(c.getColumn());
        super.put(sb.toString(), c);
        return this;
    }

    public String getColumnName(String name) {
        return this.getCriterion(name).getColumn();
    }

    public SqlEnum getComparison(String key) {
        return this.getCriterion(key).getComparison();
    }

    public SqlEnum getComparison(String table, String column) {
        return this.getComparison(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public java.util.Date getDate(String name) {
        return (java.util.Date)this.getCriterion(name).getValue();
    }

    public java.util.Date getDate(String table, String column) {
        return this.getDate(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName == null ? Torque.getDefaultDB() : dbName.trim();
    }

    public double getDouble(String name) {
        Object obj = this.getCriterion(name).getValue();
        if (obj instanceof String) {
            return new Double((String)obj);
        }
        return (Double)obj;
    }

    public double getDouble(String table, String column) {
        return this.getDouble(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public float getFloat(String name) {
        Object obj = this.getCriterion(name).getValue();
        if (obj instanceof String) {
            return new Float((String)obj).floatValue();
        }
        return ((Float)obj).floatValue();
    }

    public float getFloat(String table, String column) {
        return this.getFloat(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public Integer getInteger(String name) {
        Object obj = this.getCriterion(name).getValue();
        if (obj instanceof String) {
            return new Integer((String)obj);
        }
        return (Integer)obj;
    }

    public Integer getInteger(String table, String column) {
        return this.getInteger(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public int getInt(String name) {
        Object obj = this.getCriterion(name).getValue();
        if (obj instanceof String) {
            return new Integer((String)obj);
        }
        return (Integer)obj;
    }

    public int getInt(String table, String column) {
        return this.getInt(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public BigDecimal getBigDecimal(String name) {
        Object obj = this.getCriterion(name).getValue();
        if (obj instanceof String) {
            return new BigDecimal((String)obj);
        }
        return (BigDecimal)obj;
    }

    public BigDecimal getBigDecimal(String table, String column) {
        return this.getBigDecimal(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public long getLong(String name) {
        Object obj = this.getCriterion(name).getValue();
        if (obj instanceof String) {
            return new Long((String)obj);
        }
        return (Long)obj;
    }

    public long getLong(String table, String column) {
        return this.getLong(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public String getString(String name) {
        return (String)this.getCriterion(name).getValue();
    }

    public String getString(String table, String column) {
        return this.getString(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public String getTableName(String name) {
        return this.getCriterion(name).getTable();
    }

    public List getList(String name) {
        return (List)this.getCriterion(name).getValue();
    }

    public List getList(String table, String column) {
        return this.getList(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public Object getValue(String name) {
        return this.getCriterion(name).getValue();
    }

    public Object getValue(String table, String column) {
        return this.getValue(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public ObjectKey getObjectKey(String name) {
        return (ObjectKey)this.getCriterion(name).getValue();
    }

    public ObjectKey getObjectKey(String table, String column) {
        return this.getObjectKey(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public Object get(Object key) {
        return this.getValue((String)key);
    }

    public Object put(Object key, Object value) {
        if (!(key instanceof String)) {
            throw new NullPointerException("Criteria: Key must be a String object.");
        }
        return this.add((String)key, value);
    }

    public synchronized void putAll(Map t) {
        Iterator i = t.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            Object val = e.getValue();
            if (val instanceof Criterion) {
                super.put(e.getKey(), val);
                continue;
            }
            this.put(e.getKey(), val);
        }
        if (t instanceof Criteria) {
            Criteria c = (Criteria)t;
            this.joins = c.joins;
        }
    }

    public Criteria add(String column, Object value) {
        this.add(column, value, EQUAL);
        return this;
    }

    public Criteria add(String column, Object value, SqlEnum comparison) {
        super.put(column, new Criterion(column, value, comparison));
        return this;
    }

    public Criteria add(String table, String column, Object value) {
        this.add(table, column, value, EQUAL);
        return this;
    }

    public Criteria add(String table, String column, Object value, SqlEnum comparison) {
        StringBuffer sb = new StringBuffer(table.length() + column.length() + 1);
        sb.append(table);
        sb.append('.');
        sb.append(column);
        super.put(sb.toString(), new Criterion(table, column, value, comparison));
        return this;
    }

    public Criteria add(String column, boolean value) {
        this.add(column, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public Criteria add(String column, boolean value, SqlEnum comparison) {
        this.add(column, new Boolean(value), comparison);
        return this;
    }

    public Criteria add(String column, int value) {
        this.add(column, new Integer(value));
        return this;
    }

    public Criteria add(String column, int value, SqlEnum comparison) {
        this.add(column, new Integer(value), comparison);
        return this;
    }

    public Criteria add(String column, long value) {
        this.add(column, new Long(value));
        return this;
    }

    public Criteria add(String column, long value, SqlEnum comparison) {
        this.add(column, new Long(value), comparison);
        return this;
    }

    public Criteria add(String column, float value) {
        this.add(column, new Float(value));
        return this;
    }

    public Criteria add(String column, float value, SqlEnum comparison) {
        this.add(column, new Float(value), comparison);
        return this;
    }

    public Criteria add(String column, double value) {
        this.add(column, new Double(value));
        return this;
    }

    public Criteria add(String column, double value, SqlEnum comparison) {
        this.add(column, new Double(value), comparison);
        return this;
    }

    public Criteria addDate(String column, int year, int month, int date) {
        this.add(column, new GregorianCalendar(year, month, date).getTime());
        return this;
    }

    public Criteria addDate(String column, int year, int month, int date, SqlEnum comparison) {
        this.add(column, new GregorianCalendar(year, month, date).getTime(), comparison);
        return this;
    }

    public Criteria addJoin(String left, String right) {
        return this.addJoin(left, right, null);
    }

    public Criteria addJoin(String left, String right, SqlEnum operator) {
        this.joins.add(new Join(left, right, operator));
        return this;
    }

    public List getJoins() {
        return this.joins;
    }

    public List getJoinL() {
        throw new RuntimeException("getJoinL() in Criteria is no longer supported!");
    }

    public List getJoinR() {
        throw new RuntimeException("getJoinL() in Criteria is no longer supported!");
    }

    public Criteria addIn(String column, Object[] values) {
        this.add(column, values, IN);
        return this;
    }

    public Criteria addIn(String column, int[] values) {
        this.add(column, values, IN);
        return this;
    }

    public Criteria addIn(String column, List values) {
        this.add(column, values, IN);
        return this;
    }

    public Criteria addNotIn(String column, Object[] values) {
        this.add(column, values, NOT_IN);
        return this;
    }

    public Criteria addNotIn(String column, int[] values) {
        this.add(column, values, NOT_IN);
        return this;
    }

    public Criteria addNotIn(String column, List values) {
        this.add(column, values, NOT_IN);
        return this;
    }

    public void setAll() {
        this.selectModifiers.add(ALL.toString());
    }

    public void setDistinct() {
        this.selectModifiers.add(DISTINCT.toString());
    }

    public Criteria setIgnoreCase(boolean b) {
        this.ignoreCase = b;
        return this;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Criteria setSingleRecord(boolean b) {
        this.singleRecord = b;
        return this;
    }

    public boolean isSingleRecord() {
        return this.singleRecord;
    }

    public Criteria setCascade(boolean b) {
        this.cascade = b;
        return this;
    }

    public boolean isCascade() {
        return this.cascade;
    }

    public Criteria setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public Criteria setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public Criteria addSelectColumn(String name) {
        this.selectColumns.add(name);
        return this;
    }

    public UniqueList getSelectColumns() {
        return this.selectColumns;
    }

    public UniqueList getSelectModifiers() {
        return this.selectModifiers;
    }

    public Criteria addGroupByColumn(String groupBy) {
        this.groupByColumns.add(groupBy);
        return this;
    }

    public Criteria addAscendingOrderByColumn(String name) {
        this.orderByColumns.add(name + ' ' + ASC);
        return this;
    }

    public Criteria addDescendingOrderByColumn(String name) {
        this.orderByColumns.add(name + ' ' + DESC);
        return this;
    }

    public UniqueList getOrderByColumns() {
        return this.orderByColumns;
    }

    public UniqueList getGroupByColumns() {
        return this.groupByColumns;
    }

    public Criterion getHaving() {
        return this.having;
    }

    public Object remove(String key) {
        Object foo = super.remove(key);
        if (foo instanceof Criterion) {
            return ((Criterion)foo).getValue();
        }
        return foo;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Criteria:: ");
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            sb.append(key).append("<=>").append(super.get(key).toString()).append(":  ");
        }
        try {
            sb.append("\nCurrent Query SQL (may not be complete or applicable): ").append(BasePeer.createQueryDisplayString(this));
        }
        catch (Exception exc) {
            log.debug((Object)"Exception when evaluating a Criteria", (Throwable)exc);
        }
        return sb.toString();
    }

    public boolean equals(Object crit) {
        Criteria criteria;
        boolean isEquiv = false;
        if (crit == null || !(crit instanceof Criteria)) {
            isEquiv = false;
        } else if (this == crit) {
            isEquiv = true;
        } else if (this.size() == ((Criteria)crit).size() && this.offset == (criteria = (Criteria)crit).getOffset() && this.limit == criteria.getLimit() && this.ignoreCase == criteria.isIgnoreCase() && this.singleRecord == criteria.isSingleRecord() && this.cascade == criteria.isCascade() && this.dbName.equals(criteria.getDbName()) && this.selectModifiers.equals(criteria.getSelectModifiers()) && this.selectColumns.equals(criteria.getSelectColumns()) && this.orderByColumns.equals(criteria.getOrderByColumns()) && this.aliases.equals(criteria.getAliases()) && this.asColumns.equals(criteria.getAsColumns()) && ((Object)this.joins).equals(criteria.getJoins())) {
            isEquiv = true;
            Iterator it = criteria.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (this.containsKey(key)) {
                    Criterion b;
                    Criterion a = this.getCriterion(key);
                    if (a.equals(b = criteria.getCriterion(key))) continue;
                    isEquiv = false;
                    break;
                }
                isEquiv = false;
                break;
            }
        }
        return isEquiv;
    }

    public int hashCode() {
        int result = 16;
        result = 37 * result + this.offset;
        result = 37 * result + this.limit;
        result = 37 * result + (this.ignoreCase ? 0 : 1);
        result = 37 * result + (this.singleRecord ? 0 : 1);
        result = 37 * result + (this.cascade ? 0 : 1);
        result = 37 * result + this.dbName.hashCode();
        result = 37 * result + this.selectModifiers.hashCode();
        result = 37 * result + this.selectColumns.hashCode();
        result = 37 * result + this.orderByColumns.hashCode();
        result = 37 * result + this.aliases.hashCode();
        result = 37 * result + this.asColumns.hashCode();
        result = 37 * result + ((Object)this.joins).hashCode();
        result = 37 * result + super.hashCode();
        return result;
    }

    public Criteria addHaving(Criterion having) {
        this.having = having;
        return this;
    }

    public Criteria and(Criterion c) {
        Criterion oc = this.getCriterion(c.getTable() + '.' + c.getColumn());
        if (oc == null) {
            this.add(c);
        } else {
            oc.and(c);
        }
        return this;
    }

    public Criteria and(String column, Object value) {
        this.and(column, value, EQUAL);
        return this;
    }

    public Criteria and(String column, Object value, SqlEnum comparison) {
        Criterion oc = this.getCriterion(column);
        Criterion nc = new Criterion(column, value, comparison);
        if (oc == null) {
            super.put(column, nc);
        } else {
            oc.and(nc);
        }
        return this;
    }

    public Criteria and(String table, String column, Object value) {
        this.and(table, column, value, EQUAL);
        return this;
    }

    public Criteria and(String table, String column, Object value, SqlEnum comparison) {
        StringBuffer sb = new StringBuffer(table.length() + column.length() + 1);
        sb.append(table);
        sb.append('.');
        sb.append(column);
        Criterion oc = this.getCriterion(table, column);
        Criterion nc = new Criterion(table, column, value, comparison);
        if (oc == null) {
            super.put(sb.toString(), nc);
        } else {
            oc.and(nc);
        }
        return this;
    }

    public Criteria and(String column, boolean value) {
        this.and(column, new Boolean(value));
        return this;
    }

    public Criteria and(String column, boolean value, SqlEnum comparison) {
        this.and(column, new Boolean(value), comparison);
        return this;
    }

    public Criteria and(String column, int value) {
        this.and(column, new Integer(value));
        return this;
    }

    public Criteria and(String column, int value, SqlEnum comparison) {
        this.and(column, new Integer(value), comparison);
        return this;
    }

    public Criteria and(String column, long value) {
        this.and(column, new Long(value));
        return this;
    }

    public Criteria and(String column, long value, SqlEnum comparison) {
        this.and(column, new Long(value), comparison);
        return this;
    }

    public Criteria and(String column, float value) {
        this.and(column, new Float(value));
        return this;
    }

    public Criteria and(String column, float value, SqlEnum comparison) {
        this.and(column, new Float(value), comparison);
        return this;
    }

    public Criteria and(String column, double value) {
        this.and(column, new Double(value));
        return this;
    }

    public Criteria and(String column, double value, SqlEnum comparison) {
        this.and(column, new Double(value), comparison);
        return this;
    }

    public Criteria andDate(String column, int year, int month, int date) {
        this.and(column, new GregorianCalendar(year, month, date).getTime());
        return this;
    }

    public Criteria andDate(String column, int year, int month, int date, SqlEnum comparison) {
        this.and(column, new GregorianCalendar(year, month, date).getTime(), comparison);
        return this;
    }

    public Criteria andIn(String column, Object[] values) {
        this.and(column, values, IN);
        return this;
    }

    public Criteria andIn(String column, int[] values) {
        this.and(column, values, IN);
        return this;
    }

    public Criteria andIn(String column, List values) {
        this.and(column, values, IN);
        return this;
    }

    public Criteria andNotIn(String column, Object[] values) {
        this.and(column, values, NOT_IN);
        return this;
    }

    public Criteria andNotIn(String column, int[] values) {
        this.and(column, values, NOT_IN);
        return this;
    }

    public Criteria andNotIn(String column, List values) {
        this.and(column, values, NOT_IN);
        return this;
    }

    public Criteria or(Criterion c) {
        Criterion oc = this.getCriterion(c.getTable() + '.' + c.getColumn());
        if (oc == null) {
            this.add(c);
        } else {
            oc.or(c);
        }
        return this;
    }

    public Criteria or(String column, Object value) {
        this.or(column, value, EQUAL);
        return this;
    }

    public Criteria or(String column, Object value, SqlEnum comparison) {
        Criterion oc = this.getCriterion(column);
        Criterion nc = new Criterion(column, value, comparison);
        if (oc == null) {
            super.put(column, nc);
        } else {
            oc.or(nc);
        }
        return this;
    }

    public Criteria or(String table, String column, Object value) {
        this.or(table, column, value, EQUAL);
        return this;
    }

    public Criteria or(String table, String column, Object value, SqlEnum comparison) {
        StringBuffer sb = new StringBuffer(table.length() + column.length() + 1);
        sb.append(table);
        sb.append('.');
        sb.append(column);
        Criterion oc = this.getCriterion(table, column);
        Criterion nc = new Criterion(table, column, value, comparison);
        if (oc == null) {
            super.put(sb.toString(), nc);
        } else {
            oc.or(nc);
        }
        return this;
    }

    public Criteria or(String column, boolean value) {
        this.or(column, new Boolean(value));
        return this;
    }

    public Criteria or(String column, boolean value, SqlEnum comparison) {
        this.or(column, new Boolean(value), comparison);
        return this;
    }

    public Criteria or(String column, int value) {
        this.or(column, new Integer(value));
        return this;
    }

    public Criteria or(String column, int value, SqlEnum comparison) {
        this.or(column, new Integer(value), comparison);
        return this;
    }

    public Criteria or(String column, long value) {
        this.or(column, new Long(value));
        return this;
    }

    public Criteria or(String column, long value, SqlEnum comparison) {
        this.or(column, new Long(value), comparison);
        return this;
    }

    public Criteria or(String column, float value) {
        this.or(column, new Float(value));
        return this;
    }

    public Criteria or(String column, float value, SqlEnum comparison) {
        this.or(column, new Float(value), comparison);
        return this;
    }

    public Criteria or(String column, double value) {
        this.or(column, new Double(value));
        return this;
    }

    public Criteria or(String column, double value, SqlEnum comparison) {
        this.or(column, new Double(value), comparison);
        return this;
    }

    public Criteria orDate(String column, int year, int month, int date) {
        this.or(column, new GregorianCalendar(year, month, date));
        return this;
    }

    public Criteria orDate(String column, int year, int month, int date, SqlEnum comparison) {
        this.or(column, new GregorianCalendar(year, month, date), comparison);
        return this;
    }

    public Criteria orIn(String column, Object[] values) {
        this.or(column, values, IN);
        return this;
    }

    public Criteria orIn(String column, int[] values) {
        this.or(column, values, IN);
        return this;
    }

    public Criteria orIn(String column, List values) {
        this.or(column, values, IN);
        return this;
    }

    public Criteria orNotIn(String column, Object[] values) {
        this.or(column, values, NOT_IN);
        return this;
    }

    public Criteria orNotIn(String column, int[] values) {
        this.or(column, values, NOT_IN);
        return this;
    }

    public Criteria orNotIn(String column, List values) {
        this.or(column, values, NOT_IN);
        return this;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        ArrayList serializableJoins = null;
        if (!this.joins.isEmpty()) {
            serializableJoins = new ArrayList(this.joins.size());
            Iterator jonisIter = this.joins.iterator();
            while (jonisIter.hasNext()) {
                Join join = (Join)jonisIter.next();
                ArrayList<Object> joinContent = new ArrayList<Object>(3);
                joinContent.add(join.getLeftColumn());
                joinContent.add(join.getRightColumn());
                joinContent.add(join.getJoinType());
                serializableJoins.add(joinContent);
            }
        }
        s.writeObject(serializableJoins);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Iterator iter = this.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Object value = this.get(key);
            if (!(value instanceof Criterion)) continue;
            super.put(key, value);
        }
        this.joins = new ArrayList(3);
        ArrayList joins = (ArrayList)s.readObject();
        if (joins != null) {
            for (int i = 0; i < joins.size(); ++i) {
                ArrayList joinContent = (ArrayList)joins.get(i);
                String leftColumn = (String)joinContent.get(0);
                String rightColumn = (String)joinContent.get(1);
                SqlEnum joinType = null;
                Object joinTypeObj = joinContent.get(2);
                if (joinTypeObj != null) {
                    joinType = (SqlEnum)joinTypeObj;
                }
                this.addJoin(leftColumn, rightColumn, joinType);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Join {
        private String leftColumn = null;
        private String rightColumn = null;
        private SqlEnum joinType = null;

        public Join(String leftColumn, String rightColumn, SqlEnum joinType) {
            this.leftColumn = leftColumn;
            this.rightColumn = rightColumn;
            this.joinType = joinType;
        }

        public final SqlEnum getJoinType() {
            return this.joinType;
        }

        public final String getLeftColumn() {
            return this.leftColumn;
        }

        public final String getRightColumn() {
            return this.rightColumn;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            if (this.joinType != null) {
                result.append(this.joinType).append(" : ");
            }
            result.append(this.leftColumn).append("=").append(this.rightColumn).append(" (ignoreCase not considered)");
            return result.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof Join)) {
                return false;
            }
            Join join = (Join)obj;
            return ObjectUtils.equals((Object)this.leftColumn, (Object)join.getLeftColumn()) && ObjectUtils.equals((Object)this.rightColumn, (Object)join.getRightColumn()) && ObjectUtils.equals((Object)this.joinType, (Object)join.getJoinType());
        }

        public int hashCode() {
            int result = 13;
            result = 37 * result + this.leftColumn.hashCode();
            result = 37 * result + this.rightColumn.hashCode();
            result = 37 * result + (null == this.joinType ? 0 : this.joinType.hashCode());
            return result;
        }
    }

    public final class Criterion
    implements Serializable {
        private static final long serialVersionUID = 7157097965404611710L;
        public static final String AND = " AND ";
        public static final String OR = " OR ";
        private Object value;
        private SqlEnum comparison;
        private String table;
        private String column;
        private boolean ignoreStringCase = false;
        private DB db;
        private List clauses = new ArrayList();
        private List conjunctions = new ArrayList();

        private Criterion(Object val, SqlEnum comp) {
            this.value = val;
            this.comparison = comp;
        }

        Criterion(String table, String column, Object val, SqlEnum comp) {
            this(val, comp);
            this.table = table == null ? "" : table;
            this.column = column == null ? "" : column;
        }

        Criterion(String tableColumn, Object val, SqlEnum comp) {
            this(val, comp);
            int dot = tableColumn.lastIndexOf(46);
            if (dot == -1) {
                this.table = "";
                this.column = tableColumn;
            } else {
                this.table = tableColumn.substring(0, dot);
                this.column = tableColumn.substring(dot + 1);
            }
        }

        Criterion(String table, String column, Object val) {
            this(table, column, val, EQUAL);
        }

        Criterion(String tableColumn, Object val) {
            this(tableColumn, val, EQUAL);
        }

        public String getColumn() {
            return this.column;
        }

        public void setTable(String name) {
            this.table = name;
        }

        public String getTable() {
            return this.table;
        }

        public SqlEnum getComparison() {
            return this.comparison;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public DB getDb() {
            DB db = null;
            if (this.db == null) {
                try {
                    db = Torque.getDB(Criteria.this.getDbName());
                }
                catch (Exception e) {
                    log.error((Object)"Could not get a DB adapter, so sql may be wrong");
                }
            } else {
                db = this.db;
            }
            return db;
        }

        public void setDB(DB v) {
            this.db = v;
            for (int i = 0; i < this.clauses.size(); ++i) {
                ((Criterion)this.clauses.get(i)).setDB(v);
            }
        }

        public Criterion setIgnoreCase(boolean b) {
            this.ignoreStringCase = b;
            return this;
        }

        public boolean isIgnoreCase() {
            return this.ignoreStringCase;
        }

        private List getClauses() {
            return this.clauses;
        }

        private List getConjunctions() {
            return this.conjunctions;
        }

        public Criterion and(Criterion criterion) {
            this.clauses.add(criterion);
            this.conjunctions.add(AND);
            return this;
        }

        public Criterion or(Criterion criterion) {
            this.clauses.add(criterion);
            this.conjunctions.add(OR);
            return this;
        }

        public void appendTo(StringBuffer sb) throws TorqueException {
            if (this.column == null) {
                return;
            }
            Criterion clause = null;
            for (int j = 0; j < this.clauses.size(); ++j) {
                sb.append('(');
            }
            if (CUSTOM == this.comparison) {
                if (this.value != null && !"".equals(this.value)) {
                    sb.append((String)this.value);
                }
            } else {
                String field = null;
                field = this.table == null ? this.column : new StringBuffer(this.table.length() + 1 + this.column.length()).append(this.table).append('.').append(this.column).toString();
                SqlExpression.build(field, this.value, this.comparison, this.ignoreStringCase || Criteria.this.ignoreCase, this.getDb(), sb);
            }
            for (int i = 0; i < this.clauses.size(); ++i) {
                sb.append(this.conjunctions.get(i));
                clause = (Criterion)this.clauses.get(i);
                clause.appendTo(sb);
                sb.append(')');
            }
        }

        public void appendPsTo(StringBuffer sb, List params) {
            if (this.column == null || this.value == null) {
                return;
            }
            DB db = this.getDb();
            for (int j = 0; j < this.clauses.size(); ++j) {
                sb.append('(');
            }
            if (CUSTOM == this.comparison) {
                if (!"".equals(this.value)) {
                    sb.append((String)this.value);
                }
            } else {
                String field = null;
                field = this.table == null ? this.column : new StringBuffer(this.table.length() + 1 + this.column.length()).append(this.table).append('.').append(this.column).toString();
                if (this.comparison.equals(IN) || this.comparison.equals(NOT_IN)) {
                    sb.append(field).append(this.comparison);
                    UniqueList inClause = new UniqueList();
                    if (this.value instanceof List) {
                        this.value = ((List)this.value).toArray(new Object[0]);
                    }
                    for (int i = 0; i < Array.getLength(this.value); ++i) {
                        Object item = Array.get(this.value, i);
                        inClause.add(SqlExpression.processInValue(item, this.ignoreStringCase || Criteria.this.ignoreCase, db));
                    }
                    StringBuffer inString = new StringBuffer();
                    inString.append('(').append(StringUtils.join(inClause.iterator(), (String)",")).append(')');
                    sb.append(inString.toString());
                } else {
                    if (this.ignoreStringCase || Criteria.this.ignoreCase) {
                        sb.append(db.ignoreCase(field)).append(this.comparison).append(db.ignoreCase("?"));
                    } else {
                        sb.append(field).append(this.comparison).append(" ? ");
                    }
                    if (this.value instanceof java.util.Date) {
                        params.add(new Date(((java.util.Date)this.value).getTime()));
                    } else if (this.value instanceof DateKey) {
                        params.add(new Date(((DateKey)this.value).getDate().getTime()));
                    } else if (this.value instanceof Integer) {
                        params.add(this.value);
                    } else {
                        params.add(this.value.toString());
                    }
                }
            }
            for (int i = 0; i < this.clauses.size(); ++i) {
                sb.append(this.conjunctions.get(i));
                Criterion clause = (Criterion)this.clauses.get(i);
                clause.appendPsTo(sb, params);
                sb.append(')');
            }
        }

        public String toString() {
            if (this.column == null) {
                return "";
            }
            StringBuffer expr = new StringBuffer(25);
            try {
                this.appendTo(expr);
            }
            catch (TorqueException e) {
                return "Criterion cannot be evaluated";
            }
            return expr.toString();
        }

        public boolean equals(Object obj) {
            boolean isEquiv;
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof Criterion)) {
                return false;
            }
            Criterion crit = (Criterion)obj;
            boolean bl = isEquiv = (this.table == null && crit.getTable() == null || this.table != null && this.table.equals(crit.getTable())) && this.column.equals(crit.getColumn()) && this.comparison.equals(crit.getComparison());
            if (isEquiv) {
                Object b = crit.getValue();
                isEquiv = this.value instanceof Object[] && b instanceof Object[] ? (isEquiv &= Arrays.equals((Object[])this.value, (Object[])b)) : (this.value instanceof int[] && b instanceof int[] ? (isEquiv &= Arrays.equals((int[])this.value, (int[])b)) : (isEquiv &= this.value.equals(b)));
            }
            isEquiv &= this.clauses.size() == crit.getClauses().size();
            for (int i = 0; i < this.clauses.size(); ++i) {
                isEquiv &= ((String)this.conjunctions.get(i)).equals((String)crit.getConjunctions().get(i));
                isEquiv &= ((Criterion)this.clauses.get(i)).equals((Criterion)crit.getClauses().get(i));
            }
            return isEquiv;
        }

        public int hashCode() {
            int h = this.value.hashCode() ^ this.comparison.hashCode();
            if (this.table != null) {
                h ^= this.table.hashCode();
            }
            if (this.column != null) {
                h ^= this.column.hashCode();
            }
            for (int i = 0; i < this.clauses.size(); ++i) {
                h ^= ((Criterion)this.clauses.get(i)).hashCode();
            }
            return h;
        }

        public List getAllTables() {
            UniqueList tables = new UniqueList();
            this.addCriterionTable(this, tables);
            return tables;
        }

        private void addCriterionTable(Criterion c, UniqueList s) {
            if (c != null) {
                s.add(c.getTable());
                for (int i = 0; i < c.getClauses().size(); ++i) {
                    this.addCriterionTable((Criterion)c.getClauses().get(i), s);
                }
            }
        }

        public Criterion[] getAttachedCriterion() {
            ArrayList crits = new ArrayList();
            this.traverseCriterion(this, crits);
            Criterion[] crita = new Criterion[crits.size()];
            for (int i = 0; i < crits.size(); ++i) {
                crita[i] = (Criterion)crits.get(i);
            }
            return crita;
        }

        private void traverseCriterion(Criterion c, ArrayList a) {
            if (c != null) {
                a.add(c);
                for (int i = 0; i < c.getClauses().size(); ++i) {
                    this.traverseCriterion((Criterion)c.getClauses().get(i), a);
                }
            }
        }
    }
}

