/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.modules.Action;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.parser.ParameterParser;
import org.apache.turbine.util.parser.ParserUtils;

public abstract class ActionEvent
extends Action {
    protected Log log = LogFactory.getLog(this.getClass());
    private static final Class[] methodParams = new Class[]{RunData.class};
    protected static final String BUTTON = "eventSubmit_";
    protected static final int BUTTON_LENGTH = "eventSubmit_".length();
    protected static final String METHOD_NAME_PREFIX = "do";
    protected static final int METHOD_NAME_LENGTH = "do".length();
    protected static final int LENGTH = "eventSubmit_".length();
    private boolean submitValueKey = Turbine.getConfiguration().getBoolean("action.eventsubmit.needsvalue", false);

    public abstract void doPerform(RunData var1) throws Exception;

    public ActionEvent() {
        this.log.debug((Object)(this.submitValueKey ? "ActionEvent accepts only eventSubmit_do Keys with a value != 0" : "ActionEvent accepts all eventSubmit_do Keys"));
    }

    protected void perform(RunData data) throws Exception {
        try {
            this.executeEvents(data);
        }
        catch (NoSuchMethodException e) {
            this.doPerform(data);
        }
    }

    public void executeEvents(RunData data) throws Exception {
        String theButton = null;
        ParameterParser pp = data.getParameters();
        String button = pp.convert(BUTTON);
        String key = null;
        Iterator it = pp.keySet().iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            if (!key.startsWith(button) || !this.considerKey(key, pp)) continue;
            theButton = this.formatString(key);
            break;
        }
        if (theButton == null) {
            throw new NoSuchMethodException("ActionEvent: The button was null");
        }
        try {
            Method method = this.getClass().getMethod(theButton, methodParams);
            Object[] methodArgs = new Object[]{data};
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Invoking " + method));
            }
            method.invoke((Object)this, methodArgs);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw ite;
        }
        finally {
            pp.remove(key);
        }
    }

    protected final String formatString(String input) {
        String tmp = input;
        if (StringUtils.isNotEmpty((String)input)) {
            tmp = input.toLowerCase();
            String string = input = tmp.endsWith(".x") || tmp.endsWith(".y") ? input.substring(0, input.length() - 2) : input;
            if (ParserUtils.getUrlFolding() != 1) {
                tmp = input.toLowerCase().substring(BUTTON_LENGTH + METHOD_NAME_LENGTH);
                tmp = METHOD_NAME_PREFIX + StringUtils.capitalize((String)tmp);
            } else {
                tmp = input.substring(BUTTON_LENGTH);
            }
        }
        return tmp;
    }

    protected boolean considerKey(String key, ParameterParser pp) {
        if (!this.submitValueKey) {
            this.log.debug((Object)("No Value required, accepting " + key));
            return true;
        }
        String keyValue = pp.getString(key);
        this.log.debug((Object)("Key Value is " + keyValue));
        if (StringUtils.isEmpty((String)keyValue)) {
            this.log.debug((Object)("Key is empty, rejecting " + key));
            return false;
        }
        try {
            if (Integer.parseInt(keyValue) != 0) {
                this.log.debug((Object)("Integer != 0, accepting " + key));
                return true;
            }
        }
        catch (NumberFormatException nfe) {
            this.log.debug((Object)("Not a number, accepting " + key));
            return true;
        }
        this.log.debug((Object)("Rejecting " + key));
        return false;
    }
}

