/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.validator.CompareCallback;
import org.apache.fulcrum.intake.validator.Constraint;
import org.apache.fulcrum.intake.validator.FieldReference;
import org.apache.fulcrum.intake.validator.IntegerValidator;
import org.apache.fulcrum.intake.validator.InvalidMaskException;
import org.apache.fulcrum.intake.validator.ValidationException;

public class IntegerRangeValidator
extends IntegerValidator {
    List<FieldReference> fieldReferences;
    CompareCallback<Integer> compareCallback;

    @Override
    public void init(Map<String, ? extends Constraint> paramMap) throws InvalidMaskException {
        super.init(paramMap);
        this.compareCallback = new CompareCallback<Integer>(){

            @Override
            public boolean compareValues(FieldReference.Comparison compare, Integer thisValue, Integer refValue) {
                boolean result = true;
                switch (compare) {
                    case LT: {
                        result = thisValue.compareTo(refValue) < 0;
                        break;
                    }
                    case LTE: {
                        result = thisValue.compareTo(refValue) <= 0;
                        break;
                    }
                    case GT: {
                        result = thisValue.compareTo(refValue) > 0;
                        break;
                    }
                    case GTE: {
                        result = thisValue.compareTo(refValue) >= 0;
                    }
                }
                return result;
            }
        };
        this.fieldReferences = new ArrayList<FieldReference>(10);
        for (Map.Entry<String, ? extends Constraint> entry : paramMap.entrySet()) {
            String key = entry.getKey();
            Constraint constraint = entry.getValue();
            FieldReference.Comparison compare = FieldReference.getComparisonType(key);
            if (compare == null) continue;
            FieldReference fieldref = new FieldReference();
            fieldref.setComparison(compare);
            fieldref.setFieldName(constraint.getValue());
            fieldref.setMessage(constraint.getMessage());
            this.fieldReferences.add(fieldref);
        }
        if (this.fieldReferences.isEmpty()) {
            this.log.warn("No reference field rules have been found.");
        }
    }

    @Override
    public void assertValidity(Field<Integer> testField) throws ValidationException {
        super.assertValidity(testField);
        Group thisGroup = testField.getGroup();
        Locale locale = testField.getLocale();
        if (testField.isMultiValued()) {
            String[] stringValues = (String[])testField.getTestValue();
            for (int i = 0; i < stringValues.length; ++i) {
                this.assertValidity(stringValues[i], thisGroup, locale);
            }
        } else {
            String testValue = (String)testField.getTestValue();
            this.assertValidity(testValue, thisGroup, locale);
        }
    }

    public void assertValidity(String testValue, Group group, Locale locale) throws ValidationException {
        if (this.required || StringUtils.isNotEmpty((CharSequence)testValue)) {
            Integer testInt;
            try {
                testInt = this.parseNumber(testValue, locale);
            }
            catch (NumberFormatException e) {
                this.errorMessage = this.invalidNumberMessage;
                throw new ValidationException(this.invalidNumberMessage);
            }
            try {
                FieldReference.checkReferences(this.fieldReferences, this.compareCallback, testInt, group);
            }
            catch (ValidationException e) {
                this.errorMessage = e.getMessage();
                throw e;
            }
        }
    }
}

