/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import org.apache.uima.internal.util.IntListIterator;
import org.apache.uima.internal.util.Misc;

public abstract class Common_hash_support {
    protected static final boolean TUNE = false;
    private static Common_hash_support tune_instance;
    protected static final int MIN_SIZE = 10;
    protected static final int MIN_CAPACITY = 16;
    protected static final int MIN_CAPACITY_SHRINK = 64;
    protected final float loadFactor;
    protected final int initialCapacity;
    protected int[] histogram;
    protected int maxProbe = 0;
    protected int sizeWhichTriggersExpansion;
    private int size = 0;
    protected int removed = 0;
    protected int found_removed;
    protected boolean secondTimeShrinkable = false;

    public Common_hash_support(int initialSizeBeforeExpanding) {
        this(initialSizeBeforeExpanding, 0.66f);
    }

    public Common_hash_support(int initialSizeBeforeExpanding, float factor) {
        this.loadFactor = factor;
        this.initialCapacity = Common_hash_support.tableSpace(initialSizeBeforeExpanding, Float.valueOf(factor));
    }

    public Common_hash_support(Common_hash_support orig) {
        this(orig.initialCapacity);
        this.sizeWhichTriggersExpansion = orig.sizeWhichTriggersExpansion;
        this.size = orig.size;
        this.removed = orig.removed;
        this.secondTimeShrinkable = orig.secondTimeShrinkable;
        this.histogram = null;
    }

    public void clear() {
        if (this.size + this.removed < this.sizeWhichTriggersExpansion >>> 1) {
            if (this.secondTimeShrinkable) {
                this.secondTimeShrinkable = false;
                int newCapacity = Math.max(this.initialCapacity, this.keys_length() >>> 1);
                if (newCapacity < this.keys_length()) {
                    this.newTable(newCapacity);
                    this.size = 0;
                    this.removed = 0;
                    this.resetHistogram();
                    return;
                }
                this.clearExisting();
                return;
            }
            this.secondTimeShrinkable = true;
        } else {
            this.secondTimeShrinkable = false;
        }
        this.clearExisting();
    }

    private void clearExisting() {
        this.clearKeysAndValues();
        this.size = 0;
        this.removed = 0;
        this.resetHistogram();
    }

    protected int findPosition(int hash, IntPredicate is_eq_or_not_present, IntPredicate is_removed_key) {
        this.found_removed = -1;
        int bitMask = this.keys_length() - 1;
        boolean nbrProbes = true;
        int probeDelta = 0;
        int probeAddr = hash & bitMask;
        while (!is_eq_or_not_present.test(probeAddr)) {
            if (this.found_removed == -1 && is_removed_key.test(probeAddr)) {
                this.found_removed = probeAddr;
            }
            if (probeDelta < 13) {
                ++probeDelta;
            }
            probeAddr = bitMask & probeAddr + probeDelta;
        }
        return probeAddr;
    }

    private void maybeRebalanceRemoves() {
        int old_capacity = this.keys_length();
        if (old_capacity <= 64) {
            return;
        }
        int new_capacity = old_capacity >> 1;
        if (this.removed + this.size >= this.sizeWhichTriggersExpansion) {
            Misc.internalError();
        }
        int one_third_new_capacity = this.sizeWhichTriggersExpansion >> 2;
        int one_half_new_capacity = new_capacity >> 1;
        if (this.removed > one_half_new_capacity || this.size < one_third_new_capacity) {
            if (this.size >= one_third_new_capacity) {
                new_capacity = old_capacity;
            }
            this.copyOld2New(new_capacity, old_capacity);
        }
    }

    private void copyOld2New(int new_capacity, int old_capacity) {
        this.copy_to_new_table(new_capacity, old_capacity, (copyToNew, is_valid_old_key) -> {
            this.newTable(new_capacity);
            this.removed = 0;
            for (int i = 0; i < old_capacity; ++i) {
                if (!is_valid_old_key.test(i)) continue;
                copyToNew.accept(i);
            }
        });
    }

    protected int moveToNextFilled(int pos) {
        int max = this.keys_length();
        if (pos < 0) {
            pos = 0;
        }
        while (pos < max && !this.is_valid_key(pos)) {
            ++pos;
        }
        return pos;
    }

    protected int moveToPreviousFilled(int pos) {
        int max = this.keys_length();
        if (pos > max) {
            pos = max - 1;
        }
        while (pos >= 0 && !this.is_valid_key(pos)) {
            --pos;
        }
        return pos;
    }

    protected void newTable(int capacity) {
        capacity = Math.max(10, Misc.nextHigherPowerOf2(capacity));
        this.newKeysAndValues(capacity);
        this.sizeWhichTriggersExpansion = (int)((float)capacity * this.loadFactor);
    }

    protected void incrementSize() {
        ++this.size;
        if (this.size + this.removed >= this.sizeWhichTriggersExpansion) {
            this.maybeIncreaseTableCapacity();
        }
    }

    private void maybeIncreaseTableCapacity() {
        int old_capacity = this.keys_length();
        int new_capacity = this.removed >= this.size ? old_capacity : 2 * old_capacity;
        this.copyOld2New(new_capacity, old_capacity);
    }

    protected void commonPutOrAddNotFound() {
        if (this.found_removed != -1) {
            --this.removed;
        }
        this.incrementSize();
    }

    protected void commonRemove() {
        ++this.removed;
        --this.size;
        this.maybeRebalanceRemoves();
    }

    public int size() {
        return this.size;
    }

    protected abstract boolean is_valid_key(int var1);

    protected abstract int keys_length();

    protected abstract void newKeysAndValues(int var1);

    protected abstract void clearKeysAndValues();

    protected abstract void copy_to_new_table(int var1, int var2, CommonCopyOld2New var3);

    protected void resetHistogram() {
    }

    private void updateHistogram(int nbrProbes) {
        this.histogram[nbrProbes] = 1 + this.histogram[nbrProbes];
        if (this.maxProbe < nbrProbes) {
            this.maxProbe = nbrProbes;
        }
    }

    public void showHistogram() {
    }

    int getCapacity() {
        return this.keys_length();
    }

    public static int tableSpace(int numberOfElements, Float factor) {
        if (numberOfElements < 0) {
            throw new IllegalArgumentException("must be > 0");
        }
        int capacity = Math.round((float)numberOfElements / factor.floatValue());
        return Math.max(16, Misc.nextHigherPowerOf2(capacity));
    }

    protected void debugValidate() {
        int sum = 0;
        for (int i = 0; i < this.keys_length(); ++i) {
            if (!this.is_valid_key(i) || ++sum <= this.size) continue;
            System.out.println("debug");
        }
    }

    private static /* synthetic */ void lambda$static$1() {
        tune_instance.showHistogram();
    }

    @FunctionalInterface
    public static interface CommonCopyOld2New {
        public void apply(IntConsumer var1, IntPredicate var2);
    }

    protected abstract class CommonKeyIterator
    implements IntListIterator {
        protected int curPosition;
        protected final int firstPosition;

        protected CommonKeyIterator() {
            this.firstPosition = this.curPosition = Common_hash_support.this.moveToNextFilled(0);
        }

        @Override
        public boolean hasNext() {
            return this.curPosition < Common_hash_support.this.keys_length() && this.curPosition >= 0;
        }

        @Override
        public boolean hasPrevious() {
            if (this.curPosition > Common_hash_support.this.keys_length() || this.curPosition <= 0) {
                return false;
            }
            int test = Common_hash_support.this.moveToPreviousFilled(this.curPosition - 1);
            return test >= 0;
        }

        @Override
        public void moveToStart() {
            this.curPosition = Common_hash_support.this.moveToNextFilled(0);
        }

        @Override
        public void moveToEnd() {
            this.curPosition = Common_hash_support.this.moveToPreviousFilled(Common_hash_support.this.keys_length() - 1);
        }
    }
}

