/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile.builder;

import aQute.bnd.classfile.Attribute;
import aQute.bnd.classfile.ClassFile;
import aQute.bnd.classfile.FieldInfo;
import aQute.bnd.classfile.MethodInfo;
import aQute.bnd.classfile.builder.MutableConstantPool;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;

public class ClassFileBuilder {
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final FieldInfo[] EMPTY_FIELD_ARRAY = new FieldInfo[0];
    static final MethodInfo[] EMPTY_METHOD_ARRAY = new MethodInfo[0];
    static final Attribute[] EMPTY_ATTRIBUTE_ARRAY = new Attribute[0];
    private int minor_version;
    private int major_version;
    private MutableConstantPool constant_pool;
    private int access;
    private String this_class;
    private String super_class;
    private final List<String> interfaces = new ArrayList<String>();
    private final List<FieldInfo> fields = new ArrayList<FieldInfo>();
    private final List<MethodInfo> methods = new ArrayList<MethodInfo>();
    private final List<Attribute> attributes = new ArrayList<Attribute>();

    public ClassFileBuilder(int access_flags, int major_version, int minor_version, String this_class, String super_class, Collection<String> interfaces) {
        this.minor_version(minor_version).major_version(major_version).constant_pool(new MutableConstantPool()).access(access_flags).this_class(this_class).super_class(super_class).interfaces(interfaces);
    }

    public ClassFileBuilder(int access_flags, int major_version, int minor_version, String this_class, String super_class, String ... interfaces) {
        this(access_flags, major_version, minor_version, this_class, super_class, Arrays.asList(interfaces));
    }

    public ClassFileBuilder(int access_flags, int major_version, int minor_version, String this_class, String super_class) {
        this(access_flags, major_version, minor_version, this_class, super_class, Collections.emptyList());
    }

    public ClassFileBuilder(ClassFile classFile) {
        this.minor_version(classFile.minor_version).major_version(classFile.major_version).constant_pool(new MutableConstantPool(classFile.constant_pool)).access(classFile.access).this_class(classFile.this_class).super_class(classFile.super_class).interfaces(classFile.interfaces).fields(classFile.fields).methods(classFile.methods).attributes(classFile.attributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Modifier.toString(this.access() & Modifier.classModifiers()));
        if (sb.length() > 0) {
            sb.append(' ');
        }
        if ((this.access() & 0x200) != 0) {
            if ((this.access() & 0x2000) != 0) {
                sb.append('@');
            }
            sb.append("interface ");
        } else if ((this.access() & 0x4000) != 0) {
            sb.append("enum ");
        } else if ((this.access() & 0x8000) == 0) {
            sb.append("class ");
        }
        return sb.append(this.this_class()).toString();
    }

    public int minor_version() {
        return this.minor_version;
    }

    public ClassFileBuilder minor_version(int minor_version) {
        this.minor_version = minor_version;
        return this;
    }

    public int major_version() {
        return this.major_version;
    }

    public ClassFileBuilder major_version(int major_version) {
        this.major_version = major_version;
        return this;
    }

    public MutableConstantPool constant_pool() {
        return this.constant_pool;
    }

    public ClassFileBuilder constant_pool(MutableConstantPool constant_pool) {
        this.constant_pool = Objects.requireNonNull(constant_pool);
        return this;
    }

    public int access() {
        return this.access;
    }

    public ClassFileBuilder access(int access) {
        this.access = access;
        return this;
    }

    public String this_class() {
        return this.this_class;
    }

    public ClassFileBuilder this_class(String this_class) {
        this.this_class = Objects.requireNonNull(this_class);
        return this;
    }

    public String super_class() {
        return this.super_class;
    }

    public ClassFileBuilder super_class(String super_class) {
        this.super_class = super_class;
        return this;
    }

    public List<String> interfaces() {
        return this.interfaces;
    }

    public ClassFileBuilder interfaces(String interfc) {
        Objects.requireNonNull(interfc);
        if (!this.interfaces.contains(interfc)) {
            this.interfaces.add(interfc);
        }
        return this;
    }

    public ClassFileBuilder interfaces(String[] interfcs) {
        for (String i : interfcs) {
            this.interfaces(i);
        }
        return this;
    }

    public ClassFileBuilder interfaces(Collection<String> interfcs) {
        for (String i : interfcs) {
            this.interfaces(i);
        }
        return this;
    }

    public ClassFileBuilder interfaces(String interfc, String ... interfcs) {
        this.interfaces(interfc);
        this.interfaces(interfcs);
        return this;
    }

    public List<FieldInfo> fields() {
        return this.fields;
    }

    public ClassFileBuilder fields(FieldInfo field) {
        Objects.requireNonNull(field);
        ListIterator<FieldInfo> iter = this.fields.listIterator();
        while (iter.hasNext()) {
            FieldInfo member = iter.next();
            if (!member.name.equals(field.name) || !member.descriptor.equals(field.descriptor)) continue;
            iter.remove();
            break;
        }
        this.fields.add(field);
        return this;
    }

    public ClassFileBuilder fields(FieldInfo[] fields) {
        for (FieldInfo f : fields) {
            this.fields(f);
        }
        return this;
    }

    public ClassFileBuilder fields(Collection<FieldInfo> fields) {
        for (FieldInfo f : fields) {
            this.fields(f);
        }
        return this;
    }

    public ClassFileBuilder fields(FieldInfo field, FieldInfo ... fields) {
        this.fields(field);
        this.fields(fields);
        return this;
    }

    public List<MethodInfo> methods() {
        return this.methods;
    }

    public ClassFileBuilder methods(MethodInfo method) {
        Objects.requireNonNull(method);
        ListIterator<MethodInfo> iter = this.methods.listIterator();
        while (iter.hasNext()) {
            MethodInfo member = iter.next();
            if (!member.name.equals(method.name) || !member.descriptor.equals(method.descriptor)) continue;
            iter.remove();
            break;
        }
        this.methods.add(method);
        return this;
    }

    public ClassFileBuilder methods(MethodInfo[] methods) {
        for (MethodInfo m : methods) {
            this.methods(m);
        }
        return this;
    }

    public ClassFileBuilder methods(Collection<MethodInfo> methods) {
        for (MethodInfo m : methods) {
            this.methods(m);
        }
        return this;
    }

    public ClassFileBuilder methods(MethodInfo method, MethodInfo ... methods) {
        this.methods(method);
        this.methods(methods);
        return this;
    }

    public List<Attribute> attributes() {
        return this.attributes;
    }

    public ClassFileBuilder attributes(Attribute attribute) {
        Objects.requireNonNull(attribute);
        this.attributes.add(attribute);
        return this;
    }

    public ClassFileBuilder attributes(Attribute[] attributes) {
        for (Attribute a : attributes) {
            this.attributes(a);
        }
        return this;
    }

    public ClassFileBuilder attributes(Collection<Attribute> attributes) {
        for (Attribute a : attributes) {
            this.attributes(a);
        }
        return this;
    }

    public ClassFileBuilder attributes(Attribute attribute, Attribute ... attributes) {
        this.attributes(attribute);
        this.attributes(attributes);
        return this;
    }

    public ClassFile build() {
        ClassFile classFile = new ClassFile(this.minor_version(), this.major_version(), this.constant_pool(), this.access(), this.this_class(), this.super_class(), this.interfaces().toArray(EMPTY_STRING_ARRAY), this.fields().toArray(EMPTY_FIELD_ARRAY), this.methods().toArray(EMPTY_METHOD_ARRAY), this.attributes().toArray(EMPTY_ATTRIBUTE_ARRAY));
        return classFile;
    }
}

