/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.JarUtils;

public abstract class WhiteBlackList {
    protected Set<String> whitelist;
    protected Set<String> blacklist;
    protected List<String> whitelistPrefixes;
    protected List<String> blacklistPrefixes;
    protected Set<String> whitelistGlobs;
    protected Set<String> blacklistGlobs;
    protected transient List<Pattern> whitelistPatterns;
    protected transient List<Pattern> blacklistPatterns;

    public abstract void addToWhitelist(String var1);

    public abstract void addToBlacklist(String var1);

    public abstract boolean isWhitelistedAndNotBlacklisted(String var1);

    public abstract boolean isWhitelisted(String var1);

    public abstract boolean whitelistHasPrefix(String var1);

    public abstract boolean isBlacklisted(String var1);

    public static String normalizePath(String path) {
        return FileUtils.sanitizeEntryPath(path, true);
    }

    public static String normalizePackageOrClassName(String packageOrClassName) {
        String normalized = packageOrClassName;
        while (normalized.startsWith(".")) {
            normalized = normalized.substring(1);
        }
        while (normalized.endsWith(".")) {
            normalized = normalized.substring(0, normalized.length() - 1);
        }
        return normalized;
    }

    public static String pathToPackageName(String path) {
        return WhiteBlackList.normalizePath(path).replace('/', '.');
    }

    public static String packageNameToPath(String packageName) {
        return WhiteBlackList.normalizePackageOrClassName(packageName).replace('.', '/');
    }

    public static String classNameToClassfilePath(String className) {
        return JarUtils.classNameToClassfilePath(WhiteBlackList.normalizePackageOrClassName(className));
    }

    public static Pattern globToPattern(String glob) {
        return Pattern.compile("^" + glob.replace(".", "\\.").replace("*", ".*") + "$");
    }

    private static boolean matchesPatternList(String str, List<Pattern> patterns) {
        if (patterns != null) {
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(str).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean whitelistIsEmpty() {
        return this.whitelist == null && this.whitelistPrefixes == null && this.whitelistGlobs == null;
    }

    public boolean blacklistIsEmpty() {
        return this.blacklist == null && this.blacklistPrefixes == null && this.blacklistGlobs == null;
    }

    public boolean whitelistAndBlacklistAreEmpty() {
        return this.whitelistIsEmpty() && this.blacklistIsEmpty();
    }

    public boolean isSpecificallyWhitelistedAndNotBlacklisted(String str) {
        return !this.whitelistIsEmpty() && this.isWhitelistedAndNotBlacklisted(str);
    }

    public boolean isSpecificallyWhitelisted(String str) {
        return !this.whitelistIsEmpty() && this.isWhitelisted(str);
    }

    public void sortPrefixes() {
        if (this.whitelistPrefixes != null) {
            Collections.sort(this.whitelistPrefixes);
        }
        if (this.blacklistPrefixes != null) {
            Collections.sort(this.blacklistPrefixes);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.whitelist != null) {
            buf.append("whitelist: ").append(this.whitelist);
        }
        if (this.whitelistPrefixes != null) {
            if (buf.length() > 0) {
                buf.append("; ");
            }
            buf.append("whitelistPrefixes: ").append(this.whitelistPrefixes);
        }
        if (this.whitelistGlobs != null) {
            if (buf.length() > 0) {
                buf.append("; ");
            }
            buf.append("whitelistGlobs: ").append(this.whitelistGlobs);
        }
        if (this.blacklist != null) {
            if (buf.length() > 0) {
                buf.append("; ");
            }
            buf.append("blacklist: ").append(this.blacklist);
        }
        if (this.blacklistPrefixes != null) {
            if (buf.length() > 0) {
                buf.append("; ");
            }
            buf.append("blacklistPrefixes: ").append(this.blacklistPrefixes);
        }
        if (this.blacklistGlobs != null) {
            if (buf.length() > 0) {
                buf.append("; ");
            }
            buf.append("blacklistGlobs: ").append(this.blacklistGlobs);
        }
        return buf.toString();
    }

    public static class WhiteBlackListLeafname
    extends WhiteBlackListWholeString {
        @Override
        public void addToWhitelist(String str) {
            super.addToWhitelist(JarUtils.leafName(str));
        }

        @Override
        public void addToBlacklist(String str) {
            super.addToBlacklist(JarUtils.leafName(str));
        }

        @Override
        public boolean isWhitelistedAndNotBlacklisted(String str) {
            return super.isWhitelistedAndNotBlacklisted(JarUtils.leafName(str));
        }

        @Override
        public boolean isWhitelisted(String str) {
            return super.isWhitelisted(JarUtils.leafName(str));
        }

        @Override
        public boolean whitelistHasPrefix(String str) {
            throw new IllegalArgumentException("Can only find prefixes of whole strings");
        }

        @Override
        public boolean isBlacklisted(String str) {
            return super.isBlacklisted(JarUtils.leafName(str));
        }
    }

    public static class WhiteBlackListWholeString
    extends WhiteBlackList {
        @Override
        public void addToWhitelist(String str) {
            if (str.contains("*")) {
                if (this.whitelistGlobs == null) {
                    this.whitelistGlobs = new HashSet();
                    this.whitelistPatterns = new ArrayList();
                }
                this.whitelistGlobs.add(str);
                this.whitelistPatterns.add(WhiteBlackListWholeString.globToPattern(str));
            } else {
                if (this.whitelist == null) {
                    this.whitelist = new HashSet();
                }
                this.whitelist.add(str);
            }
        }

        @Override
        public void addToBlacklist(String str) {
            if (str.contains("*")) {
                if (this.blacklistGlobs == null) {
                    this.blacklistGlobs = new HashSet();
                    this.blacklistPatterns = new ArrayList();
                }
                this.blacklistGlobs.add(str);
                this.blacklistPatterns.add(WhiteBlackListWholeString.globToPattern(str));
            } else {
                if (this.blacklist == null) {
                    this.blacklist = new HashSet();
                }
                this.blacklist.add(str);
            }
        }

        @Override
        public boolean isWhitelistedAndNotBlacklisted(String str) {
            return (this.whitelist == null && this.whitelistPatterns == null || this.whitelist != null && this.whitelist.contains(str) || WhiteBlackList.matchesPatternList(str, this.whitelistPatterns)) && (this.blacklist == null || !this.blacklist.contains(str)) && !WhiteBlackList.matchesPatternList(str, this.blacklistPatterns);
        }

        @Override
        public boolean isWhitelisted(String str) {
            return this.whitelist == null && this.whitelistPatterns == null || this.whitelist != null && this.whitelist.contains(str) || WhiteBlackList.matchesPatternList(str, this.whitelistPatterns);
        }

        @Override
        public boolean whitelistHasPrefix(String str) {
            if (this.whitelist == null) {
                return false;
            }
            for (String w : this.whitelist) {
                if (!w.startsWith(str)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isBlacklisted(String str) {
            return this.blacklist != null && this.blacklist.contains(str) || WhiteBlackList.matchesPatternList(str, this.blacklistPatterns);
        }
    }

    public static class WhiteBlackListPrefix
    extends WhiteBlackList {
        @Override
        public void addToWhitelist(String str) {
            if (str.contains("*")) {
                throw new IllegalArgumentException("Cannot use a glob wildcard here: " + str);
            }
            if (this.whitelistPrefixes == null) {
                this.whitelistPrefixes = new ArrayList();
            }
            this.whitelistPrefixes.add(str);
        }

        @Override
        public void addToBlacklist(String str) {
            if (str.contains("*")) {
                throw new IllegalArgumentException("Cannot use a glob wildcard here: " + str);
            }
            if (this.blacklistPrefixes == null) {
                this.blacklistPrefixes = new ArrayList();
            }
            this.blacklistPrefixes.add(str);
        }

        @Override
        public boolean isWhitelistedAndNotBlacklisted(String str) {
            boolean isWhitelisted;
            boolean bl = isWhitelisted = this.whitelistPrefixes == null;
            if (!isWhitelisted) {
                for (String prefix : this.whitelistPrefixes) {
                    if (!str.startsWith(prefix)) continue;
                    isWhitelisted = true;
                    break;
                }
            }
            if (!isWhitelisted) {
                return false;
            }
            if (this.blacklistPrefixes != null) {
                for (String prefix : this.blacklistPrefixes) {
                    if (!str.startsWith(prefix)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean isWhitelisted(String str) {
            boolean isWhitelisted;
            boolean bl = isWhitelisted = this.whitelistPrefixes == null;
            if (!isWhitelisted) {
                for (String prefix : this.whitelistPrefixes) {
                    if (!str.startsWith(prefix)) continue;
                    isWhitelisted = true;
                    break;
                }
            }
            return isWhitelisted;
        }

        @Override
        public boolean whitelistHasPrefix(String str) {
            throw new IllegalArgumentException("Can only find prefixes of whole strings");
        }

        @Override
        public boolean isBlacklisted(String str) {
            if (this.blacklistPrefixes != null) {
                for (String prefix : this.blacklistPrefixes) {
                    if (!str.startsWith(prefix)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

