package org.apache.dvsl.directive;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.io.Writer;
import java.io.IOException;

import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.ParserTreeConstants;
import org.apache.velocity.runtime.RuntimeServices;

import org.apache.dvsl.TemplateHandler;

/**
 *  Velocity Directive to handle template registration of
 *  match declarations (like the XSLT match=)
 *
 *  @author <a href="mailto:geirm@apache.org">Geir Magnusson Jr.</a>
 */
public class MatchDirective extends Directive
{
    public String getName()
    {
        return "match";
    }

    public int getType()
    {
        return BLOCK;
    }

    public boolean render( InternalContextAdapter context,
                           Writer writer, Node node)
        throws IOException
    {

        /*
         *  what is our arg?
         */

        Node n = (SimpleNode) node.jjtGetChild(0);

        if ( n.getType() ==  ParserTreeConstants.JJTSTRINGLITERAL)
        {
            try
            {
                String element =(String)((SimpleNode) node.jjtGetChild(0)).value( context );
                TemplateHandler th = (TemplateHandler) rsvc.getApplicationAttribute("org.apache.dvsl.TemplateHandler");

                th.registerMatch( element, (SimpleNode) node.jjtGetChild( node.jjtGetNumChildren() - 1 ) );
            }
            catch( Exception ee )
                {}

        }

        return true;
    }
}
