/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.spring;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.spring.SpringResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class VelocityEngineFactory {
    protected static final Logger logger = LoggerFactory.getLogger(VelocityEngineFactory.class);
    private Resource configLocation;
    private final Map<String, Object> velocityProperties = new HashMap<String, Object>();
    private String resourceLoaderPath;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private boolean preferFileSystemAccess = true;

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setVelocityProperties(Properties velocityProperties) {
        CollectionUtils.mergePropertiesIntoMap((Properties)velocityProperties, this.velocityProperties);
    }

    public void setVelocityPropertiesMap(Map<String, Object> velocityPropertiesMap) {
        if (velocityPropertiesMap != null) {
            this.velocityProperties.putAll(velocityPropertiesMap);
        }
    }

    public void setResourceLoaderPath(String resourceLoaderPath) {
        this.resourceLoaderPath = resourceLoaderPath;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setPreferFileSystemAccess(boolean preferFileSystemAccess) {
        this.preferFileSystemAccess = preferFileSystemAccess;
    }

    protected boolean isPreferFileSystemAccess() {
        return this.preferFileSystemAccess;
    }

    public VelocityEngine createVelocityEngine() throws IOException, VelocityException {
        VelocityEngine velocityEngine = this.newVelocityEngine();
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (this.configLocation != null) {
            logger.info("Loading Velocity config from [{}]", (Object)this.configLocation);
            CollectionUtils.mergePropertiesIntoMap((Properties)PropertiesLoaderUtils.loadProperties((Resource)this.configLocation), props);
        }
        if (!this.velocityProperties.isEmpty()) {
            props.putAll(this.velocityProperties);
        }
        if (this.resourceLoaderPath != null) {
            this.initVelocityResourceLoader(velocityEngine, this.resourceLoaderPath);
        }
        for (Map.Entry entry : props.entrySet()) {
            velocityEngine.setProperty((String)entry.getKey(), entry.getValue());
        }
        this.postProcessVelocityEngine(velocityEngine);
        velocityEngine.init();
        return velocityEngine;
    }

    protected VelocityEngine newVelocityEngine() throws IOException, VelocityException {
        return new VelocityEngine();
    }

    protected void initVelocityResourceLoader(VelocityEngine velocityEngine, String resourceLoaderPath) {
        ResourceLoader loader = this.getResourceLoader();
        if (loader != null && this.isPreferFileSystemAccess()) {
            ArrayList<String> filePaths = new ArrayList<String>();
            ArrayList<String> nonFilePaths = new ArrayList<String>();
            String[] paths = StringUtils.commaDelimitedListToStringArray((String)resourceLoaderPath);
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                if (path.startsWith("classpath:")) {
                    logger.debug("Using SpringResourceLoader for '{}'", (Object)path);
                    nonFilePaths.add(path);
                    continue;
                }
                try {
                    Resource resource = loader.getResource(path);
                    File file = resource.getFile();
                    logger.debug("Resource loader path [{}] resolved to file [{}]", (Object)path, (Object)file.getAbsolutePath());
                    filePaths.add(file.getAbsolutePath());
                    continue;
                }
                catch (IOException ex) {
                    logger.debug("Cannot resolve resource loader path '{}' to filesystem, will use SpringResourceLoader", (Object)path, (Object)ex);
                    nonFilePaths.add(path);
                }
            }
            if (!filePaths.isEmpty()) {
                velocityEngine.setProperty("resource.loaders", (Object)"file");
                velocityEngine.setProperty("resource.loader.file.cache", (Object)"true");
                velocityEngine.setProperty("resource.loader.file.path", (Object)StringUtils.collectionToCommaDelimitedString(filePaths));
            }
            if (!nonFilePaths.isEmpty()) {
                this.initSpringResourceLoader(velocityEngine, StringUtils.collectionToCommaDelimitedString(nonFilePaths));
            }
        } else {
            logger.debug("File system access not preferred: using SpringResourceLoader");
            this.initSpringResourceLoader(velocityEngine, resourceLoaderPath);
        }
    }

    protected void initSpringResourceLoader(VelocityEngine velocityEngine, String resourceLoaderPath) {
        velocityEngine.addProperty("resource.loaders", (Object)"spring");
        velocityEngine.setProperty("spring.resource.loader.class", (Object)SpringResourceLoader.class.getName());
        velocityEngine.setProperty("spring.resource.loader.cache", (Object)"true");
        velocityEngine.setApplicationAttribute((Object)"spring.resource.loader", (Object)this.getResourceLoader());
        velocityEngine.setApplicationAttribute((Object)"spring.resource.loader.path", (Object)resourceLoaderPath);
    }

    protected void postProcessVelocityEngine(VelocityEngine velocityEngine) throws IOException, VelocityException {
    }
}

