/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.settings;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.response.filter.IResponseFilter;
import org.apache.wicket.util.lang.Args;

public class RequestCycleSettings {
    private boolean bufferResponse = true;
    private boolean gatherExtendedBrowserInfo = false;
    private RenderStrategy renderStrategy = RenderStrategy.REDIRECT_TO_BUFFER;
    private List<IResponseFilter> responseFilters;
    private String responseRequestEncoding = "UTF-8";
    private Duration timeout = Duration.ofMinutes(1L);
    private int exceptionRetryCount = 10;

    public RequestCycleSettings addResponseFilter(IResponseFilter responseFilter) {
        if (this.responseFilters == null) {
            this.responseFilters = new ArrayList<IResponseFilter>(3);
        }
        this.responseFilters.add(responseFilter);
        return this;
    }

    public boolean getBufferResponse() {
        return this.bufferResponse;
    }

    public boolean getGatherExtendedBrowserInfo() {
        return this.gatherExtendedBrowserInfo;
    }

    public RenderStrategy getRenderStrategy() {
        return this.renderStrategy;
    }

    public List<IResponseFilter> getResponseFilters() {
        if (this.responseFilters == null) {
            return null;
        }
        return Collections.unmodifiableList(this.responseFilters);
    }

    public String getResponseRequestEncoding() {
        return this.responseRequestEncoding;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public RequestCycleSettings setBufferResponse(boolean bufferResponse) {
        this.bufferResponse = bufferResponse;
        return this;
    }

    public RequestCycleSettings setGatherExtendedBrowserInfo(boolean gatherExtendedBrowserInfo) {
        this.gatherExtendedBrowserInfo = gatherExtendedBrowserInfo;
        return this;
    }

    public RequestCycleSettings setRenderStrategy(RenderStrategy renderStrategy) {
        this.renderStrategy = renderStrategy;
        return this;
    }

    public RequestCycleSettings setResponseRequestEncoding(String encoding) {
        Args.notNull(encoding, "encoding");
        this.responseRequestEncoding = encoding;
        return this;
    }

    public RequestCycleSettings setTimeout(Duration timeout) {
        Args.notNull(timeout, "timeout");
        this.timeout = timeout;
        return this;
    }

    public RequestCycleSettings setExceptionRetryCount(int retries) {
        this.exceptionRetryCount = retries;
        return this;
    }

    public int getExceptionRetryCount() {
        return this.exceptionRetryCount;
    }

    public static enum RenderStrategy {
        ONE_PASS_RENDER,
        REDIRECT_TO_BUFFER,
        REDIRECT_TO_RENDER;

    }
}

